package com.ptteng.wealth.admin.controller;

import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.finance.model.*;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
public class CreditController extends BaseController {

    private static final Log log = LogFactory.getLog(CreditController.class);
    private static final Log creditApplyLog = LogFactory.getLog("credit_apply");
    private static final Log creditApplyCheckLog = LogFactory.getLog("credit_apply_check");

    /**
     * 查询获取待授信人的姓名
     */
    @RequestMapping(value = "/a/u/credit/organization", method = RequestMethod.GET)
    public String getOrganizationDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile, Integer type) throws Exception {

        Long mid = getUserId(request);
        int code = 0;
        Long uid = -1l;
        String name = "";
        log.info("manager : " + mid + " get organization by mobile: " + mobile);
        try {
            Long id = 0L;
            Long relationID = null;
            if (null == mobile) {
                code = -1000;
            } else {
                if (User.TYPE_ORG == type) {
                    relationID = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Org_Mobile);
                } else if (User.TYPE_PERSON == type) {
                    relationID = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);
                }
                if (null == relationID) {
                    code = -2000;
                } else {
                    UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(relationID);
                    uid = userOpenidRelation.getTypeId();
                    if (null == uid) {
                        code = -2008;
                    }
                    User user = userService.getObjectById(uid);
                    if (null != user && user.getFreezeStatus().equals(User.FREEZE_YES)) {
                        code = -3016;
                    }

                    // 新增授信时，如果是个人类型的客户，显示CRM中的客户名称
                    name = user.getName();
                    if (User.TYPE_PERSON == type) {
                        Person person = personService.getObjectById(uid);
                        name = StringUtils.isNotBlank(person.getOrgName()) ? person.getOrgName() : person.getName();
                    }

//                    User user = userService.getObjectById(uid);
//                    if (null == uid) {
//                        code = -2008;
//                    } else if (null != user && user.getFreezeStatus().equals(User.FREEZE_YES)) {
//                        code = -3016;
//                    }
//                    name = user.getName();
                }

            }
            model.addAttribute("ucode", code);
            model.addAttribute("uname", name);
            model.addAttribute("userid", uid);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get organization detail error");
            model.addAttribute("ucode", -1);
        }
        return "/admin/credit/organizationId";
    }


    //申请信用额度
    @RequestMapping(value = "/a/u/credit/apply", method = RequestMethod.POST)
    public String addCreditApply(HttpServletRequest request, ModelMap model, Long uid, BigDecimal lineApply, BigDecimal smallLineApply, String material) throws Exception {

        creditApplyLog.info("=========================================================");
        CreditApply creditApply = new CreditApply();
        Long mid = getUserId(request);
        creditApplyLog.info("Manager : " + mid + " add creditApply USERID: " + uid);
        try {
            if(null == lineApply && null == smallLineApply){
                model.addAttribute("code", -1000);
                creditApplyLog.info("END: no lineApply");
                return "/common/success";
            }
            List<Long> applyIds = creditApplyService.getCreditApplyIdsByUidAndStatus(uid, DebtApply.STATUS_VERIFYING, 0, Integer.MAX_VALUE);
            if (!applyIds.isEmpty()) {
                model.addAttribute("code", -4004);
                creditApplyLog.info("END: user have verifying creditApply");
                return "/common/success";
            }
            User user = userService.getObjectById(uid);
            if (null == user) {
                model.addAttribute("code", -2000);
                creditApplyLog.info("END: user not exist");
                return "/common/success";
            }
            Fund fund = fundService.getObjectById(uid);
            if (null == fund) {
                model.addAttribute("code", -2010);
                creditApplyLog.info("END: fund not exist");
                return "/common/success";
            }

            // 修复一般赊销未扣款老用户中fund中LoanNowTot的数据
            // start
            BigDecimal totalLoanMoney = new BigDecimal("0");
//            List<Long> idLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<Long> idLs = new ArrayList<Long>();
            idLs.addAll(loanApplyService.getLoanApplyIdsByUidAndStatus(uid, LoanApply.STATUS_PASS, 0, Integer.MAX_VALUE));
            idLs.addAll(loanApplyService.getLoanApplyIdsByUidAndStatus(uid, LoanApply.STATUS_REPAY, 0, Integer.MAX_VALUE));
            idLs.addAll(loanApplyService.getLoanApplyIdsByUidAndStatus(uid, LoanApply.STATUS_OVERTIME, 0, Integer.MAX_VALUE));
            creditApplyLog.info(" idLs size : " + idLs.size());
            if (CollectionUtils.isNotEmpty(idLs)) {
                List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(idLs);

                for (LoanApply loanApply : loanApplies) {
                    if (loanApply.getOrderType().equals(LoanApply.ORDER_TYPE_SMALL)) {
                        continue;
                    }
                    totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
                }
                creditApplyLog.info("loanApply totalLoanMoney : " + totalLoanMoney + ", loanNowTot : " + fund.getLoanNowTot());
            }


            List<Long> debtIds = new ArrayList<Long>();
            debtIds.addAll(debtApplyService.getDebtApplyIdsByUidAndStatus(uid, DebtApply.STATUS_PASS, 0, Integer.MAX_VALUE));
            debtIds.addAll(debtApplyService.getDebtApplyIdsByUidAndStatus(uid, DebtApply.STATUS_REPAY, 0, Integer.MAX_VALUE));
            debtIds.addAll(debtApplyService.getDebtApplyIdsByUidAndStatus(uid, DebtApply.STATUS_OVERTIME, 0, Integer.MAX_VALUE));
            creditApplyLog.info(" debtIds size : " + debtIds.size());
            if (CollectionUtils.isNotEmpty(debtIds)) {
                List<DebtApply> debtApplies = debtApplyService.getObjectsByIds(debtIds);
                for (DebtApply debtApply : debtApplies) {
                    totalLoanMoney = totalLoanMoney.add(debtApply.getDebtCount());
                }
                creditApplyLog.info("debtApply totalLoanMoney : " + totalLoanMoney + ", loanNowTot : " + fund.getLoanNowTot());
            }

            if (totalLoanMoney.compareTo(fund.getLoanNowTot()) != 0) {
                fund.setLoanNowTot(totalLoanMoney);
                fundService.update(fund);
            }
            // end

            BigDecimal left = fund.getCreditLine().subtract(fund.getLoanNowTot());
            if (left.doubleValue() < 0) {
                left = new BigDecimal("0.0");
            }
            BigDecimal smallLeft = fund.getSmallLoanLine().subtract(fund.getSmallLoanTot());
            if(smallLeft.doubleValue() < 0){
                smallLeft = new BigDecimal("0.0");
            }

            // 新增授信时，如果是个人类型的客户，显示CRM中的客户名称
            String orgName = user.getName();
            if (user.getType().equals(User.TYPE_PERSON)) {
                Person person = personService.getObjectById(uid);
                if (null != person) {
                    orgName = StringUtils.isNotBlank(person.getOrgName()) ? person.getOrgName() : person.getName();
                }
            }
            creditApply.setUid(uid);
//            creditApply.setOrgName(user.getName());
            creditApply.setOrgName(orgName);
            creditApply.setName("");
            creditApply.setMobile(user.getMobile());
            creditApply.setLineBefore(fund.getCreditLine());
            creditApply.setLineLeft(left);
            creditApply.setLineApply(lineApply);
            creditApply.setSmallLineBefore(fund.getSmallLoanLine());
            creditApply.setSmallLineLeft(smallLeft);
            creditApply.setSmallLineApply(smallLineApply);
            creditApply.setStatus(CreditApply.STATUS_VERIFYING);
            creditApply.setMaterial(material);
            Long id = creditApplyService.insert(creditApply);
            creditApply.setId(id);
            creditApplyLog.info("SUCCESS: " + creditApply);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            creditApplyLog.error(t.getMessage());
            creditApplyLog.error("FAIL: get debtDetail error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //申请信用额度
    @RequestMapping(value = "/a/u/credit/material/{id}", method = RequestMethod.PUT)
    public String updateMaterial(HttpServletRequest request, ModelMap model, String material, @PathVariable Long id) throws Exception {

        creditApplyLog.info("=========================================================");
        Long mid = getUserId(request);
        creditApplyLog.info("Manager : " + mid + " update creditApply : " + id + " material : " + material);
        try {
            CreditApply apply = creditApplyService.getObjectById(id);
            if (null == apply) {
                model.addAttribute("code", -4004);
                creditApplyLog.info("END: credit apply not exist");
                return "/common/success";
            }

            apply.setMaterial(material);
            creditApplyService.update(apply);
            creditApplyLog.info("SUCCESS: " + apply);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            creditApplyLog.error(t.getMessage());
            creditApplyLog.error("FAIL: update creditApply material error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //额度申请审批
    @RequestMapping(value = "/a/u/credit/apply/{id}", method = RequestMethod.PUT)
    public String updateCreditApply(HttpServletRequest request,  ModelMap model, @PathVariable Long id,
                                    Integer status, BigDecimal newCreditLine, BigDecimal newSmallCreditLine, String refuseReason) throws Exception {
        creditApplyCheckLog.info("=================================================");
        creditApplyCheckLog.info(" id: "+id+"  status: "+status+"  newCreditLine: "+newCreditLine+"  refusetReason: "+refuseReason);
        Long mid = getUserId(request);
        creditApplyCheckLog.info("manager : " + mid + "update creditApply " + id);
        Manager manager = managerService.getObjectById(mid);
        try {
            if (!(CreditApply.STATUS_PASS.equals(status) || CreditApply.STATUS_REFUSE.equals(status))) {
                creditApplyCheckLog.info("params status illegal");
                model.addAttribute("code", -4002);
                return "/common/success";
            }
            CreditApply creditApply = creditApplyService.getObjectById(id);
            Long uid = creditApply.getUid();
            Integer oldStatus = creditApply.getStatus();

            //只能审批处于申请中的请求
            if (!CreditApply.STATUS_VERIFYING.equals(oldStatus)) {
                creditApplyCheckLog.info("credit apply status not verify");
                model.addAttribute("code", -4001);
                return "/common/success";
            }

            Fund fund = fundService.getObjectById(uid);
            if (null == fund) {
                model.addAttribute("code", -2010);
                creditApplyLog.info("END: fund not exist");
                return "/common/success";
            }

            if (CreditApply.STATUS_PASS.equals(status)) {
                if(null != newCreditLine && null == newSmallCreditLine){
                    creditApply.setLineFinal(newCreditLine);
                    fund.setCreditLine(newCreditLine);
                    fundService.update(fund);
                }else if(null != newSmallCreditLine && null == newCreditLine){
                    creditApply.setSmallLineFinal(newSmallCreditLine);
                    fund.setSmallLoanLine(newSmallCreditLine);
                    fundService.update(fund);
                }else if(null != newSmallCreditLine && null != newCreditLine){
                    creditApply.setSmallLineFinal(newSmallCreditLine);
                    creditApply.setLineFinal(newCreditLine);
                    fund.setSmallLoanLine(newSmallCreditLine);
                    fund.setCreditLine(newCreditLine);
                    fundService.update(fund);
                }else {
                    model.addAttribute("code", -1000);
                    creditApplyLog.info("END: newCreditLine and newSmallCreditLine both null");
                    return "/common/success";
                }

                BigDecimal left = fund.getCreditLine().subtract(fund.getLoanNowTot());
                if (left.doubleValue() < 0) {
                    left = new BigDecimal(0.0);
                }
                creditApply.setLineLeft(left);

                BigDecimal smallLeft = fund.getSmallLoanLine().subtract(fund.getSmallLoanTot());
                if (smallLeft.doubleValue() < 0) {
                    left = new BigDecimal(0.0);
                }
                creditApply.setSmallLineLeft(smallLeft);

            } else {
                creditApply.setReason(refuseReason);
            }

            creditApply.setVerifyManager(manager.getId());
            creditApply.setStatus(status);
            creditApply.setVerifyAt(System.currentTimeMillis());
            creditApplyService.update(creditApply);
            creditApplyCheckLog.info("SUCCESS  : new status: "+status);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            creditApplyCheckLog.error(t.getMessage());
            creditApplyCheckLog.error("get debtDetail error");
            // for test
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //用户额度申请列表
    @RequestMapping(value = "/a/u/credit/apply/list", method = RequestMethod.GET)
    public String getCreditApplyList(ModelMap model, String mobile, String name, String orgName, Long applyStart, Long applyEnd, Integer status, Integer page,
                                     Integer size) throws Exception {

        log.info("get credit apply list : mobile = " + mobile + " name = " + name + " orgName = " + orgName + " applyStart = " + applyStart + " applyEnd = " + applyEnd + " status = " + status);
        log.info(" page = " + page + " size = " + size + " name = ");
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);
        Map<Long,String> managerMap = new HashMap<Long,String>();
        try {
            Map<String, Object> solutionListParam = DynamicUtil.getCreditApplyListParam(mobile,  orgName, applyStart, applyEnd, status, false);
            List<Long> idLs = creditApplyService.getIdsByDynamicCondition(CreditApply.class, solutionListParam, start, size);
            solutionListParam = DynamicUtil.getCreditApplyListParam(mobile, orgName, applyStart, applyEnd, status, true);
            Long total = creditApplyService.getIdsByDynamicCondition(CreditApply.class, solutionListParam, 0, 10).get(0);

            if (idLs.size() > 0) {
                List<CreditApply> creditApplies = creditApplyService.getObjectsByIds(idLs);
                model.addAttribute("creditApplies", creditApplies);
                List<Long> managerIds = new ArrayList<Long>();

                for(CreditApply creditApply:creditApplies){
                    if(null != creditApply.getVerifyManager() && -1L != creditApply.getVerifyManager()){
                        managerIds.add(creditApply.getVerifyManager());
                    }
                }
                List<Manager> managers = managerService.getObjectsByIds(managerIds);
                for(Manager manager: managers){
                    for(CreditApply creditApply : creditApplies){
                        if(null!= creditApply && null != creditApply.getVerifyManager() &&manager.getId().equals(creditApply.getVerifyManager())){
                            managerMap.put(creditApply.getVerifyManager(),manager.getNick());
                        }
                    }
                }
                managerMap.put(-1L, "自动授信");
            }
            model.addAttribute("total", total);
            model.addAttribute("code", 0);
            model.addAttribute("totalPage", totalPage(size,Integer.parseInt(total+"")));
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("managerMap",managerMap);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get debtApply error");
            model.addAttribute("code", -1);
        }

        return "/admin/credit/getCreditApplyList";
    }


    /**
     * @param
     * @return
     * @throws Exception
     */

    //查看用户概况信息
    @RequestMapping(value = "/a/u/credit/user/detail/{id}", method = RequestMethod.GET)
    public String getUserDetail(HttpServletRequest request, HttpServletResponse response, ModelMap
            model, @PathVariable Long id) throws Exception {

        log.info("get user " + id + " credit detail ");

        try {
            User user = userService.getObjectById(id);
            if (null == user) {
                model.addAttribute("code", -2000);
                log.info("user not exist");
                return "/common/success";
            }else{
                user.setAlias(user.getName());
                log.info(id +" get user : " + user);
            }


            Organization organization = organizationService.getObjectById(id);
            if (null == organization) {
                model.addAttribute("code", -2009);
                log.info("organization not exist");
                return "/common/success";
            }else {
                log.info(id +" get organization : " + organization);
            }

            List<Long> orderIds = orderService.getOrderIdsByUid(id, 0, Integer.MAX_VALUE);

            if(CollectionUtils.isEmpty(orderIds)){
                orderIds = new ArrayList<>();
            }else {
                log.info(id +" get orderIds size : " + orderIds.size());
            }


            List<Order> orders = orderService.getObjectsByIds(orderIds);
            if(CollectionUtils.isEmpty(orders)){
                orders = new ArrayList<>();
            }else {
                log.info(id +" get order size : " + orders.size());
            }


            List<Long> debtApplyIds = debtApplyService.getDebtApplyIdsByUid(id, 0, Integer.MAX_VALUE);
            if(CollectionUtils.isEmpty(debtApplyIds)){
                debtApplyIds = new ArrayList<>();
            }else {
                log.info(id +" get debtApplyIds size : " + debtApplyIds.size());
            }
            List<DebtApply> debtApplies = debtApplyService.getObjectsByIds(debtApplyIds);
            if(CollectionUtils.isEmpty(debtApplies)){
                debtApplies = new ArrayList<>();
            }else {
                log.info(id +" get debtApplies size : " + debtApplies.size());
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("organization", organization);
            model.addAttribute("debtApplies", debtApplies);
            model.addAttribute("orders", orders);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get user " + id + " detail error");
            model.addAttribute("code", -1);

        }

        return "/admin/credit/userDetail";
    }


}
