package com.ptteng.wealth.admin.web;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.model.Module;
import com.ptteng.wealth.admin.model.Records;
import com.ptteng.wealth.admin.model.Role;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.service.ModuleService;
import com.ptteng.wealth.admin.service.RecordsService;
import com.ptteng.wealth.admin.service.RoleService;
import com.ptteng.wealth.admin.util.DynamicUtil;

/**
 * Records  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class RecordsController {
	private static final Log log = LogFactory.getLog(RecordsController.class);

	@Autowired
	private RecordsService recordsService;
	@Autowired
	private RoleService roleService;
	@Autowired
	private ModuleService moduleService;
	@Autowired
	private ManagerService mangerService;
	
	







	
	
	    
	

	@RequestMapping(value = "/a/u/records/{id}", method = RequestMethod.GET)
	public String getRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Records records = recordsService.getObjectById(id);
			log.info("get records data is " + records);

			model.addAttribute("code", 0);

			model.addAttribute("records", records);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get records error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/admin/records/json/recordsDetailJson";
	}

	@RequestMapping(value = "/a/u/records/{id}", method = RequestMethod.PUT)
	public String updateRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Records records) throws Exception {
		
		log.info("update records : records= " + records);
		
		try {
			
			recordsService.update(records);

			model.addAttribute("code", 0);

			model.addAttribute("records", records);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update records error,id is  " + records.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/records", method = RequestMethod.POST)
	public String addRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Records records) throws Exception {
		
		log.info("update records : records= " + records);
		
		try { 
			records.setId(null);

			recordsService.insert(records);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add records error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/records/{id}", method = RequestMethod.DELETE)
	public String deleteRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete records : id= " + id);
		try {
			recordsService.delete(id);

			log.info("add records success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete records error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/u/multi/records", method = RequestMethod.GET)
	public String getMultiRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Records> recordsList = recordsService.getObjectsByIds(idList);
			log.info("get  records data is " + recordsList);

			model.addAttribute("code", 0);
			model.addAttribute("total",recordsList.size());

			model.addAttribute("recordsList", recordsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get records error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/admin/records/json/recordsListJson";
	}
	
	
	@RequestMapping(value = "/a/u/records/search", method = RequestMethod.GET)
	public String search(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, 
			Long managerID, String managerName,Long moduleID, String moduleName,Long roleID, String roleName, String operate,Long operateStart,Long operateEnd	,Integer status, Integer page, Integer size)
			throws Exception {
		// 这里的name是单元name
		log.info("get data : managerID= " + managerID + " managerName = " + managerName + " moduleID = "
				+ moduleID + " roleID = " + roleID + " roleName=" +roleName+ " operate= " +operate+ " operateStart= " +operateStart+  "operateEnd= " +operateEnd);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Boolean next = false;
		try {

			

			Map<String, Object> param = DynamicUtil.getRecordsListParam(managerID,
					managerName, moduleID, moduleName,roleID, roleName,operate,operateStart,operateEnd,false);

			List<Long> ids = this.recordsService.getIdsByDynamicCondition(
					Records.class, param, start, size+1);
			
			

			if (CollectionUtils.isEmpty(ids)) {
				
				log.info("not get any data ");
				
			} else {
				
				List<Records> list = this.recordsService.getObjectsByIds(ids);
				if(list.size()==size+1){
					log.info("has next page data ");
					next=true;
					list=list.subList(0, size);
				}else{
					log.info(" not get next page data ");
					
				}
			
				Set<Long> rids=new HashSet();
				Set<Long> mids=new HashSet();
				Set<Long> moduleIDS=new HashSet();
				
				for(Records records:list){
					
					rids.add(records.getRoleID());
					mids.add(records.getManagerID());
					moduleIDS.add(records.getModuleID());
				}
				
				List<Role> roles=this.roleService.getObjectsByIds(new ArrayList(rids));
				log.info("get roles size is "+roles.size());
				List<Manager> managers=this.mangerService.getObjectsByIds(new ArrayList(mids));
				log.info("get managers size is "+managers.size());
				List<Module> modules=this.moduleService.getObjectsByIds(new ArrayList(moduleIDS));
				log.info("get modules size is "+modules.size());
				
				Map<Long,Role> rid_role=MyListUtil.convert2Map(Role.class.getDeclaredField("id"), roles);
				Map<Long,Manager> mid_manager=MyListUtil.convert2Map(Manager.class.getDeclaredField("id"), managers);
				Map<Long,Module> mid_module=MyListUtil.convert2Map(Module.class.getDeclaredField("id"), modules);
				
				log.info("get list data is " + list);
				model.addAttribute("list", list);
				model.addAttribute("rid_role", rid_role);
				model.addAttribute("mid_manager", mid_manager);
				model.addAttribute("mid_module", mid_module);

				}
			
		
		
				List<Long> allids = this.recordsService.getIdsByDynamicCondition(
						Records.class, param, 0, Integer.MAX_VALUE);
				
				model.addAttribute("total",allids.size());
				
				
			
			// bookUnitService.getObjectsByIds(ids);

			model.addAttribute("page",page);
			model.addAttribute("size",size);
			model.addAttribute("code", 0);
			model.addAttribute("next", next);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get data error : managerID= " + managerID + " managerName = " + managerName + " moduleID = "
					+ moduleID + " roleID = " + roleID + " roleName=" +roleName+ " operate= " +operate+ " operateStart= " +operateStart+  "operateEnd= " +operateEnd);

			model.addAttribute("code", -100000);
		}

		return "/admin/records/json/list";
	}
	
	
	
	
	
}

