package com.ptteng.wealth.admin.util;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.finance.model.DebtApply;
import com.ptteng.wealth.finance.service.DebtApplyService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;

import static java.lang.Math.ceil;

/**
 * Created by asus on 2016/8/24.
 */
public class DebtApplyUtil {

    @Autowired
    private DebtApplyService debtApplyService;

    private Log log = LogFactory.getLog("debtApplyOver");

    public void debtOver() throws Exception {

        Integer result = 0;
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal dayCount = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;

        log.info("==========1、遍历还款中借款==========");
        List<Long> debtIds = debtApplyService.getDebtApplyIdsByStatus(DebtApply.STATUS_REPAY, 0, Integer.MAX_VALUE);
        List<DebtApply> debtApplies = debtApplyService.getObjectsByIds(debtIds);

        log.info("==========2、检测借款是否逾期==========");
        for (DebtApply debtApply : debtApplies) {
            log.info("debtApply is : " + debtApply.getId());

            repayLine = new BigDecimal(debtApply.getRepayLine());

            //获取当前逾期时间
            debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
            time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

            result = dayCount.compareTo(repayLine);

            if(1 == result){
                debtApply.setStatus(DebtApply.STATUS_OVERTIME);
                debtApply.setType(DebtApply.TYPE_OVERTIME);
                debtApplyService.update(debtApply);
                log.info("update debtApply : " + debtApply.getId() + " success");
            }

        }
    }

}
