package com.ptteng.wealth.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.util.DebtConstant;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.finance.util.FinanceConstant;
import com.ptteng.wealth.finance.util.PayAccountUtil;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.User;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;

import static java.lang.Math.ceil;

/**
 * LoanApply crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class LoanController extends BaseController {
    private static final Log log = LogFactory.getLog("loan");

    @Autowired
    public UserAccountRelationService userAccountRelationService;
    @Autowired
    private FundHistoryService fundHistoryService;


    @RequestMapping(value = "/a/u/loan/search", method = RequestMethod.GET)
    public String deptSearch(ModelMap model, String name, String mobile, String orderNo, Long startAt, Long endAt, Integer status,
                             @RequestParam(required = false, defaultValue = "1") Integer page,
                             @RequestParam(required = false, defaultValue = "10") Integer size) throws Exception {
        log.info("===========================================================");
        log.info("search user data : name: " + name + " mobile: " + mobile + " orderNo: " + orderNo + " status: " + status + " startAt: " + startAt + " endAt: " + endAt);
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Boolean next = false;
        try {
            Map<String, Object> param = DynamicUtil.getLoanListParam(name, mobile, orderNo, startAt, endAt, status, false);
            List<Long> ids = loanApplyService.getIdsByDynamicCondition(LoanApply.class, param, start, size);


            Map<String, Object> cntParam = DynamicUtil.getLoanListParam(name, mobile, orderNo, startAt, endAt, status, true);
            Long totalSize = loanApplyService.getIdsByDynamicCondition(LoanApply.class, cntParam, 0, 1).get(0);

            Long totalPage = (((totalSize - 1)) / (size)) + 1;
            log.info("  totalPage = " + totalPage);
            model.addAttribute("totalPage", totalPage);
            List<LoanApply> loanApplies = new ArrayList<>();
            if (CollectionUtils.isEmpty(ids)) {
                log.info("no ids");

            } else {

                loanApplies = loanApplyService.getObjectsByIds(ids);
                if (loanApplies.size() == size + 1) {
                    log.info("has next page data ");
                    next = true;
                    loanApplies = loanApplies.subList(0, size);
                } else {
                    log.info(" not get next page data ");

                }
//                log.info(list);
                Set<Long> orderIDS = new HashSet();
                Set<Long> userIDS = new HashSet();
                Set<Long> fundIDS = new HashSet();
                Set<Long> managerIDS = new HashSet();
                Manager manager = new Manager();
                Manager secondManager = new Manager();
                Map<Long, String> id_manager = new HashMap<>();
                Map<Long, String> id_secondManager = new HashMap<>();

                // 1. 取order 2.取user 3.取fund
                for (LoanApply loanApply : loanApplies) {

                    orderIDS.add(loanApply.getOrderID());
                    userIDS.add(loanApply.getUid());
                    fundIDS.add(loanApply.getUid());

                    manager = managerService.getObjectById(loanApply.getVerifyBy());
                    secondManager = managerService.getObjectById(loanApply.getSecondVerifyBy());

                    if (null == manager) {
                        id_manager.put(loanApply.getId(), null);
                    } else {
                        id_manager.put(loanApply.getId(), manager.getNick());
                    }

                    if (null == secondManager) {
                        id_secondManager.put(loanApply.getId(), null);
                    } else {
                        id_manager.put(loanApply.getId(), secondManager.getNick());
                    }

                }
                List<Order> orders = this.orderService
                        .getObjectsByIds(new ArrayList(orderIDS));
                List<User> users = this.userService
                        .getObjectsByIds(new ArrayList(userIDS));
                List<Fund> funds = this.fundService
                        .getObjectsByIds(new ArrayList(userIDS));
                List<Manager> managers = this.managerService
                        .getObjectsByIds(new ArrayList(managerIDS));

                List<Organization> orgs = this.organizationService.getObjectsByIds(new ArrayList(userIDS));


                log.info("get list data is " + ids);
                model.addAttribute("loanApplies", loanApplies);
                Map<Long, Order> id_orders = MyListUtil.convert2Map(
                        Order.class.getDeclaredField("id"), orders);

                Map<Long, User> id_users = MyListUtil.convert2Map(
                        User.class.getDeclaredField("id"), users);

                Map<Long, Fund> id_funds = MyListUtil.convert2Map(
                        Fund.class.getDeclaredField("id"), funds);

                Map<Long, Organization> id_orgs = MyListUtil.convert2Map(
                        Organization.class.getDeclaredField("id"), orgs);

                log.info("id_orders " + id_orders);
                log.info("id_users " + id_users);
                log.info("id_manager" + id_manager);
                log.info("id_funds " + id_funds);
                log.info("id_orgs " + id_orgs);


                model.addAttribute("id_orders", id_orders);
                model.addAttribute("id_users", id_users);
                model.addAttribute("id_manager", id_manager);
                model.addAttribute("id_funds", id_funds);
                model.addAttribute("id_orgs", id_orgs);

            }

            model.addAttribute("total", totalSize);
            model.addAttribute("loanApplies", loanApplies);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }
        return "/wealth-admin-web/loan/json/loanListJson";
    }

    // 1初审通过 2终审通过 3驳回
    @RequestMapping(value = "/a/u/loan/{id}/verify/{level}", method = RequestMethod.POST)
    public String verifyDebt(HttpServletRequest request, ModelMap model,
                             @PathVariable Long id, @PathVariable Integer level, Double rate,
                             String comment) throws Exception {// 这里的name是单元name
        log.info("verifyDebt did : " + id + " level id " + level + " rate " + rate + " comment " + comment);
        Long mid = getUserId(request);
        try {
            // 1 初审的话，必须有money
            if (null == level) {
                level = LoanApply.STATUS_KAILIN_PASS;
            }

            // 判断借贷在不在
            LoanApply loanApply = this.loanApplyService.getObjectById(id);
            if (loanApply == null) {
                model.addAttribute("code", -11003);
                return "/data/json";
            }

            if (3 == level) {
                // 驳回
                if (LoanApply.STATUS_VERIFYING.equals(loanApply.getStatus())) {
                    loanApply.setStatus(LoanApply.STATUS_KAILIN_REFUSE);
                    loanApply.setVerifyBy(mid);
                }
                if (LoanApply.STATUS_KAILIN_PASS.equals(loanApply.getStatus())) {
                    loanApply.setStatus(LoanApply.STATUS_REFUSE);
                    loanApply.setSecondVerifyBy(mid);
                }

                loanApply.setReason(comment);
                loanApplyService.update(loanApply);
                Order order = this.orderService.getObjectById(loanApply.getOrderID());
                if (order == null) {
                    log.error(loanApply.getId() + " debt not get any order " + loanApply.getOrderID());
                } else {
                    order.setStatus(Order.STATUS_FAIL);
                    orderService.update(order);
                    log.info(loanApply.getId() + " update order status " + loanApply.getOrderID());
                }

                if (LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())) {
                    //判断借款申请时间是否在今天
                    Long time = MyTimeUtil.getEndTime(loanApply.getCreateAt());

                    if (System.currentTimeMillis() < time) {
                        Long uid = loanApply.getUid();
                        BigDecimal totalFee = loanApply.getDebtCount();
                        Fund fund = fundService.getObjectById(uid);
                        BigDecimal todaySmallLoan = fund.getTodaySmallLoan();
                        fund.setTodaySmallLoan(todaySmallLoan.subtract(totalFee));
                        fundService.update(fund);
                        log.info("update todaySmallLoan success : " + todaySmallLoan + " >>>>>>>>>> " + fund.getTodaySmallLoan());
                    }
                }
            } else {
                if (LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())) {
                    if (null == rate) {
                        model.addAttribute("code", -11000);
                        return "/data/json";
                    }
                }
                // 判断审批金额是否在范围内
                if (1 == level) {
                    if (!LoanApply.STATUS_VERIFYING.equals(loanApply.getStatus())) {
                        model.addAttribute("code", -11009);
                        return "/data/json";
                    }
                    // 第一次审核通过，只更改状态
                    loanApply.setStatus(LoanApply.STATUS_KAILIN_PASS);
                    loanApply.setVerifyAt(System.currentTimeMillis());
                    loanApply.setVerifyBy(mid);

                    if (LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())) {
                        log.info("rate is : " + rate);
                        loanApply.setRate(new BigDecimal(rate.toString()));
                        log.info("rate in loanApply is : " + loanApply.getRate());
                    }

                    log.info("update : " + loanApply);
                    this.loanApplyService.update(loanApply);
                    log.info(loanApply + " first verify success ");
                }
                if (2 == level) {
                    log.info(" second verify ");
                    if (!LoanApply.STATUS_KAILIN_PASS.equals(loanApply.getStatus())) {
                        model.addAttribute("code", -11009);
                        return "/data/json";
                    }
                    // 第二次审核通过，更改状态，增加总贷款，累计的总贷款，应还总额
                    loanApply.setStatus(LoanApply.STATUS_PASS);
                    loanApply.setSecondVerifyAt(System.currentTimeMillis());
                    loanApply.setSecondVerifyBy(mid);
                    loanApply.setType(LoanApply.TYPE_REPAY);
                    loanApply.setDebtAt(System.currentTimeMillis());

                    Fund fund = fundService.getObjectById(loanApply.getUid());
                    // 修复一般赊销未扣减剩余信用的bug
                    if (LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())) {
                        Long time = (loanApply.getRepayLine() - 1) * FinanceConstant.DAILY_TIME;
                        Long overAt = MyTimeUtil.getDateEndTimeMillions(System.currentTimeMillis() + time).getTime();
                        loanApply.setRate(new BigDecimal(rate.toString()));
                        loanApply.setOverAt(overAt);
                        BigDecimal loanNowTot = fund.getLoanNowTot();
                        fund.setLoanNowTot(loanNowTot.add(loanApply.getDebtCount()));
                    } else if (LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())) {
//                        Long uid = loanApply.getUid();
                        BigDecimal totalFee = loanApply.getDebtCount();
//                        Fund fund = fundService.getObjectById(uid);
                        BigDecimal smallLoanTot = fund.getSmallLoanTot();
                        fund.setSmallLoanTot(smallLoanTot.add(totalFee));
                        log.info("update smallLoanTot success : " + smallLoanTot + " >>>>>>>>>> " + fund.getSmallLoanTot());
//                        fundService.update(fund);
                    }
                    fundService.update(fund);

                    log.info("update : " + loanApply);
                    this.loanApplyService.update(loanApply);

                    Order order = orderService.getObjectById(loanApply.getOrderID());
                    order.setStatus(Order.STATUS_COMPLETE);
                    order.setPayAt(System.currentTimeMillis());
                    order.setUpdateAt(System.currentTimeMillis());
                    orderService.update(order);

                    log.info(loanApply + " second verify success ");
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }
        model.addAttribute("code", 0);
        return "/data/json";

    }

    //46、查看赊销详情
    @RequestMapping(value = "/a/u/loan/detail/{id}", method = RequestMethod.GET)
    public String getLoanDetail(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        Long mid = getUserId(request);
        log.info("manager : " + mid + " get debt " + id + " detail");
        try {

            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            //第一步： 获取赊销申请
            LoanApply loanApply = loanApplyService.getObjectById(id);
            //赊销申请是否存在
            if (null == loanApply) {
                model.addAttribute("code", -3007);
                log.info("loan not exist");
                return "/common/success";
            }

            Long uid = loanApply.getUid();
            User user = userService.getObjectById(uid);
            if(user == null){
                log.info("debt user not exist");
                model.addAttribute("code", -4008);
                return "/common/success";
            }

            String repayName = "";
            Long updateId = loanApply.getUpdateBy();
            Manager repayManager = managerService.getObjectById(updateId);
            if(repayManager == null){
                log.info("no manager repay");
            }else {
                repayName = repayManager.getNick();
                log.info("repay manager : " + repayName);
            }


            //第二步： 获取借款申请所对应的订单信息
            Order order = orderService.getObjectById(loanApply.getOrderID());

            //第六步：根据借款申请类型获得详情参数
            if (LoanApply.TYPE_OVERTIME.equals(loanApply.getType())) {
                //借款本金、利率
                BigDecimal debtCount = loanApply.getDebtCount();
                BigDecimal overRate = loanApply.getOverRate();
                BigDecimal rate = loanApply.getRate();

                //获取总借款利息
                BigDecimal repayLine = new BigDecimal(loanApply.getRepayLine());
                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                Long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                Long time = System.currentTimeMillis() - debtStart;
                BigDecimal dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                BigDecimal overRepay = caculate(overTotalRepay, overRate, dayCount);
                BigDecimal totalMoney = overTotalRepay.add(overRepay);

                loanApply.setOverDayCount(dayCount);
                loanApply.setClearOverInte(overRepay);
                loanApply.setRepayTot(totalMoney);
            }
            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("repayName", repayName);
            model.addAttribute("loanApply", loanApply);
            model.addAttribute("order", order);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get debt detail error , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/getLoanDetail";
    }

    //48、赊销还款金额
    @RequestMapping(value = "/a/u/loan/pay/amount/{id}", method = RequestMethod.GET)
    public String getLoanRepayAmount(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        BigDecimal payCount = new BigDecimal("0");
        Integer result = 0;
        Long mid = getUserId(request);
        log.info("====================================================================");
        log.info(" PAY Deposit managerId: " + mid + "  LoanApplyId: " + id );
        try {

            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            LoanApply loanApply = loanApplyService.getObjectById(id);
            log.info("LoanApply  status : " + loanApply.getStatus());
            if (!LoanApply.STATUS_PASS.equals(loanApply.getStatus()) && !LoanApply.STATUS_OVERTIME.equals(loanApply.getStatus())) {
                model.addAttribute("code", -3008);
                log.info("PARAMFAIL: the loan not pass");
                return "/common/success";
            }

            Long uid = loanApply.getUid();
            log.info("loan apply uid : " + uid);
            User user = userService.getObjectById(uid);
            if(null == user){
                log.info("loan apply user not exist !");
                model.addAttribute("code", -11011);
                return "/common/success";
            }

            Long oid = loanApply.getOrderID();
            Order order = orderService.getObjectById(oid);
            if (null == order) {
                model.addAttribute("code", -3015);
                log.info("PARAMFAIL: no such order");
                return "/common/success";
            }

            //生成需要更新的数据，利息，罚息，逾期天数，还款总额，还款时间
            //借款本金、利率
            BigDecimal dayCount = new BigDecimal("0");
            BigDecimal overRepay = new BigDecimal("0");
            BigDecimal totalRepay = new BigDecimal("0");
            BigDecimal debtCount = new BigDecimal("0");
            BigDecimal overRate = new BigDecimal("0");
            BigDecimal repayLine = new BigDecimal("0");
            BigDecimal rate = new BigDecimal("0");
            BigDecimal lx = new BigDecimal("0");
            BigDecimal totalMoney = new BigDecimal("0");

            if (LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())) {
                debtCount = loanApply.getDebtCount();
                overRate = loanApply.getOverRate();
                rate = loanApply.getRate();

                //获取总借款利息
                repayLine = new BigDecimal(loanApply.getRepayLine());
                lx = caculate(debtCount, rate, repayLine);
                totalRepay = lx.add(debtCount);

                //获取当前逾期时间
                long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                long time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
//                if (dayCount.doubleValue() < 0) {
//                    dayCount = new BigDecimal("0");
//                }
                if (dayCount.compareTo(BigDecimal.ZERO) < 0) {
                    dayCount = BigDecimal.ZERO;
                }

                // 已逾期，暂不能还款
                if (dayCount.compareTo(BigDecimal.ZERO) > 0) {
                    model.addAttribute("code", -11012);
                    log.info("loan over time id " + id + ", day count " + dayCount);
                    return "/common/success";
                }

                //获取当前罚息
                overRepay = caculate(totalRepay, overRate, dayCount);

                //待还总额
                totalMoney = totalRepay.add(overRepay);
            } else if (LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())) {
                totalMoney = loanApply.getDebtCount();
            }

            totalMoney = totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP);

            model.addAttribute("code", result);
            model.addAttribute("data", totalMoney);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("update updateDebt deposi , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/data";
    }

    //48、还款
    @RequestMapping(value = "/a/u/loan/pay/{id}", method = RequestMethod.PUT)
    public String updateDebtDeposi(HttpServletRequest request, ModelMap model, @PathVariable Long id, String pwd) throws Exception {

        BigDecimal payCount = new BigDecimal("0");
        Integer result = 0;
        Long mid = getUserId(request);
        log.info("====================================================================");
        log.info(" PAY Deposit managerId: " + mid + "  LoanApplyId: " + id + " pwd: " + pwd );
        try {

            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            LoanApply loanApply = loanApplyService.getObjectById(id);
            log.info("LoanApply  status : " + loanApply.getStatus());
            if (!LoanApply.STATUS_PASS.equals(loanApply.getStatus()) && !LoanApply.STATUS_OVERTIME.equals(loanApply.getStatus())) {
                model.addAttribute("code", -3008);
                log.info("PARAMFAIL: the loan not pass");
                return "/common/success";
            }

            Long uid = loanApply.getUid();
            log.info("loan apply uid : " + uid);
            User user = userService.getObjectById(uid);
            if(null == user){
                log.info("loan apply user not exist !");
                model.addAttribute("code", -11011);
                return "/common/success";
            }

            Long oid = loanApply.getOrderID();
            Order order = orderService.getObjectById(oid);
            if (null == order) {
                model.addAttribute("code", -3015);
                log.info("PARAMFAIL: no such order");
                return "/common/success";
            }

            //管理员密码
            String passwords = manager.getPwd();
            log.info(" pwd : " + pwd + " manager passwords: " + passwords);
            boolean verify = passwords.equals(pwd);
            // TODO 此处的密码验证是错的，不应该验证FSP本系统的密码，因为SSO没有下发密码，正确的做法是通过接口去验证SSO中的密码
            verify = true;
            log.info(" verify: " + verify);
            if (!verify) {
                log.info("manager : " + mid + " wrong password " + pwd);
                model.addAttribute("code", -2004);
                return "/common/success";
            }

            //生成需要更新的数据，利息，罚息，逾期天数，还款总额，还款时间
            //借款本金、利率
            BigDecimal dayCount = new BigDecimal("0");
            BigDecimal overRepay = new BigDecimal("0");
            BigDecimal totalRepay = new BigDecimal("0");
            BigDecimal debtCount = new BigDecimal("0");
            BigDecimal overRate = new BigDecimal("0");
            BigDecimal repayLine = new BigDecimal("0");
            BigDecimal rate = new BigDecimal("0");
            BigDecimal lx = new BigDecimal("0");
            BigDecimal totalMoney = new BigDecimal("0");

            if (LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())) {
                debtCount = loanApply.getDebtCount();
                overRate = loanApply.getOverRate();
                rate = loanApply.getRate();

                //获取总借款利息
                repayLine = new BigDecimal(loanApply.getRepayLine());
                lx = caculate(debtCount, rate, repayLine);
                totalRepay = lx.add(debtCount);

                //获取当前逾期时间
                long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                long time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
//                if (dayCount.doubleValue() < 0) {
//                    dayCount = new BigDecimal("0");
//                }
                if (dayCount.compareTo(BigDecimal.ZERO) < 0) {
                    dayCount = BigDecimal.ZERO;
                }

                // 已逾期，暂不能还款
                if (dayCount.compareTo(BigDecimal.ZERO) > 0) {
                    model.addAttribute("code", -11012);
                    log.info("loan over time id " + id + ", day count " + dayCount);
                    return "/common/success";
                }

                //获取当前罚息
                overRepay = caculate(totalRepay, overRate, dayCount);

                //待还总额
                totalMoney = totalRepay.add(overRepay);
            } else if (LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())) {
                totalMoney = loanApply.getDebtCount();
            }

            totalMoney = totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP);

            //第二步：通过开磷账户进行支付

            log.info(" KAILIN  PAY .. ");
            String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
            //非常关键，获取要支付的开磷账号
            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
            log.info(" accountCode: " + accountCode + "  userAccountId: " + userAccountId + " payCount: " + payCount.doubleValue() + " debtCount: " + loanApply.getDebtCount().doubleValue() + " orderId: " + order + " loanApply: " + loanApply.getId());
            if (null != userAccountId) {

                UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
                BigDecimal beforeTransaction = userAccountRelation.getMoney();
                log.info("repay beforeTransaction : " + beforeTransaction);

                result = userAccountRelationService.shexiaoKL(userAccountId, totalMoney.doubleValue(), lx.doubleValue(), overRepay.doubleValue(), Double.parseDouble(dayCount + ""), System.currentTimeMillis(), id, order.getId(), System.currentTimeMillis());

                if(result == 0){
                    userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
                    BigDecimal afterTransaction = userAccountRelation.getMoney();
                    log.info("repay afterTransaction : " + afterTransaction);

                    Long transactionId = fundHistoryService.insertTransaction(order, user, FundHistory.TYPE_Pay, FundHistory.DETAIL_Repay, userAccountId,
                            totalMoney, null, FundHistory.FLAG_Out, FundHistory.STATUS_Pass, null, beforeTransaction, afterTransaction);
                    log.info("insert transaction success : id " + transactionId);

                    if (LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())) {
                        BigDecimal totalFee = loanApply.getDebtCount();
                        Fund fund = fundService.getObjectById(uid);
                        BigDecimal smallLoanTot = fund.getSmallLoanTot();
                        fund.setSmallLoanTot(smallLoanTot.subtract(totalFee));
                        log.info("update smallLoanTot success : " + smallLoanTot + " >>>>>>>>>> " + fund.getSmallLoanTot());
                        fundService.update(fund);
                    }

                    loanApply = loanApplyService.getObjectById(id);
                    loanApply.setClearAt(System.currentTimeMillis());
                    loanApply.setUpdateAt(mid);
                    loanApplyService.update(loanApply);
                }else {
                    log.info("repay loan error , code : " + result);
                }

            } else {
                result = -3022;
            }
            log.info("DB result: " + result);
            model.addAttribute("code", result);
            log.info("repayment loanApply id " + id + ", manager id " + manager.getId() + ", result " + result + ", totalMoney " + totalMoney);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("update updateDebt deposi , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }



    //计算利息
    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
        log.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
        if (null == rate) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }

}
