package com.ptteng.wealth.admin;

//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.util.AntPathMatcher;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;


public class ArthurFilter extends AbstractCasFilter {
    private String casServerLoginUrl;
    private boolean renew = false;
    private boolean gateway = false;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private String strExcludeFile;
    private String hello;

    private String[] arrExcludeFile = null;

    public ArthurFilter() {
        this.setStrExcludeFile("");
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if(!this.isIgnoreInitConfiguration()) {
            super.initInternal(filterConfig);
            this.setServerName(this.getPropertyFromInitParams(filterConfig, "serverName", (String)null));
            this.setCasServerLoginUrl(this.getPropertyFromInitParams(filterConfig, "casServerLoginUrl", (String)null));
            this.log.trace("Loaded CasServerLoginUrl parameter: " + this.casServerLoginUrl);
            this.setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
            this.log.trace("Loaded renew parameter: " + this.renew);
            this.setGateway(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "gateway", "false")));
            this.log.trace("Loaded gateway parameter: " + this.gateway);
            this.setStrExcludeFile(this.getPropertyFromInitParams(filterConfig, "ExcludeFile", ""));
            this.setHello(this.getPropertyFromInitParams(filterConfig, "hello", ""));
            log.info("Loaded ExcludeFile parameter: " + this.strExcludeFile);
            String gatewayStorageClass = this.getPropertyFromInitParams(filterConfig, "gatewayStorageClass", (String)null);
            if(gatewayStorageClass == null) {
                return;
            }

            try {
                this.gatewayStorage = (GatewayResolver)Class.forName(gatewayStorageClass).newInstance();
            } catch (Exception var4) {
                this.log.error(var4, var4);
                throw new ServletException(var4);
            }
        }

    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.casServerLoginUrl, "casServerLoginUrl cannot be null.");
        if(this.strExcludeFile != null && this.strExcludeFile.trim().length() > 0) {
            this.arrExcludeFile = this.strExcludeFile.split(",");
        }

    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        Assertion assertion = session != null?(Assertion)session.getAttribute("_const_cas_assertion_"):null;
        log.info("Exclude File: "+this.strExcludeFile);
        try{
            if(assertion != null) {
                log.info("not do filter");
                filterChain.doFilter(request, response);
            } else {
                String requestStr = request.getRequestURL().toString();
                log.info("requestStr----->" + requestStr);
                AntPathMatcher matcher = new AntPathMatcher();
                log.info("ExclueFile length"+this.arrExcludeFile.length);
                String serviceUrl;
                if(this.arrExcludeFile != null) {
                    String[] urlToRedirectTo = this.arrExcludeFile;
                    int wasGatewayed = this.arrExcludeFile.length;

                    for(int ticket = 0; ticket < wasGatewayed; ++ticket) {
                        serviceUrl = urlToRedirectTo[ticket];
                        log.info("excludePath:" + serviceUrl);
                        boolean flag = matcher.match(serviceUrl, requestStr);
                        if(!flag) {
                            flag = requestStr.indexOf(serviceUrl) > 0;
                        }

                        if(flag) {
                            log.info("excludePath ----->" + serviceUrl + " pass sso authentication");
                            filterChain.doFilter(request, response);
                            return;
                        }
                    }
                }
                else {
                    log.info("ExclueFile is empty");
                }

                serviceUrl = this.constructServiceUrl(request, response);
                String var16 = CommonUtils.safeGetParameter(request, this.getArtifactParameterName());
                boolean var17 = this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
                log.info("V16: "+var16);
                log.info("V17: "+var17);
                if(!CommonUtils.isNotBlank(var16) && !var17) {
                    this.log.info("no ticket and no assertion found");
                    String modifiedServiceUrl;
                    if(this.gateway) {
                        this.log.info("setting gateway attribute in session");
                        modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
                    } else {
                        modifiedServiceUrl = serviceUrl;
                    }

                    if(this.log.isDebugEnabled()) {
                        this.log.debug("Constructed service url: " + modifiedServiceUrl);
                    }
                    log.info("MODIFY URL: "+modifiedServiceUrl);
                    String var18 = CommonUtils.constructRedirectUrl(this.casServerLoginUrl, this.getServiceParameterName(),this.hello, this.renew, this.gateway);
                    Cookie[] cookies = request.getCookies();
                    if(null!= cookies){
                        for (Cookie cookie : cookies) {
                            cookie.setMaxAge(0);
                            cookie.setValue("");
                            cookie.setPath("/");
                            cookie.setDomain("china-lin.com");
                            response.addCookie(cookie);
                        }
                    }
                    request.setAttribute("b",request.getRequestURI());
                    log.info(" V18: "+var18);
                    request.setAttribute("u",var18);
                    RequestDispatcher rd   =   request.getRequestDispatcher( "/ab");
                    rd.forward(request, response);
//                提交至http://localhost:8080/Test/ooo
//                response.sendRedirect(var18);
                } else {
                    filterChain.doFilter(request, response);
                }
            }

        }
        catch (Exception  e){
            e.printStackTrace(System.out);
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    public void setStrExcludeFile(String strExcludeFile) {
        this.strExcludeFile = strExcludeFile;
    }


    public void setHello(String hello) {
        this.hello = hello;
    }


}
