package com.ptteng.wealth.admin.util;


import com.gemantic.common.util.StringUtil;
import com.gemantic.dal.config.helper.GroupHelper;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.wealth.admin.model.ProductStatistics;
import com.ptteng.wealth.user.model.User;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {
	public static final String Period_Day = "day";
	public static final String Period_Week = "week";
	public static final String Period_Month = "month";
	public static final Log log = LogFactory.getLog(DynamicUtil.class);


	public static Map<String, Object> getStatisticsGroupParam(String period,String productNo,String name,Long startAt,Long endAt) {
		Map<String, Object> params = new HashMap<String, Object>();

		StringBuffer queryParam=new StringBuffer();
		StringBuffer groupParam=new StringBuffer();
		Set<String> tables = new HashSet();
		tables.add("productdaily a ");
		tables.add("product b ");

		queryParam=queryParam.append("a.product_id as product_id,");
		queryParam=queryParam.append("b.`name` as `name`,");
		queryParam=queryParam.append("b.`status` as `status`,");
		queryParam=queryParam.append("SUM(a.buy_count) as buy_count,");
		queryParam=queryParam.append("SUM(a.buy_person_sum) as buy_person_sum,");
		queryParam=queryParam.append("SUM(a.buy_sum_amount) as buy_sum_amount ,");
		queryParam=queryParam.append("SUM(a.withdrawal_amount) as withdrawal_amount,");
		queryParam=queryParam.append("SUM(a.withdrawal_count) as withdrawal_count,");
		queryParam=queryParam.append("SUM(a.withdrawal_person_sum) as withdrawal_person_sum,");
		if(Period_Week.equals(period)){
			queryParam=queryParam.append("DATE_FORMAT( FROM_UNIXTIME ( a.static_at / 1000),'%Y%u' ) as week ");

		}else {
			queryParam=queryParam.append("DATE_FORMAT( FROM_UNIXTIME ( a.static_at / 1000),'%Y%m' ) as week ");

		}

		groupParam=groupParam.append("week, ");
		groupParam=groupParam.append("product_id " );


		if (StringUtil.isNotEmpty(productNo)) {
			params.put(" b.product_no & like ", "'%"+productNo+"%'");

		}

		if (StringUtil.isNotEmpty(name)) {
			params.put("b.name & like", name);

		}




		if (startAt!=null) {

			params.put("a.static_at & >= ",startAt );

		}
		if (endAt!=null) {
			params.put("a.static_at & <= ",endAt );

		}
		params.put("a.product_id","b.id");

		params.put("@query", queryParam.toString());
		params.put("@group", groupParam.toString());
		String table = SQLUtil.convertTable(tables);
		params.put("@order"," week desc");



		params.put("@table", table);

		return params;

	}



	public static Map<String, Object> getProductDailyStatistcsList( String productNo,String name,
																	Long startAt,Long endAt,Long productId,
													  Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();
		Set<String> tables = new HashSet();
		tables.add("productDaily");
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("product.name  & like  ", "'%" + name + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(productNo)) {
			params.put("product.product_no & like ","'%"+ productNo+"%' ");
			params.put("product.id", "productDaily.product_id");
			tables.add("product");
		}


		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" productDaily.static_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" productDaily.static_at & <= ", "'" + endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(productId)) {
			params.put(" productDaily.product_id  ", "'" + productId + "'");
		}

		if (count) {
			params.put("@query", " count(productDaily.id) ");
		} else {
			params.put("@order", "  productDaily.static_at desc ");
			params.put("@query", " productDaily.id");
		}
		String table = convertTable(tables);
		params.put("@table", table);
		return params;
	}
	public static Map<String, Object> getProductList( String productNo,String name,Integer status,Integer productType,
													  Integer buyStatus,Integer fixedInvestmentSatus,
												   Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();
		if (DataUtils.isNotNullOrEmpty(productNo)) {
			params.put("product_no & like ","'%"+ productNo+"%' ");
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name  & like  ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(productType)) {
			params.put("product_type", " '" + productType + "' ");
		}
		if (DataUtils.isNotNullOrEmpty(buyStatus)) {
			params.put("buy_status", " '" +buyStatus + "' ");
		}
		if (DataUtils.isNotNullOrEmpty(fixedInvestmentSatus)) {
			params.put("fixed_investment_satus"," '" + fixedInvestmentSatus + "' ");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", " '" +status + "' ");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  update_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  product ");

		return params;
	}

	public static Map<String, Object> getListParam(Long startAt, Long endAt,
			String type, String createBy, String source, String status,
			Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" update_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" update_at & <= ", "'" + endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("type", type);
		}
		if (DataUtils.isNotNullOrEmpty(createBy)) {
			params.put("create_by", "'" + createBy + "'");
		}
		if (DataUtils.isNotNullOrEmpty(source)) {
			params.put("source", " '" + source + "' ");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}
		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  update_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  article ");

		return params;
	}

	public static Map<String, Object> getRecordsListParam(Long managerID,
														  String managerName, Long moduleID, String moduleName, Long roleID,
														  String roleName, String operate, Long operateStart,
														  Long operateEnd, boolean count) {
		Map<String, Object> params = new HashMap<String, Object>();

		Set<String> tables = new HashSet();
		tables.add("records");

		if (managerID!=null) {
			params.put("records.manager_id", managerID);

		}

		if (StringUtils.isNotBlank(managerName)) {
			params.put("manager.name &like ", "'%" + managerName + "%'");
			params.put("manager.id", "records.manager_id");
			tables.add("manager");

		}

		if (moduleID!=null) {
			params.put("records.module_id", moduleID);

		}

		if (StringUtils.isNotBlank(moduleName)) {
			params.put("module.name &like ", "'%" + moduleName + "%'");
			params.put("module.id", "records.module_id");
			tables.add("module");

		}

		if (roleID!=null) {
			params.put("records.role_id", roleID);

		}

		if (StringUtils.isNotBlank(roleName)) {
			params.put("role.name &like ", "'%" + roleName + "%'");
			params.put("role.id", "records.role_id");
			tables.add("role");

		}

		params.put("records.operate", "operate");



		if (operateStart!=null) {

			params.put("records.operate_at & >= ",operateStart );

		}
		if (operateEnd!=null) {
			params.put("records.operate_at & <= ",operateEnd );

		}


		if (count) {
			params.put("@query", " count(records.id) ");
		} else {


			params.put("@order", "  records.operate_at desc ");

			params.put("@query", " records.id ");
		}

		String table = convertTable(tables);
		params.put("@table", table);

		return params;

	}

	public static Map<String, Object> getCreditApplyListParam(String mobile, String orgName, Long applyStart, Long applyEnd, Integer status, Boolean count) {

		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(applyStart)) {
			params.put(" create_at & >= ", "'" + applyStart + "'");
		}
		if (DataUtils.isNotNullOrEmpty(applyEnd)) {
			params.put(" create_at & <= ", "'" + applyEnd + "'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", mobile);
		}
		if (DataUtils.isNotNullOrEmpty(orgName)) {
			params.put("org_name & like ", "'%" + orgName + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}
		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  update_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  creditapply ");

		return params;
	}



	public static String convertTable(Set<String> tables) {
		StringBuffer tableBuffer = new StringBuffer();
		int index = 0;
		Iterator var4 = tables.iterator();

		while(var4.hasNext()) {
			String table = (String)var4.next();
			++index;
			tableBuffer = tableBuffer.append(table);
			if(index < tables.size()) {
				tableBuffer = tableBuffer.append(",");
			}
		}

		return tableBuffer.toString();
	}

	public static Map<String, Object> getUserListParam(Integer status, Integer type, Integer risk, Long registerStartAt,
													   Long registerEndAt, String name, String mobile, boolean count) {


		Map<String, Object> params = new HashMap<String, Object>();
//		Set<String> tables = new HashSet();
//		tables.add("user");

//		params.put(" person.id", "user.id");
//		params.put(" organization.id", "user.id");
//		tables.add(" person ");
//		tables.add(" organization ");

		if (DataUtils.isNotNullOrEmpty(registerStartAt)) {
			params.put(" user.create_at & >= ", "'" + registerStartAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(registerEndAt)) {
			params.put(" user.create_at & <= ", "'" + registerEndAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("user.freeze_status", status);
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("user.type", type);
		}
		if (DataUtils.isNotNullOrEmpty(risk)) {
			params.put("user.risk", risk);
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" user.name & like ", "'%" + name + "%'");
			params.put(" organization.name & like ", "'%" + name + "%'");
			params.put(" person.org_name & like ", "'%" + name + "%'");
			params.put(" org_apply.name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("user.mobile", mobile);
		}
//        params.put("verify_status", 0);
		if (count) {
			params.put("@query", " count(user.id) ");
		} else {
			params.put("@order", "  user.create_at desc ");
			params.put("@query", " user.id ");
		}
//		String table = convertTable(tables);
		params.put("@table", " ((user left join person on user.id = person.id) left join organization on user.id = organization.id ) left join org_apply on user.mobile = org_apply.mobile");

		return params;
	
	}

	public static List<User> getUserList(Integer status, Integer type, Integer risk, Long registerStartAt,
													   Long registerEndAt, String name, String mobile, Integer start, Integer size) {
		List<User> users = new ArrayList<>();

		try{
			DataSource dataSource = GroupHelper.getDataSource("wealth_user");

			if (DataUtils.isNotNullOrEmpty(dataSource)) {
				log.info("  datasource = " + dataSource);
			} else {
				log.info("  datasource null ");
			}

			SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
			StringBuilder sql = new StringBuilder();

			sql.append("select user.* from ((user left join person on user.id = person.id) left join organization on user.id = organization.id ) left join org_apply on user.mobile = org_apply.mobile where 1 = 1 ");

			if (DataUtils.isNotNullOrEmpty(registerStartAt)) {
				sql.append(" and user.create_at & >= " + registerStartAt );
			}
			if (DataUtils.isNotNullOrEmpty(registerEndAt)) {
				sql.append(" and user.create_at & <= " + registerEndAt );
			}
			if (DataUtils.isNotNullOrEmpty(status)) {
				sql.append(" and user.freeze_status = "+status);
			}
			if (DataUtils.isNotNullOrEmpty(type)) {
				sql.append(" and user.type = "+type);
			}
			if (DataUtils.isNotNullOrEmpty(risk)) {
				sql.append(" and user.risk = "+risk);
			}
			if (DataUtils.isNotNullOrEmpty(name)) {
				sql.append("and ( user.name like '%" + name + "%' ");
				sql.append(" or organization.name like '%" + name + "%'");
				sql.append(" or person.org_name like '%" + name + "%'");
				sql.append(" or org_apply.name like '%" + name + "%')");
			}
			if (DataUtils.isNotNullOrEmpty(mobile)) {
				sql.append(" and user.mobile = "+mobile);
			}


			sql.append(" order by user.create_at desc ");

			sql.append(" limit " + start + " , " + size);

			log.info("Sql " + sql);

			String sqlString = sql.toString();

			users = simpleJdbcTemplate.query(sqlString, ParameterizedBeanPropertyRowMapper.newInstance(User.class));

		}catch (Exception e){
			e.printStackTrace(System.out);
			log.info(e.getMessage());
		}

		return users;

	}

	public static Map<String, Object> getOrderListParam(Integer type, Integer account, Long startAt, Long endAt, String name,
														String mobile, String orderNo, Integer status, boolean count) {


		Map<String, Object> params = new HashMap<String, Object>();
		Set<String> tables = new HashSet();
		tables.add("orders");
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" orders.pay_at & >= ", "'" + startAt + "'");
		}

		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" orders.pay_at & <= ", "'" + endAt + "'");
		}

		if(DataUtils.isNotNullOrEmpty(account)){
			if ("3".equals(account)) {
				params.put(" orders.pay_type ", "1");
			}else if ("2".equals(account)) {
				params.put(" orders.department ", 2);
				params.put(" (orders.pay_type ", " 3 or pay_type = 4 or pay_type = 5 )");
			}else if ("1".equals(account)){
				params.put(" orders.department ", 1);
				params.put(" (orders.pay_type ", " 3 or pay_type = 4 or pay_type = 5 )");
			}
		}

		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put(" orders.pay_type", type);
		}
		if (DataUtils.isNotNullOrEmpty(orderNo)) {
			params.put(" orders.order_no", "'" + orderNo + "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put(" orders.status", status);
		}else {
			params.put(" orders.status", "0");
		}

		if(StringUtil.isNotEmpty(name)){
			params.put(" user.id ", " orders.uid ");
			params.put(" user.name & like ", "'%" + name + "'");
			tables.add(" wealth_user.user ");
		}
		if(StringUtil.isNotEmpty(mobile)){
			params.put(" user.id ", " orders.uid ");
			params.put(" user.mobile & like ", "'%" + mobile + "'");
			tables.add(" wealth_user.user ");
		}

		params.put("@order", "  pay_at desc ");
		params.put("@query", " orders.id ");
		String table = SQLUtil.convertTable(tables);


		params.put("@table", table);

		return params;

	}

	public static Map<String, Object> getDebtListParam( String name,String mobile,String orderNo, Long startAt, Long endAt,
														Integer status, Boolean count) {
		Map<String, Object> params = new HashMap<String, Object>();
		if(DataUtils.isNotNullOrEmpty(name)){
			params.put("user_name & like ", "'%" +name+ "%'");
		}
		if(DataUtils.isNotNullOrEmpty(mobile)){
			params.put("user_mobile","'" +mobile + "'");
		}
		if(DataUtils.isNotNullOrEmpty(orderNo)){
			params.put("order_no","'" +orderNo+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" + endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}
		else {
			params.put(" status & in ", " ( 0,1,2,3,7,8 ) ");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  debtapply ");
		return params;
	}

    public static Map<String, Object> getLoanListParam( String name,String mobile,String orderNo, Long startAt, Long endAt,
                                                        Integer status, Boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        if(DataUtils.isNotNullOrEmpty(name)){
            params.put("user_name & like ", "'%" +name+ "%'");
        }
        if(DataUtils.isNotNullOrEmpty(mobile)){
            params.put("user_mobile","'" +mobile + "'");
        }
        if(DataUtils.isNotNullOrEmpty(orderNo)){
            params.put("order_no","'" +orderNo+ "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" create_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" create_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        else {
            params.put(" status & in ", " ( 1,2,3,7,8 ) ");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  create_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  loan_apply ");
        return params;
    }

	public static Map<String, Object> getAllRefundsListParam( String name,String mobile,String orderNo, Long startAt, Long endAt,
														 Boolean count) {
		Map<String, Object> params = new HashMap<String, Object>();
		if(DataUtils.isNotNullOrEmpty(name)){
			params.put("name & like ", "'%" +name+ "%'");
		}
		if(DataUtils.isNotNullOrEmpty(mobile)){
			params.put("mobile","'" +mobile + "'");
		}
		if(DataUtils.isNotNullOrEmpty(orderNo)){
			params.put("order_no","'" +orderNo+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" + endAt + "'");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  refunds ");
		return params;
	}

	public static Map<String, Object> getNoRefundsListParam( String name,String mobile,String orderNo, Long startAt, Long endAt,
															 Integer status, Boolean count) {
		Map<String, Object> params = new HashMap<String, Object>();
		if(DataUtils.isNotNullOrEmpty(name)){
			params.put("name & like ", "'%" +name+ "%'");
		}
		if(DataUtils.isNotNullOrEmpty(mobile)){
			params.put("mobile","'" +mobile + "'");
		}
		if(DataUtils.isNotNullOrEmpty(orderNo)){
			params.put("order_no","'" +orderNo+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" + endAt + "'");
		}
		if (1 == status) {
			params.put("status & In ", " ( 1 , 3 ) ");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  refunds ");
		return params;
	}

	public static Map<String, Object> getRefundsListParam( String name,String mobile,String orderNo, Long startAt, Long endAt,
														   Integer status, Boolean count) {
		Map<String, Object> params = new HashMap<String, Object>();
		if(DataUtils.isNotNullOrEmpty(name)){
			params.put("name & like ", "'%" +name+ "%'");
		}
		if(DataUtils.isNotNullOrEmpty(mobile)){
			params.put("mobile","'" +mobile + "'");
		}
		if(DataUtils.isNotNullOrEmpty(orderNo)){
			params.put("order_no","'" +orderNo+ "'");
		}
		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" + endAt + "'");
		}
		if (2 == status) {
			params.put("status", status);
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  refunds ");
		return params;
	}






	public static List<ProductStatistics> getProductStatisticsListByMore(String productNo,String name,Long startAt,Long endAt,
																		 Integer start,Integer size ) {


		log.info("Test 111 ");
		List<ProductStatistics> productStatisticsList = new ArrayList<ProductStatistics>();
		log.info("Test 222 ");
		try {
			DataSource dataSource = GroupHelper.getDataSource("wealth_finance");
			log.info("Test 333 ");
			if (DataUtils.isNotNullOrEmpty(dataSource)) {
				log.info("  datasource = " + dataSource);
			} else {

			}
			log.info("Test 44 ");
			SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
			StringBuilder sql = new StringBuilder();
			sql.append(" select b.`name` as name ,b.`status` as status ,sum(buy_person_sum) as buyPersonSum ,SUM(a.buy_count) as buyCount ,SUM(a.buy_sum_amount) as buySumAmount, ");
			sql.append("SUM(withdrawal_person_sum) as withdrawalPersonSum ,SUM(withdrawal_count) as withdrawalCount ,SUM(withdrawal_amount) as withdrawalAmount ,a.product_id as productId ");
			sql.append(" from productdaily a  ");
			sql.append(" JOIN product b on b.id = a.product_id  ");

			sql.append("  where 1=1 ");
			if (DataUtils.isNotNullOrEmpty(name)) {
				sql.append(" and b.name like '%" + name + "%' ");
			}
			if (DataUtils.isNotNullOrEmpty(productNo)) {
				sql.append(" and b.product_no like '%" + productNo + "%' ");
			}
			if(DataUtils.isNotNullOrEmpty(startAt)){
				sql.append(" and a.static_at >= '" + startAt + "' ");

			}
			if(DataUtils.isNotNullOrEmpty(endAt)){
				sql.append(" and a.static_at <='" + endAt + "' ");

			}
			sql.append("  GROUP BY a.product_id ORDER BY b.update_at desc  LIMIT "+start+","+size);

			log.info("Sql " + sql.toString());
			productStatisticsList =
					simpleJdbcTemplate.query(sql.toString(),
							ParameterizedBeanPropertyRowMapper.newInstance(ProductStatistics.class));
		} catch (Exception e) {
			e.printStackTrace(System.out);
			log.info(e.getMessage());
		}

		log.info("  size  = " + productStatisticsList.size());
		return productStatisticsList;
	}


	public static List<ProductStatistics> getWeekOrMonthProductStatistics(String productNo,String name,Long startAt,Long endAt,
																		 Integer start,Integer size ,String period) {


		log.info("Test 111 ");
		List<ProductStatistics> productStatisticsList = new ArrayList<ProductStatistics>();
		log.info("Test 222 ");
		try {
			DataSource dataSource = GroupHelper.getDataSource("wealth_finance");
			log.info("Test 333 ");
			if (DataUtils.isNotNullOrEmpty(dataSource)) {
				log.info("  datasource = " + dataSource);
			} else {

			}
			log.info("Test 44 ");
			SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
			StringBuilder sql = new StringBuilder();
			sql.append(" select  d.product_id as productId, d.`name` AS `name`,d.`status` AS `status`,SUM(d.buy_count) AS buyCount,SUM(d.buy_person_sum) AS buyPersonSum,");
			sql.append(" SUM(d.buy_sum_amount) AS buySumAmount,SUM(d.withdrawal_amount) AS withdrawalAmount,SUM(d.withdrawal_count) AS withdrawalCount, ");
			sql.append(" SUM(d.withdrawal_person_sum) AS withdrawalPersonSum, d.static_at  ");


			sql.append(" from (SELECT a.product_id as product_id,b.`name` AS `name`,b.`status` AS `status`,a.buy_count AS buy_count,  ");
			sql.append(" a.buy_person_sum AS buy_person_sum,a.buy_sum_amount AS buy_sum_amount,a.withdrawal_amount AS withdrawal_amount,  ");
			sql.append(" a.withdrawal_count AS withdrawal_count,a.withdrawal_person_sum AS withdrawal_person_sum,  ");
			if(Period_Week.equals(period)){
				sql.append("DATE_FORMAT( FROM_UNIXTIME ( a.static_at / 1000),'%Y%u' ) as static_at ");

			}else {
				sql.append("DATE_FORMAT( FROM_UNIXTIME ( a.static_at / 1000),'%Y%m' ) as static_at ");

			}

			sql.append(" from product b, productdaily a ");
			sql.append("  where 1=1 ");
			if (StringUtil.isNotEmpty(productNo)) {
				sql.append(" b.product_no like '%" + productNo + "%'");
			}
			if (StringUtil.isNotEmpty(name)) {
				sql.append("b.name  like '%" + name + "%'");

			}
			if (startAt!=null) {
				sql.append("a.static_at  >= " + startAt);
			}
			if (endAt!=null) {
				sql.append("a.static_at  <= "+ endAt);
			}
			sql.append("  AND a.product_id = b.id GROUP BY a.static_at, a.product_id  ORDER BY b.update_at desc  ) d   ");
			sql.append("  GROUP BY d.static_at   LIMIT "+start+","+size);

			log.info("Sql " + sql.toString());
			productStatisticsList =
					simpleJdbcTemplate.query(sql.toString(),
							ParameterizedBeanPropertyRowMapper.newInstance(ProductStatistics.class));
		} catch (Exception e) {
			e.printStackTrace(System.out);
			log.info(e.getMessage());
		}

		log.info("  size  = " + productStatisticsList.size());
		return productStatisticsList;
	}


	public static Map<String, Object> getManagerListParam(Integer status, Long roleId, String name, String nick, boolean count) {


		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(status)) {
			params.put("status", status);
		}
		if (DataUtils.isNotNullOrEmpty(roleId)) {
			params.put("roleId", roleId);
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name", name);
		}
		if (DataUtils.isNotNullOrEmpty(nick)) {
			params.put(" nick & like ", "'%" + nick + "%'");
		}

		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", "  manager ");

		return params;

	}


	public static Map<String, Object> getTransactionListParam(Integer flag, Integer type, Long startAt,
													   Long endAt, String name, String mobile, boolean count) {


		Map<String, Object> params = new HashMap<String, Object>();

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put(" create_at & >= ", "'" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put(" create_at & <= ", "'" + endAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(flag)) {
			params.put("flag", flag);
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("detail", type);
		}
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put(" name & like ", "'%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mobile)) {
			params.put("mobile", mobile);
		}
		if (count) {
			params.put("@query", " count(id) ");
		} else {
			params.put("@order", "  create_at desc ");
			params.put("@query", " id ");
		}
		params.put("@table", " fundhistory ");

		return params;

	}

	public static Map<String, Object> getBankList(String bankName, String createName, Long startAt,
												  Long endAt, String minSingleQuota,
												  String maxSingleQuota, String minDailyQuota,
												  String maxDailyQuota, boolean count) {
		Map<String, Object> params = new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("bank");
		if (DataUtils.isNotNullOrEmpty(bankName)) {
			params.put("bank.bank_name & like", " '%" + bankName + "%'");
		}

		if (DataUtils.isNotNullOrEmpty(startAt)) {
			params.put("bank.update_at & >= ", " '" + startAt + "'");
		}
		if (DataUtils.isNotNullOrEmpty(endAt)) {
			params.put("bank.update_at & <= ", " '" + endAt + "'");
		}

		if (DataUtils.isNotNullOrEmpty(minSingleQuota)) {
			params.put("bank.single_quota+0 & >= ", " '" + minSingleQuota + "'");
		}
		if (DataUtils.isNotNullOrEmpty(maxSingleQuota)) {
			params.put("bank.single_quota+0 & <= ", " '" + maxSingleQuota + "'");
		}
		if (DataUtils.isNotNullOrEmpty(minDailyQuota)) {
			params.put("bank.daily_quota+0 & >= ", " '" + minDailyQuota + "'");
		}
		if (DataUtils.isNotNullOrEmpty(maxDailyQuota)) {
			params.put("bank.daily_quota+0 & <= ", " '" + maxDailyQuota + "'");
		}

		if (DataUtils.isNotNullOrEmpty(createName)) {
			tables.add("wealth_public.manager");
			params.put("bank.create_by", "manager.id ");
			params.put("manager.nick & like ", "'%" + createName + "%'");
		}

		if (count) {
			params.put("@query", " count(bank.id) ");

		}
		else {
			params.put("@order", "  bank.update_at desc  ");
			params.put("@query", " bank.id ");
		}

		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);
		System.out.println("sql is: " + SQLUtil.convert2Sql(params, 0, 0));
		return params;

	}
}
