package com.ptteng.wealth.admin.controller.account;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.admin.model.Constant;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.admin.util.DebtConstant;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.qding.common.util.DataUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.HashMap;
import java.util.Map;

/**
 * Invest  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class FundAccountController {
    private static final Log log = LogFactory.getLog("fundAccount");

    @Autowired
    private ConstantService constantService;
    @Autowired
    private AccountService accountService;


    //4、获取开磷公司证联账户记录
    @RequestMapping(value = "/a/u/fund/account/list", method = RequestMethod.GET)
    public String getFundAccount(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get kailin company fund account list");

        try {
            //获取除其他账户外的开磷账户
            List<String> accountName = new ArrayList<>();
            List<Long> accountIds = accountService.getAccountIds(0,Integer.MAX_VALUE);

            Map<String, String> name_account = new HashMap<>();
            Map<String, String> name_pwd = new HashMap<>();
            if(CollectionUtils.isEmpty(accountIds)){
                log.info("no account");
            }else {
                List<Account> accounts = accountService.getObjectsByIds(accountIds);
                for(Account account : accounts){
                    if (!"otherzhanghu".equals(account.getAccCode())){
                        accountName.add(account.getName());
                    }
                }

                String account = "";
                String pwd = "";
                //在常量表中获取对应账户信息
                for(String name : accountName){

                    account = constantService.getValue(accountName+"account" ,"fundAccount" );
                    log.info(name + " account : " + account);
                    name_account.put(name, account);

                    pwd = constantService.getValue(accountName+"pwd" ,"fundAccount" );
                    log.info(name + " pwd : " + pwd);
                    name_pwd.put(name, pwd);
                }
            }

            model.addAttribute("code", 0);

            model.addAttribute("accountName", accountName);
            model.addAttribute("name_account", name_account);
            model.addAttribute("name_pwd", name_pwd);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("get kailin company fund account list error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }

        return "/admin/account/json/fundAccountJson";
    }

    //4、修改开磷公司证联账户记录
    @RequestMapping(value = "/a/u/fund/account", method = RequestMethod.PUT)
    public String putHolidayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, String fundAccountJson) throws Exception {

        log.info("put fund account json : " + fundAccountJson);

        if (null == fundAccountJson) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            //将json转为字符串
            JSONArray array = JSONArray.fromObject(fundAccountJson);
            log.info("array size : " + array.size());
            for (int i = 0; i < array.size(); i++) {
                log.info(i);
                JSONObject jsonObject = array.getJSONObject(i);
                log.info("========== jsonObject : " + jsonObject.toString() + "==========");
                String name = (String) jsonObject.get("name");
                String account = (String) jsonObject.get("account");
                String pwd = (String) jsonObject.get("pwd");
                log.info("name : " + name + " account : " + account + " pwd : " + pwd);

                if (DataUtils.isNullOrEmpty(name)) {
                    log.info("json wrong");
                    model.addAttribute("code", -14000);
                    return "/common/success";
                }

                //查询公司账户是否存在
                Long accountId = constantService.getConstantIdByKeyAndType(name+"account" ,"fundAccount" );

                if (null == accountId) {

                    Constant constant = new Constant();
                    constant.setValue(account);
                    constant.setType("fundAccount");
                    constant.setMykey(name+"account");
                    log.info("insert " + name + " account data : " + account);
                    constantService.insert(constant);

                } else {
                    Constant constant = constantService.getObjectById(accountId);
                    constant.setValue(account);
                    log.info("update " + name + " account data : " + account);
                    constantService.update(constant);
                }

                //查询公司密码是否存在
                Long pwdId = constantService.getConstantIdByKeyAndType(name+"pwd" ,"fundAccount" );

                if (null == pwdId) {

                    Constant constant = new Constant();
                    constant.setValue(pwd);
                    constant.setType("fundAccount");
                    constant.setMykey(name+"pwd");
                    log.info("insert " + name + " pwd data : " + pwd);
                    constantService.insert(constant);

                } else {
                    Constant constant = constantService.getObjectById(pwdId);
                    constant.setValue(pwd);
                    log.info("update " + name + " pwd data : " + pwd);
                    constantService.update(constant);
                }
            }

            model.addAttribute("code", 0);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("put fund account json : " + fundAccountJson + " error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

}

