package com.ptteng.wealth.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.orgApplyUtil.OrgApplyUtil;

import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.*;
import com.ptteng.wealth.user.service.*;

import com.qding.common.util.HttpClientUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * OrgApply  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class OrgApplyController extends BaseController {


    private static final Log log = LogFactory.getLog(OrgApplyController.class);
    private static final Log orgApplyAdmin = LogFactory.getLog("org_apply_admin");


    @Autowired
    private OrgApplyService orgApplyService;

    @Autowired
    private UserService userService;
    @Autowired
    private OrgApplyRecordService orgApplyRecordService;
    @Autowired
    private ManagerService managerService;

    /**
     * 列表查询
     */
    @RequestMapping(value = "/a/u/org/apply/", method = RequestMethod.GET)
    public String getOrgApplyList(ModelMap model, Integer page,
                                  Integer size, Long applyStartAt,
                                  Long applyEndAt, Long checkStartAt, Long checkEndAt, Integer status, String orgName,
                                  String mobile) throws Exception {

        log.info(" page = " + page + " size = " + size + " name = ");
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> map = OrgApplyUtil.getListParam(applyStartAt, applyEndAt, checkStartAt, checkEndAt, status, orgName, mobile, false);
            List<Long> orgApplyIds = orgApplyService.getIdsByDynamicCondition(OrgApply.class, map, start, size);
            log.info(" orgApplyIds size = " + orgApplyIds.size());
            if (orgApplyIds.size() > 0) {
                List<OrgApply> orgApplyList = orgApplyService.getObjectsByIds(orgApplyIds);
                List<Long> uIds = new ArrayList<>();
                for (OrgApply orgApply : orgApplyList) {
                    uIds.add(orgApply.getUid());
                }
                Map<Long, String> userMobileMap = new HashMap<>();
                if (uIds.size() > 0) {
                    List<User> users = userService.getObjectsByIds(uIds);
                    for (User user : users) {
                        userMobileMap.put(user.getId(), user.getMobile());
                    }
                }
                model.addAttribute("userMobileMap", userMobileMap);
                model.addAttribute("orgApplyList", orgApplyList);
            }

            Integer totalSize = (orgApplyService.getIdsByDynamicCondition(OrgApply.class, map, 0, Integer.MAX_VALUE)).size();
            model.addAttribute("total", totalSize);
            Integer totalPage = (((totalSize - 1)) / (size)) + 1;
            model.addAttribute("code", 0);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userAccountRelation list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/admin/orgApply/json/orgApplyListJson";
    }


    /**
     * 查询详细
     *
     * @return {"status":1,"refuseReason":"身份证不清晰"}
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/org/apply/{id}", method = RequestMethod.GET)
    public String getPersonApplyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        try {
            log.info(" id = " + id);
            OrgApply orgApply = orgApplyService.getObjectById(id);
            if (null == orgApply) {
                model.addAttribute("code", -12000);
                return "/data/json";
            }
            log.info("get personApply data is " + orgApply);
            model.addAttribute("code", 0);
            model.addAttribute("orgApply", orgApply);

            List<Long> recordIds = orgApplyRecordService.getOrgApplyRecordIdsByOrgApplyId(id, 0, Integer.MAX_VALUE);
            if (recordIds.size() > 0) {
                List<OrgApplyRecord> recordList = orgApplyRecordService.getObjectsByIds(recordIds);
                model.addAttribute("recordList", recordList);
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get personApply error  ");
            model.addAttribute("code", -1);
        }
        return "/admin/orgApply/json/orgApplyDetailJson";
    }


    /**
     * 保存审核结果
     *
     * @param status       审核结果
     * @param refuseReason 驳回原因
     */
    @RequestMapping(value = "/a/u/org/apply/{id}", method = RequestMethod.PUT)
    public String updatePersonApplyJson(HttpServletRequest request, ModelMap model, @PathVariable Long id, Integer status, String refuseReason) throws Exception {

        orgApplyAdmin.info("=================================================================");
        orgApplyAdmin.info(" id= " + id + " status: " + status + " refuseReason: " + refuseReason);

        if(null == status){
            log.info("no status");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        int code = 0;
        try {
            Long mid = getUserId(request);
            orgApplyAdmin.info(" mid = " + mid);
            Manager manager = managerService.getObjectById(mid);
            OrgApply orgApply = orgApplyService.getObjectById(id);
            if (null == orgApply) {
                code = -12000;
            } else {
                if(!OrgApply.STATUS_1.equals(orgApply.getStatus())){
                    model.addAttribute("code", -2016);
                    return "/data/json";
                }

                //通过之后
                if (OrgApply.STATUS_2.equals(status)) {
                    orgApplyAdmin.info(" 第一步：开户，绑卡，创建组织机构表 ");
                    //第一步：开户，绑卡，创建组织机构表
                    code = orgApplyService.createOrg(orgApply);
                    if (code != 0) {
                        status = OrgApply.STATUS_1;
                    }
                }
                orgApplyAdmin.info(" create org result code : " + code);
                if (OrgApply.STATUS_2.equals(status) && code == 0) {
                    orgApplyAdmin.info(" 第二步：调用CRM的接口 ");
                    //第二步：调用CRM的接口
                    synchornizeCrm(orgApply);
                    orgApplyAdmin.info(" 第三步：创建通过组织机构代码登陆的方式 ");
                    //第三步：创建通过组织机构代码登陆的方式
                    addLoginManner(orgApply);

                }
                //第四步：更新机构申请记录
                orgApplyAdmin.info(" code: " + code + "  status: " + status);
                orgApply.setStatus(status);
                orgApply.setRefuseReason(refuseReason);
                orgApply.setCheckAt(System.currentTimeMillis());
                Boolean update = orgApplyService.update(orgApply);

                //第五步： 创建机构申请记录
                orgApplyAdmin.info("  orgapply update = " + update);
                List<Long> recordIds = orgApplyRecordService.getOrgApplyRecordIdsByOrgApplyId(id, 0, Integer.MAX_VALUE);
                Integer count = recordIds.size();
                OrgApplyRecord orgApplyRecord = new OrgApplyRecord();
                orgApplyRecord.setOrgApplyId(id);
                orgApplyRecord.setStatus(status);
                orgApplyRecord.setDescription(refuseReason);
                if (count.equals(0)) {
                    orgApplyRecord.setNumber(1 + "");
                } else {
                    orgApplyRecord.setNumber((count + 1) + "");
                }
                orgApplyRecord.setOperator(manager.getNick());
                orgApplyRecord.setCreateBy(mid);
                orgApplyRecord.setUpdateBy(mid);
                Long recordId = orgApplyRecordService.insert(orgApplyRecord);
                orgApplyAdmin.info(" orgapply recordId = " + recordId);
            }

        } catch (Throwable t) {
            orgApplyAdmin.error(t.getMessage());
            orgApplyAdmin.error("update orgApply error,id is  " + id);
            code = -1;
        }
        model.addAttribute("code", code);
        return "/data/json";
    }

    private void addLoginManner(OrgApply orgApply) throws ServiceException, ServiceDaoException {
        String openId = "";
        if (OrgApply.THREE_CARD == orgApply.getOrgType()) {
            openId = orgApply.getOrgCode();
        } else if (OrgApply.ONE_CARD == orgApply.getOrgType()) {
            openId = orgApply.getCreditCode();
        }

        Long uoId1 = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(openId, UserOpenidRelation.Type_Org_Code);
        if (null != uoId1) {
            UserOpenidRelation userOpenidRelation1 = userOpenidRelationService.getObjectById(uoId1);
            userOpenidRelation1.setTypeId(orgApply.getUid());
            Boolean update = userOpenidRelationService.update(userOpenidRelation1);
            orgApplyAdmin.info(" update org_code relation: id " + userOpenidRelation1 + " result: " + update);
        } else {
            UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
            userOpenidRelation.setTypeId(orgApply.getUid());
            userOpenidRelation.setOpenId(openId);
            userOpenidRelation.setStatus(UserOpenidRelation.Type_Org_Code);
            uoId1 = userOpenidRelationService.insert(userOpenidRelation);
            orgApplyAdmin.info(" insert org_code relation: openid  " + uoId1);
        }
    }

    //同步机构用户到CRM 系统
    private void synchornizeCrm(OrgApply orgApply) throws Exception {
        String clientName = URLEncoder.encode(orgApply.getName(), "utf-8");
        clientName = URLEncoder.encode(clientName, "utf-8");
        String bank = URLEncoder.encode(orgApply.getBankCode(), "utf-8");
        bank = URLEncoder.encode(bank, "utf-8");

        User user = userService.getObjectById(orgApply.getUid());
        orgApplyAdmin.info(" user : " + user);
        if(null != user){
            if(StringUtil.isEmpty(user.getKailinCode())){
                String CRMUrl = "http://" + environment.getCrm() + "/api/account/new?type=1&mobile=" + orgApply.getMobile() +
                        "&contact=" + URLEncoder.encode(clientName, "utf-8") + "&organcode=" + orgApply.getOrgCode() + "&idno="
                        + "&name=" + URLEncoder.encode(orgApply.getName(), "utf-8") + "&bank=" + URLEncoder.encode(bank, "utf-8") + "&bankno=" + orgApply.getCardNo()
                        + "&liccode=" + orgApply.getLicenceCode() + "&sfrom=fsp" + "&provincecode=" + "" + "&citycode=" + ""
                        + "&address=" + "" + "&taxno=" + "" + "&loginID=" + orgApply.getMobile() + "&inipwd=" + orgApply.getPassword() + "&token=" + orgApply.getKailinCode() + "&threetoone=" + orgApply.getCreditCode();
                orgApplyAdmin.info("URL : " + CRMUrl);

                try {
                    orgApplyAdmin.info(" 第一步： 同步到CRM 系统 ");
                    //第一步： 同步到CRM 系统
                    String code = HttpClientUtil.sendPostRequest(CRMUrl, "", false);
                    orgApplyAdmin.info(" code = " + code);
                    JSONObject jsStr = new JSONObject(code);
                    String crmcode = jsStr.get("scode") + "";

                    orgApplyAdmin.info(" 第二步：更新用户的CRM CODE ");
                    //第二步：更新用户的CRM CODE
                    user.setKailinCode(crmcode);
                    userService.update(user);
                    orgApplyAdmin.info("CRM code: " + code);
                    orgApplyAdmin.info("KAILIN CODE: " + user.getKailinCode());
                    orgApplyAdmin.info("SUCCESS: mobile: " + orgApply.getMobile() + "  CRM SUCCESS " + code);
                } catch (Exception e) {
                    orgApplyAdmin.info(" orgApply crm error   ... ");
                }
            }
        }

    }

}

