package com.ptteng.wealth.admin.controller;

import java.math.BigDecimal;
import java.util.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class OrderController extends BaseController {
    private static final Log log = LogFactory.getLog(OrderController.class);

    @Autowired
    private UserService userService;

    @Autowired
    private OrderService orderService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private AccountService accountService;

    @Autowired
    private UserAccountRelationService userAccountRelationService;

    @Resource(name = "product_account")
    private Map<String, String> product_account = new HashMap();


    @RequestMapping(value = "/a/u/order/search", method = RequestMethod.GET)
    public String searchOrder(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer type,
                              Integer account, Long startAt, Long endAt, String name, String mobile, String orderNo, Integer status, Integer page, Integer size) throws Exception {

        log.info("search order data : ");

        List<Order> list = new ArrayList();
        Map<Long, User> uid_user = new HashMap();
        Map<Long, String> oid_accountName = new HashMap<>();

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Boolean next = false;
        try {

            Map<String, Object> param = DynamicUtil.getOrderListParam(type, account, startAt, endAt, name, mobile, orderNo, status, false);

            log.info("param : " + param);

            List<Long> ids = this.orderService.getIdsByDynamicCondition(Order.class, param, start, size + 1);

            Integer totalSize = orderService.getIdsByDynamicCondition(Order.class, param, 0, Integer.MAX_VALUE).size();
            model.addAttribute("total", totalSize);
            Integer totalPage = (((totalSize - 1)) / (size)) + 1;
            model.addAttribute("totalPage", totalPage);

            if (CollectionUtils.isEmpty(ids)) {
                log.info("no ids");
            } else {

                list = this.orderService.getObjectsByIds(ids);
                if (list.size() == size + 1) {
                    log.info("has next page data ");
                    next = true;
                    list = list.subList(0, size);
                } else {
                    log.info(" not get next page data ");
                }
                Set<Long> uids = new HashSet();
                for (Order order : list) {
                    if(Order.Pay_Type_fund.equals(order.getPayType())){
                        oid_accountName.put(order.getId(), "余额账户");
                    }else if (Order.DEPARTMENT_A.equals(order.getDepartment())){
                        oid_accountName.put(order.getId(), "开磷息峰合成氨账户");
                    }else if (Order.DEPARTMENT_B.equals(order.getDepartment())){
                        oid_accountName.put(order.getId(), "开磷化肥账户");
                    }else {
                        oid_accountName.put(order.getId(), "其他账户");
                    }
                    uids.add(order.getUid());
                }
                List<User> users = this.userService.getObjectsByIds(new ArrayList(uids));
                uid_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), users);
                log.info("get uid_map " + uid_user);
                log.info("get list data is " + list);
                model.addAttribute("list", list);
                model.addAttribute("uid_user", uid_user);
                model.addAttribute("oid_accountName", oid_accountName);
            }


            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }

        return "/wealth-admin-web/order/json/orderListJson";
    }


    @RequestMapping(value = "/a/u/order/{oid}/detail", method = RequestMethod.GET)
    public String orderDetail(HttpServletRequest request, ModelMap model, HttpServletResponse response, @PathVariable Long oid) throws Exception {
        // 这里的name是单元name
        log.info("get  order detail  data : " + oid);


        try {


            Order order = this.orderService.getObjectById(oid);
            if (order == null) {
                model.addAttribute("code", -2000);
                return "/data/json";

            } else {

                User user = this.userService.getObjectById(order.getUid());

                model.addAttribute("code", 0);
                model.addAttribute("order", order);
                model.addAttribute("user", user);
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get  user error " + oid);
            model.addAttribute("code", -100000);
        }

        return "/wealth-admin-web/order/json/orderDetailJson";
    }


    @RequestMapping(value = "/a/u/order/{oid}/pay", method = RequestMethod.POST)
    public String offlinePayOrder(HttpServletRequest request, ModelMap model, HttpServletResponse response, @PathVariable Long oid, String password) throws Exception {
        // 这里的name是单元name
        log.info("get  order detail  data : " + oid + " password " + password);


        //确认密码
        Long mid = getUserId(request);
        Manager manager = managerService.getObjectById(mid);
        if (null == manager) {
            model.addAttribute("code", -2000);
            model.addAttribute("id", 2000);
            return "/data/json";
        }
        if (!manager.getPwd().equals(com.gemantic.common.util.PasswordUtils.encode(password))) {
            log.info(" pwd is false ");
            model.addAttribute("code", -2004);
            return "/data/json";
        } else {
            log.info(" pwd is true ");
        }

        try {


            //1.找出订单金额，以及需要在哪个账户扣款

            Order order = this.orderService.getObjectById(oid);
            log.info(oid + " get order is " + order);
            if (Order.STATUS_PROCCESS.equals(order.getStatus())) {

            } else {
                log.info(order.getId() + " is processed " + order.getStatus());
                model.addAttribute("code", -10001);
                return "/data/json";
            }


            Long userID = order.getUid();
            Integer department = order.getDepartment();

            log.info(product_account);
            String accountKey = this.product_account.get(department.toString());
            BigDecimal payMoney = order.getPriceTot();
            log.info(department + " get key is " + accountKey);
            Long relationID = this.userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(userID, accountKey);
            log.info(accountKey + " get relation is " + relationID);
            UserAccountRelation relation = this.userAccountRelationService.getObjectById(relationID);
            log.info(accountKey + " get relation is " + relation);

            BigDecimal userMoney = relation.getMoney();
            if (userMoney.compareTo(payMoney) > 0) {

                //2.执行扣款操作
                log.info(oid + "will pay " + relation.getId());
                relation.setMoney(userMoney.subtract(payMoney));
                this.userAccountRelationService.update(relation);
                model.addAttribute("code", 0);
                order.setStatus(Order.STATUS_COMPLETE);
                order.setConfirmAt(System.currentTimeMillis());
                order.setPayAt(System.currentTimeMillis());
                this.orderService.update(order);
                log.info(oid + " pay success " + relation.getId());

            } else {

                log.info(oid + " is more than user account " + relation.getId());
                model.addAttribute("code", -10000);

            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" pay order  error " + oid);
            model.addAttribute("code", -100000);
        }

        return "/data/json";
    }


}
   

    
