package com.ptteng.wealth.admin.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.service.FundHistoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.admin.util.DynamicUtil;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 流水管理模块
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class FundHistoryController extends BaseController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private FundHistoryService fundHistoryService;


    /**
     * 账户流水
     */
    @RequestMapping(value = "/a/u/transaction/search", method = RequestMethod.GET)
    public String searchUser(ModelMap model, Integer type, Integer flag, Long startAt, Long endAt,
                             String name, String mobile, @RequestParam(required = false) Integer page, Integer size) throws Exception {

        log.info("search transaction data : flag: " + flag + "  name: " + name + " mobile: " + mobile + " type: " + type + " startAt: " +
                startAt + " endAt: " + endAt);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
            Map<String, Object> param = DynamicUtil.getTransactionListParam(flag, type, startAt, endAt, name, mobile, false);
            List<Long> ids = fundHistoryService.getIdsByDynamicCondition(FundHistory.class, param, start, size);
            Integer totalSize = (fundHistoryService.getIdsByDynamicCondition(FundHistory.class, param, 0, Integer.MAX_VALUE)).size();
            List<FundHistory> list = new ArrayList();
            if (CollectionUtils.isEmpty(ids)) {
                log.info("no ids");

            } else {

                list = fundHistoryService.getObjectsByIds(ids);

                log.info("get list data size  is " + list.size());

                model.addAttribute("list", list);
            }
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("totalPage", totalPage(size, totalSize));
            model.addAttribute("total", totalSize);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search fund history error ");
            model.addAttribute("code", -1);
        }

        return "/admin/fundHistory/json/fundHistoryJson";
    }

}



