package com.ptteng.wealth.admin.controller.product;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.admin.model.Constant;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.admin.util.DebtConstant;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Calendar;
import java.util.Date;

/**
 * Invest  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class HolidayController {
    private static final Log log = LogFactory.getLog("holiday");

    @Autowired
    private ConstantService constantService;


    //4、获取节假日记录
    @RequestMapping(value = "/a/u/holiday/params/{year}", method = RequestMethod.GET)
    public String getHolidayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Integer year) throws Exception {

        log.info("get " + year + " holiday json");

        if(null == year){
            log.info("year is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            String holidayJson = constantService.getValue(year.toString(), "holidayJson");
            log.info("holidayJson : " + holidayJson);

            if(null == holidayJson){
                log.info("no such json");
                model.addAttribute("code", -700000019);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("data", holidayJson);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("get year " + year + " holiday error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }

        return "/common/data";
    }

    //4、修改节假日记录
    @RequestMapping(value = "/a/u/holiday/params/{year}", method = RequestMethod.PUT)
    public String putHolidayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Integer year, String holidayJson) throws Exception {

        log.info("put " + year + " holiday json : " + holidayJson);

        if(null == year || null == holidayJson){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            //判断是否为闰年
            String data = "";
            Calendar cal=Calendar.getInstance();
            cal.set(year ,Calendar.DECEMBER,31);
            if(cal.get(Calendar.DAY_OF_YEAR)==366){
                log.info("the year : " + year + " is leap year");
                data = DebtConstant.leap_year;

            }else{
                log.info("the year : " + year + " is common year");
                data = DebtConstant.common_year;

            }

            //将json转为字符串
            JSONArray array = JSONArray.fromObject(holidayJson);
            log.info("array size : " + array.size());
            for(int i = 0; i < array.size(); i++){
                log.info(i);
                JSONObject jsonObject = array.getJSONObject(i);
                log.info("========== jsonObject : " + jsonObject.toString() + "==========");
                Long startTime = (Long)jsonObject.get("startDate");
                Long endTime = (Long)jsonObject.get("endDate");
                log.info("startTime : " + startTime + " endTime : " + endTime);

                Calendar startDt = Calendar.getInstance();
                Calendar endDt = Calendar.getInstance();
                Date startDate = MyTimeUtil.convertLong2Date(startTime);
                Date endDate = MyTimeUtil.convertLong2Date(endTime);
                startDt.setTime(startDate);
                endDt.setTime(endDate);

                Integer startYear = startDt.get(Calendar.YEAR);
                Integer endYear = endDt.get(Calendar.YEAR);
                log.info("start year : " + startYear + " end year : " + endYear);

                if(!startYear.equals(year) || !endYear.equals(year)){
                    log.info("json wrong");
                    model.addAttribute("code", -700000018);
                    return "/common/success";
                }

                //获取假期起止时间段
                int startDayNo = startDt.get(Calendar.DAY_OF_YEAR);
                int endDayNo = endDt.get(Calendar.DAY_OF_YEAR);
                log.info("startDayNo : " + startDayNo + " endDayNo : " + endDayNo);

                if(startDayNo > endDayNo){
                    log.info("json wrong");
                    model.addAttribute("code", -700000018);
                    return "/common/success";
                }

                char [] dataArr = data.toCharArray();
                for(int j = startDayNo - 1; j < endDayNo; j ++){
                    if('1' == dataArr[j]){
                        dataArr[j] = '0';
                    }
                }
                data = String.valueOf(dataArr);
                log.info("data : " + data);
            }

            //查询该年字符串是否存在
            Long constantId = constantService.getConstantIdByKeyAndType(year.toString(), "holiday");

            if(null == constantId){

                Constant constant = new Constant();
                constant.setValue(data);
                constant.setType("holiday");
                constant.setMykey(year.toString());
                log.info("insert holiday data : " + constant);
                constantService.insert(constant);

            }else {
                Constant constant = constantService.getObjectById(constantId);
                constant.setValue(data);
                log.info("update holiday data : " + constant);
                constantService.update(constant);
            }

            //查询该年json是否存在
            Long constantJsonId = constantService.getConstantIdByKeyAndType(year.toString(), "holidayJson");

            if(null == constantJsonId){

                Constant constantJson = new Constant();
                constantJson.setValue(holidayJson);
                constantJson.setType("holidayJson");
                constantJson.setMykey(year.toString());
                log.info("insert holidayJson data : " + constantJson);
                constantService.insert(constantJson);

            }else {
                Constant constantJson = constantService.getObjectById(constantJsonId);
                constantJson.setValue(holidayJson);
                log.info("update holiday data : " + constantJson);
                constantService.update(constantJson);
            }


            model.addAttribute("code", 0);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("put year " + year + " holiday error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

}

