package com.ptteng.wealth.admin.controller.product;

import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.admin.util.WeekCountUtil;
import com.ptteng.wealth.finance.model.AnnualYield;
import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.finance.service.AnnualYieldService;
import com.ptteng.wealth.finance.service.ProductService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

/*
 * Product  crud
 *
 * @author liangxiaojin
 * @Date 2014-4-16 13:43
 */
@Controller
public class ProductController {
    private static final Log log = LogFactory.getLog(ProductController.class);

    @Autowired
    private ProductService productService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private AnnualYieldService annualYieldService;

    public static String getDate(Long time){
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        String date = "";
        if(null != time){
            date = dateFormat.format(new Date(time));
        }
        return  date;
    }

    /**
     * 产品列表
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param productNo
     * @param name
     * @param status
     * @param productType
     * @param buyStatus
     * @param fixedInvestmentSatus
     * @return
     * @throws Exception
     *
     */
    @RequestMapping(value = "/a/product/search", method = RequestMethod.GET)
    public String getproductList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,Integer page,Integer size,
                                 String productNo,String name,Integer status,Integer productType,
                                 Integer buyStatus,Integer fixedInvestmentSatus) throws Exception {
        log.info("page===" + page + "size====" + size);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> map = DynamicUtil.getProductList(productNo, name, status, productType, buyStatus, fixedInvestmentSatus,
                    false);
            log.info(" get product list param = "+map);
            List<Long> productIds =  productService.getIdsByDynamicCondition(Product.class, map, start, size);
            log.info(" get product list ids size = "+productIds.size());
            if(productIds.size()>0){
                List<Product> products = productService.getObjectsByIds(productIds);
                model.addAttribute("list",products);
            }

            Map<String, Object> mapTotal =DynamicUtil.getProductList(productNo,name,status,productType,buyStatus,fixedInvestmentSatus,
                    true);
            log.info(" get product total size param = "+mapTotal);
            BigInteger total =(BigInteger)  productService.getObjectByDynamicCondition(Product.class, mapTotal, 0, Integer.MAX_VALUE);
            log.info(" get product total size = " + total);

            int totalInt = total.intValue();
            int  totalPage =1;
            if (totalInt>0) {
                totalPage=(totalInt-1)/size +1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lotteryList  error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        log.info("/web/product  to /product/json/productList");

        return "/wealth-finance-service/product/json/productListJson";
    }

    /**
     * 查看产品详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/product/{id}", method = RequestMethod.GET)
    public String getProduct(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get product id = " + id);
        try {
            Product product = productService.getObjectById(id);
            log.info("get product data is " + product);
            if(null == product){
                log.info(" id = "+id+" product is not exit ");
                model.addAttribute("code",-700000015);
                return "/data/json";
            }

            model.addAttribute("code", 0);

            model.addAttribute("product", product);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get product error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/product/json/productDetailJson";
    }

    /**
     * 编辑产品
     * @param request
     * @param response
     * @param model
     * @param id
     * @param product
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/kailin/product/{id}", method = RequestMethod.PUT)
    public String updateProductJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model,
                                    @PathVariable Long id,Product product) throws Exception {

        log.info("update product : product= " +product);

        try {
            Product oldProdcut =  productService.getObjectById(id);
            if(null == oldProdcut){
                log.info(" id = "+id+" product is not exit ");
                model.addAttribute("code",-700000015);
                return "/data/json";
            }

//            Manager manager = (Manager) request.getAttribute("manager");
            Manager manager = managerService.getObjectById(101L);
                    log.info(" manager id = "+manager.getId());
            if(StringUtil.isEmpty(product.getProductNo())){
                model.addAttribute("code",-700000000);
                return "/data/json";
            }
            if(StringUtil.isEmpty(product.getName())){
                model.addAttribute("code",-700000001);
                return "/data/json";
            }

            if(StringUtil.isEmpty(product.getSecondLevelNo())){
                model.addAttribute("code",-700000002);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getProductType())){
                model.addAttribute("code",-700000003);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getBuyStatus())){
                model.addAttribute("code",-700000004);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getFixedInvestmentSatus())){
                model.addAttribute("code",-700000005);
                return "/data/json";
            }if(StringUtil.isEmpty(product.getFundNo())){
                model.addAttribute("code",-700000006);
                return "/data/json";
            }if(StringUtil.isEmpty(product.getScaleUpperLimit())){
                model.addAttribute("code",-700000007);
                return "/data/json";
            }
            if(StringUtil.isEmpty(product.getProductDesc())){
                model.addAttribute("code",-700000008);
                return "/data/json";
            }if(StringUtil.isEmpty(product.getPeriod())){
                model.addAttribute("code",-700000009);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getAnnualYield())){
                model.addAttribute("code",-700000010);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getAmount())){
                model.addAttribute("code",-700000011);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getInterestStartDate())){
                model.addAttribute("code",-700000012);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getInvestmentConfirmDate())){
                model.addAttribute("code",-700000013);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getStatus())){
                model.addAttribute("code", -700000014);
                return "/data/json";
            }
            if(DataUtils.isNullOrEmpty(product.getId())){
                model.addAttribute("code",-700000016);
                return "/data/json";
            }
            if(DataUtils.isNullOrEmpty(product.getId())){
                model.addAttribute("code",-700000017);
                return "/data/json";
            }
            //每次编辑，都修改下年化收益率的值
            //step1:判断当前时间是今日的15点之前还是15点之后，如果是15点之前，修改前一天的数据，staticAt是前一天零点
            // 如果是15点之后，修改今日的年化收益数据，staticAt是今日的零点

            Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
            Long now = System.currentTimeMillis();
            Boolean thirteen = WeekCountUtil.timeCalculate(now);
            log.info(" thirteen  = "+thirteen);
            if(thirteen){
                //3点之前，static是昨天的零点
                staticAt = staticAt - 24*60*60*1000L;
            }else {
                //3点之后,static是今天的零点
            }
            log.info(" staticAt = "+getDate(staticAt));
            //step2:查询该staticAt是否有数据，如果有，更新，如果没有，新增
            List<Long> annualYieldIds =  annualYieldService.getAnnualYieldIdsByProductId(id,0,1);
            log.info(" annualYieldIds size = "+annualYieldIds.size());
            if(annualYieldIds.size()>0){
                AnnualYield annualYield = annualYieldService.getObjectById(annualYieldIds.get(0));
                log.info(" last annualYield = "+annualYield+" staticAt = "+annualYield.getStaticAt());
                //判断时间
                if(staticAt.equals(annualYield.getStaticAt())){
                    log.info(" update ");
                    //如果相等，更新
                    annualYield.setAnnualYield(product.getAnnualYield());
                    annualYield.setUpdateBy(manager.getId());
                    annualYieldService.update(annualYield);
                }else {
                    log.info(" add  ");
                    //新增
                    AnnualYield annualYield1 = new AnnualYield();
                    annualYield1.setAnnualYield(product.getAnnualYield());
                    annualYield1.setStaticAt(staticAt);
                    annualYield1.setProductId(id);
                    annualYield1.setCreateBy(manager.getId());
                    annualYield1.setUpdateBy(manager.getId());
                    Long annualYId =  annualYieldService.insert(annualYield1);
                    log.info(" new annualYId = "+annualYId+" staticAt = "+getDate(staticAt));
                }
            }else {
                //没有过，新增
                AnnualYield annualYield1 = new AnnualYield();
                annualYield1.setAnnualYield(product.getAnnualYield());
                annualYield1.setStaticAt(staticAt);
                annualYield1.setProductId(id);
                annualYield1.setCreateBy(manager.getId());
                annualYield1.setUpdateBy(manager.getId());
                Long annualYId =  annualYieldService.insert(annualYield1);
                log.info(" new annualYId = "+annualYId+" staticAt = "+getDate(staticAt));
            }


            product.setUpdateBy(manager.getId());
            product.setCreateAt(oldProdcut.getCreateAt());
            product.setCreateBy(oldProdcut.getCreateBy());
            productService.update(product);

            model.addAttribute("code", 0);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update product error,id is  " +id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }

    /**
     * 新增产品
     * @param request
     * @param response
     * @param model
     * @param product
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/kailin/product", method = RequestMethod.POST)
    public String addProductJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,Product product) throws Exception {

        log.info("update product : product= "+product );

        try {
            Manager manager = (Manager) request.getAttribute("manager");
//            Manager manager = managerService.getObjectById(101L);

            log.info(" manager id = "+manager.getId());
            if(StringUtil.isEmpty(product.getProductNo())){
                model.addAttribute("code",-700000000);
                return "/data/json";
            }
            if(StringUtil.isEmpty(product.getName())){
                model.addAttribute("code",-700000001);
                return "/data/json";
            }

            if(StringUtil.isEmpty(product.getSecondLevelNo())){
                model.addAttribute("code",-700000002);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getProductType())){
                model.addAttribute("code",-700000003);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getBuyStatus())){
                model.addAttribute("code",-700000004);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getFixedInvestmentSatus())){
                model.addAttribute("code",-700000005);
                return "/data/json";
            }if(StringUtil.isEmpty(product.getFundNo())){
                model.addAttribute("code",-700000006);
                return "/data/json";
            }if(StringUtil.isEmpty(product.getScaleUpperLimit())){
                model.addAttribute("code",-700000007);
                return "/data/json";
            }
            if(StringUtil.isEmpty(product.getProductDesc())){
                model.addAttribute("code",-700000008);
                return "/data/json";
            }if(StringUtil.isEmpty(product.getPeriod())){
                model.addAttribute("code",-700000009);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getAnnualYield())){
                model.addAttribute("code",-700000010);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getAmount())){
                model.addAttribute("code",-700000011);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getInterestStartDate())){
                model.addAttribute("code",-700000012);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getInvestmentConfirmDate())){
                model.addAttribute("code",-700000013);
                return "/data/json";
            }if(DataUtils.isNullOrEmpty(product.getStatus())){
                model.addAttribute("code",-700000014);
                return "/data/json";
            }


            product.setCreateBy(manager.getId());
            product.setUpdateBy(manager.getId());
            model.addAttribute("code", 0);
            productService.insert(product);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add product error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }


    /**
     * 修改状态
     * @param request
     * @param response
     * @param model
     * @param status
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/kailin/product/{status}/{id}", method = RequestMethod.PUT)
    public String updateProductStatus(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,@PathVariable Integer status,
                                      @PathVariable Long id ) throws Exception {

        log.info("update product status : id= "+id+" status = "+status );

        try {
//            Manager manager = (Manager) request.getAttribute("manager");
            Manager manager = managerService.getObjectById(101L);

            log.info(" manager id = "+manager.getId());
           if(DataUtils.isNullOrEmpty(status)){
                model.addAttribute("code",-700000014);
                return "/data/json";
            }
            if(DataUtils.isNullOrEmpty(id)){
                model.addAttribute("code",-700000016);
                return "/data/json";
            }
            Product product = productService.getObjectById(id);
            product.setStatus(status);
            product.setUpdateBy(manager.getId());
            model.addAttribute("code", 0);
            productService.update(product);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update  product  status error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }



    @RequestMapping(value = "/web/a/product/{id}", method = RequestMethod.DELETE)
    public String deleteProductJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete product : id= " + id);
        try {
            productService.delete(id);

            log.info("add product success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete product error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/product", method = RequestMethod.GET)
    public String getMultiProductJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Product> productList = productService.getObjectsByIds(idList);
            log.info("get  product data is " + productList);

            model.addAttribute("code", 0);
            model.addAttribute("total", productList.size());

            model.addAttribute("productList", productList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get product error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/wealth-common-service/product/json/productListJson";
    }


}

