package com.ptteng.wealth.admin.controller;

import com.ptteng.wealth.admin.model.Constant;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.qding.common.util.DataUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by arthur on 16/8/30.
 */

@Controller
public class LoanProductController extends  BaseController {


    @RequestMapping(value = "/a/u/loanproduct/list", method = RequestMethod.GET)
    public String deptSearch(ModelMap model) throws Exception {
        try {

            List<Long> idLs = loanProductService.getLoanIds(0,Integer.MAX_VALUE);
            List<LoanProduct> loanProducts = loanProductService.getObjectsByIds(idLs);
            model.addAttribute("code", 0);
            model.addAttribute("loanProducts",loanProducts);

        } catch (Throwable t) {
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }
        return "/wealth-admin-web/loanproduct/json/loanProductListJson";
    }

    @RequestMapping(value = "/a/u/loanproduct", method = RequestMethod.POST)
    public String saveLoan(ModelMap model,String name,String rate,String overRate
                            ,Integer repayLine,String ratio,Integer payManner) throws Exception {
        try {

            LoanProduct loanProduct = new LoanProduct();
            loanProduct.setDal(LoanProduct.DAL);
            loanProduct.setName(name);
            loanProduct.setRate(new BigDecimal(rate));
            loanProduct.setOverRate(new BigDecimal(overRate));
            loanProduct.setRepayLine(repayLine);
            loanProduct.setRatio(new BigDecimal(ratio));
            loanProduct.setPayManner(payManner);
            loanProduct.setCreateAt(System.currentTimeMillis());
            loanProduct.setUpdateAt(System.currentTimeMillis());
            Long id = loanProductService.insert(loanProduct);
            model.addAttribute("code", 0);
            model.addAttribute("id",id);

        } catch (Throwable t) {
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

    @RequestMapping(value = "/a/u/loanproduct/{id}", method = RequestMethod.PUT)
    public String  updateLoan(ModelMap model,@PathVariable Long id,String name,String rate,String overRate
            ,Integer repayLine,String ratio,Integer payManner) throws Exception {
        try {
            log.info("UpdataLoan id: "+id+" name: "+name+" rate: "+rate+" overRate: "+overRate+" repayLine: "+repayLine+" ratio: "+ratio+" payManner: "+payManner);
            LoanProduct loanProduct = loanProductService.getObjectById(id);
            loanProduct.setDal(LoanProduct.DAL);
            loanProduct.setName(name);
            loanProduct.setRate(new BigDecimal(rate));
            loanProduct.setOverRate(new BigDecimal(overRate));
            loanProduct.setRepayLine(repayLine);
            loanProduct.setRatio(new BigDecimal(ratio));
            loanProduct.setPayManner(payManner);
            loanProduct.setUpdateAt(System.currentTimeMillis());
            loanProductService.update(loanProduct);
            log.info("rate: "+loanProduct.getRate());
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

    @RequestMapping(value = "/a/u/loanproduct/{id}", method = RequestMethod.DELETE)
    public String deleteLoan(ModelMap model,@PathVariable Long id) throws Exception {
        try {
            loanProductService.delete(id);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

    @RequestMapping(value = "/a/u/small/loan/params", method = RequestMethod.PUT)
    public String updateSmallLoanParams(ModelMap model, String begin, String end, String verifyLine, String defaultLine, String dailySmallLoanLine) throws Exception {
        try {
            log.info("update small loan params : " + begin + " " + end + " " + verifyLine + " " + defaultLine + " " + dailySmallLoanLine);
            if (DataUtils.isNullOrEmpty(begin) || DataUtils.isNullOrEmpty(end) || DataUtils.isNullOrEmpty(verifyLine) ||
                    DataUtils.isNullOrEmpty(defaultLine) || DataUtils.isNullOrEmpty(dailySmallLoanLine)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
            }

            updateConstant("begin", begin);
            updateConstant("end", end);
            updateConstant("verifyLine", verifyLine);
            updateConstant("defaultLine", defaultLine);
            updateConstant("dailySmallLoanLine", dailySmallLoanLine);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error("update small loan params error ");
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }

    @RequestMapping(value = "/a/u/small/loan/params", method = RequestMethod.GET)
    public String updateSmallLoanParams(ModelMap model) throws Exception {
        try {
            log.info("get small loan params ");

            String begin = constantService.getValue("begin", "smallLoan");
            String end = constantService.getValue("end", "smallLoan");
            String verifyLine = constantService.getValue("verifyLine", "smallLoan");
            String defaultLine = constantService.getValue("defaultLine", "smallLoan");
            String dailySmallLoanLine = constantService.getValue("dailySmallLoanLine", "smallLoan");

            model.addAttribute("code", 0);
            model.addAttribute("end", end);
            model.addAttribute("verifyLine", verifyLine);
            model.addAttribute("defaultLine", defaultLine);
            model.addAttribute("dailySmallLoanLine", dailySmallLoanLine);
            model.addAttribute("begin", begin);

        } catch (Throwable t) {
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error("get small loan params error ");
            model.addAttribute("code", -100000);
        }
        return "/wealth-admin-web/loanproduct/json/smallLoanParams";
    }

    private void updateConstant(String key, String newValue) throws Exception{
        Long id = constantService.getConstantIdByKeyAndType(key, "smallLoan");
        Constant constant = constantService.getObjectById(id);
        constant.setValue(newValue);
        constantService.update(constant);
    }

}
