package com.ptteng.uweiqian.organization.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.uweiqian.organization.model.UserApply;
import com.ptteng.uweiqian.organization.service.UserApplyService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserApplyServiceImpl extends BaseDaoServiceImpl implements UserApplyService {

 

	private static final Log log = LogFactory.getLog(UserApplyServiceImpl.class);



		   
		@Override
		public Long insert(UserApply userApply)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userApply);

		if (userApply == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userApply.setCreateAt(currentTimeMillis);
		userApply.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userApply);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userApply);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserApply> insertList(List<UserApply> userApplyList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userApplyList == null ? "null" : userApplyList.size()));
      
		List<UserApply> resultList = null;

		if (CollectionUtils.isEmpty(userApplyList)) {
			return new ArrayList<UserApply>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserApply userApply : userApplyList) {
			userApply.setCreateAt(currentTimeMillis);
			userApply.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserApply>) dao.batchSave(userApplyList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userApplyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserApply.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserApply userApply)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userApply == null ? "null" : userApply.getId()));

		boolean result = false;

		if (userApply == null) {
			return true;
		}

		userApply.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userApply);
		} catch (DaoException e) {
			log.error(" update wrong : " + userApply);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userApply);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserApply> userApplyList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userApplyList == null ? "null" : userApplyList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userApplyList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserApply userApply : userApplyList) {
			userApply.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userApplyList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userApplyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userApplyList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserApply getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserApply userApply = null;

		if (id == null) {
			return userApply;
		}

		try {
			userApply = (UserApply) dao.get(UserApply.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userApply;		
		}	
		  
    	   
		@Override
		public List<UserApply> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserApply> userApply = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserApply>();
		}

		try {
			userApply = (List<UserApply>) dao.getList(UserApply.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userApply == null ? "null" : userApply.size()));
    
		return userApply;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserApplyIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserApplyIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserApplyIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserApplyIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserApplyIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

