package com.ptteng.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class BeanToMap {

	public HashMap<String, Object> beanToMap(Object b) {
		HashMap<String, Object> hashMap = new HashMap<String, Object>();
		Class<?> classType = b.getClass();
		Field[] fields = classType.getDeclaredFields();// 得到对象中的字段
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String fieldName = field.getName();
			if(fieldName.equals("serialVersionUID"))
			{
				continue;
			}
			// 获得属性的首字母并转换为大写，与setXXX对应
			String firstLetter = fieldName.substring(0, 1).toUpperCase();
			String getMethodName = "get" + firstLetter + fieldName.substring(1);
			try {
				Method getMethod = classType.getMethod(getMethodName);
				Object value=getMethod.invoke(b);
				hashMap.put(fieldName, value);
				
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 

		}
		return hashMap;
	}
}
