package com.ptteng.common.uweiqian.controller;

import java.awt.image.BufferedImage;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.http.cookie.MD5Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.qding.common.util.http.cookie.CookieUtil;
import javax.servlet.http.Cookie;
import java.io.OutputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import com.qding.common.util.http.cookie.RequestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.uweiqian.constant.InterfaceCodeConstant;
import com.ptteng.uweiqian.framework.interceptor.CookieConstant;
import com.ptteng.uweiqian.home.model.Sms;
import com.ptteng.uweiqian.home.service.SmsService;
import com.ptteng.uweiqian.organization.model.User;
import com.ptteng.uweiqian.organization.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
/**
 * Role crud
 *
 * @author magenm 2014-4-16 13:43
 *
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);
	@Autowired
	private UserService userService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private SmsService smsService;
    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;
    private boolean isCaptcha = false;
	  //1、校验手机号是否注册
    @RequestMapping(value = "/a/mobile", method = RequestMethod.GET)
    public String verifyNick(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile) throws Exception {

        log.info("verify the mobile: " + mobile);

        if (StringUtils.isBlank(mobile)) {
            model.addAttribute("code", -1000);
            log.info("params is null");
            return "/common/success";
        }
        try {
            Long uid = userService.getUserIdByMobile(mobile);

            if (uid != null) {
                model.addAttribute("code", -2007);
                log.info("mobile exist");
                return "/common/success";
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";

    }

    // 3、用户注册 
    @RequestMapping(value = "/a/user", method = RequestMethod.POST)
    public String register(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, String mobile,
                           String verify, String password, String nick) throws Exception {


        String type = "register";

        log.info(mobile + " is mobile " + verify + " is verify " + password
                + " is password " + nick + " is nick ");
        if (mobile == null || StringUtils.isBlank(verify) || StringUtils.isBlank(password)) {
            model.addAttribute("code", -1000);
            log.info("params is null");
            return "/common/success";
        }

        try {
            // 是否已注册
            Long uid = userService.getUserIdByMobile(mobile);

            if (uid != null) {
                log.info(mobile + " is already exist  " + uid);
                model.addAttribute("code", -2007);

                return "/common/success";

            } else {
                log.info(mobile + " not exist ,so can register ");
            }

            boolean verifyResult = false;


            if (verifyModel()) {
                log.info("is test model ");
                if ("555555".equals(verify)) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                    verifyResult = verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                log.info("log1: mobile is " + mobile + ",type = " + type + ",verify" + verify);
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            }

            // 校验验证码
            Long now = System.currentTimeMillis();
            SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyyMMdd");
            String date = myFmt2.format(now);
            if (verifyResult) {
                User user = new User();
                user.setMobile(mobile);
                mobile.split(mobile);
                //生成带星号码
                if (null == nick) {
                    
                    user.setName(mobile);
                } else {
                    user.setName(nick);
                }

                String encodePass = PasswordUtils.encode(password);
                user.setPwd(encodePass);
                Long userID = userService.insert(user);
               
                String token = IdentityUtil.encodeCookie("phone", userID);
                model.put("token", token);

                log.info(mobile + " register success,userID is " + userID);

                Map<String, String> maps = new HashMap();
                maps.put(CookieUtil.USER_ID, userID + "");
                maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
                cookieUtil.setIdentity(request, response, maps, userID);

                model.put("uid", userID);

                model.addAttribute("code", 0);

            } else {
                log.error("wrong verifycode");
                model.addAttribute("code", -2005);

                return "/common/success";
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common-uweiqian-service/user/json/register";
    }
    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }
    // 验证码校验
    private boolean verifyMobileCode(ModelMap model, String mobile, String type,
                                     String verify) throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        log.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            log.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }

    //4、用户登陆
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String aLogin(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, String mobile, String pwd)
            throws Exception {
        log.info("mobile is " + mobile + "pwd is " + pwd);

        if (mobile == null) {
            model.addAttribute("code", -1000);

            return "/common/success";
        }

        Long uid = userService.getUserIdByMobile(mobile);
        String token = IdentityUtil.encodeCookie("phone", uid);

        if (uid == null) {
            model.addAttribute("code", -2002);
            return "/common/success";
        }
        log.info(" uid is " + uid);
        User user = this.userService.getObjectById(uid);
        String pass = PasswordUtils.encode(pwd);
        Boolean verify = user.getPwd().equals(pass);
        if (verify) {
            log.info(uid + " login ");
            Map<String, String> maps = new HashMap();


            maps.put(CookieUtil.USER_ID, uid + "");
            maps.put(CookieConstant.Cookie_WEB_mobile, mobile);
            cookieUtil.setIdentity(request, response, maps, uid);

            model.addAttribute("code", 0);
            model.addAttribute("uid", uid);

            model.put("token", token);

        } else {
            log.info(mobile + " wrong pwd " + pwd);

            model.put("code", -2006);

            return "/common/success";

        }

        return "/common-uweiqian-service/user/json/register";
    }


    // 5、验证码发送
    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String type) throws ServiceException, ServiceDaoException {
        log.info(mobile + " want send sms of type " + type);
        //验证图形验证码
        /**if (!isCaptcha){
            model.addAttribute("code", -2005);
            return "/common/success";
        }**/

        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {

                log.info(type + " is already exist  " + mobile);

                model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
                return "/common/success";
            }

        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {

                log.info(type + " is not already exist  " + mobile);

                model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
                return "/common/success";
            }
        }

        int code = InterfaceCodeConstant.System_Success;

        try {
            String result = this.smsService.sendMsg(mobile, type);
//            smsService.getSmsIdByMobileAndType(mobile,type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = InterfaceCodeConstant.VerifyCode_MoreThan5;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", InterfaceCodeConstant.System_Exception);

        }
        return "/common/success";

    }


    // 语音验证码
    @RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            String mobile, String type) throws ServiceException, ServiceDaoException {
        log.info(mobile + " want send voice of type " + type);

        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
            return "/common/success";
        }
        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {
                log.info(type + " is already exist  " + mobile);
                model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
                return "/common/success";
            }
        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {
                log.info(type + " is not already exist  " + mobile);
                model.addAttribute("code", InterfaceCodeConstant.User_NotExist);
                return "/common/success";
            }
        }

        int code = InterfaceCodeConstant.System_Success;

        try {
            String result = this.smsService.sendVoice(mobile, type);
            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = InterfaceCodeConstant.VerifyCode_MoreThan5;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = InterfaceCodeConstant.VerifyCode_sendError;
                    break;
                default:

            }

            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send voice error of type " + type);
            model.addAttribute("code", InterfaceCodeConstant.System_Exception);
        }

        return "/common/success";
    }


    // 6、忘记密码
    @RequestMapping(value = "/a/password/forget", method = RequestMethod.PUT)
    public String rewritepwd(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String verify, String newpwd) throws Exception {
        try {

            // 是否已注册
            Long uid = userService.getUserIdByMobile(mobile);

            // 用户不存在
            if (uid == null) {
                log.info(mobile + " not exist ");
                model.addAttribute("code", -2000);

                return "/common/success";

            } else {
                log.info(mobile + " exist and uid is " + uid);
            }

            boolean verifyResult = false;

            String type = "password";

            // 测试模式
            if (verifyModel()) {
                if ("555555".equals(verify)) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyMobileCode(model, mobile, type, verify);
                }
            } else {
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            }

            if (verifyResult) {
                User user = userService.getObjectById(uid);

                String encodePass = PasswordUtils.encode(newpwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

                log.info(mobile + " change password," + newpwd + "result is " + result);
                log.error("rewrite password success! ");

                model.addAttribute("code", 0);
            } else {
                log.error("rewritepwd verifycode");
                model.addAttribute("code", -2005);

                return "/common/success";
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";

    }

    //7、退出登录
    @RequestMapping(value = "/a/u/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager logout ");

        try {
            cookieUtil.clearCookie(response);

            model.addAttribute("code", 0);

            return "/common/success";
        } catch (Throwable t) {
            log.error("user logout error  ");
            t.printStackTrace();

            return "/common/success";

        }


    }

//    // 生成图形验证码
//    @RequestMapping(value = "/a/captcha/generate", method = RequestMethod.GET)
//    public void captchaGenerate(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
//        log.info("To captchaGenerate ------------------");
//        try {
//            // 设置页面不缓存
//            response.reset();
//            response.setHeader("Pragma", "No-cache");
//            response.setHeader("Cache-Control", "no-cache");
//            response.setDateHeader("Expires", 0);
//            response.setContentType("image/gif");
//
//            // 生成随机字符
//            String randomStr = RandomStringUtils.randomAlphabetic(4).toUpperCase();
//            log.info("randomStr: " + randomStr);
//            // 存入cookie
//            response.addCookie(new Cookie("captcha", MD5Util.getMd5Sum(randomStr)));
//
//            // 生成图片流
//            BufferedImage bi = new CaptchaUtil().generate(165, 40, randomStr).getImage();
//            // 创建输出流
//            OutputStream out = response.getOutputStream();
//            // 将图片写入到输出流中去
//            ImageIO.write(bi, "JPG", out);
//            // 强制刷新
//            out.flush();
//            // 关闭输出流
//            out.close();
//        } catch (Exception e) {
//            log.error("get captchaGenerate error", e);
//            model.addAttribute("code", -1);
//        }
//
//    }

    // 验证图形验证码
    @RequestMapping(value = "/a/captcha/verify", method = RequestMethod.GET)
    public String captchaVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                String inputValue) throws Exception {
        log.info("To captchaVerify ------------------");

        log.info("inputValue: " + inputValue);

        try {
            String cookieValue = "";
            try {
                cookieValue = RequestUtil.getCookie(request,"captcha").getValue();
            } catch (Exception e) {
                log.error("got error when getCookie");
            }
            log.info("cookieValue: " + cookieValue);

            if (StringUtils.isBlank(inputValue) || StringUtils.isBlank(cookieValue)) {
                model.addAttribute("code", -2005);
                return "/common/success";
            }

            String md5Value = "";
            try {
                md5Value = MD5Util.getMd5Sum(inputValue.toUpperCase());
            } catch (NoSuchAlgorithmException e) {
                log.error("got error when getMD5");
            }

            log.info("md5Value: " + md5Value);

            if (md5Value.equals(cookieValue)) {
                isCaptcha = true;
                model.addAttribute("code", 0);
            } else {
                isCaptcha = false;
                model.addAttribute("code", -2005);
            }
        } catch (Exception e) {
            log.error("get captchaVerify error", e);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }
    /**
	 * 根据用户id编辑用户信息 /a/u/user/{uid} put
	 */
	@RequestMapping(value = "/a/u/user/{uid}", method = RequestMethod.PUT)
	public String updateUsersJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, User users,
			@PathVariable Long uid) throws Exception {

		log.info("update users : users= " + users);

		try {
			// String userId = cookieUtil.getKeyIdentity(request,
			// CookieUtil.USER_ID);
			User u = userService.getObjectById(uid);
			if (u == null) {
				log.info("u is null ");
				model.addAttribute("code", -8002);
				return "/data/json";
			} else {
				if (users == null) {
					log.info("users is null ");
					model.addAttribute("code", -1004);
					return "/data/json";
				}
				u.setName(users.getName());
				u.setEmail(users.getEmail());
				u.setMobile(users.getMobile());
				u.setCardNum(users.getCardNum());
				userService.update(u);
				model.addAttribute("code", 0);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update users error,id is  " + users.getId());
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

}
