/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.uweiqian.etl;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.uweiqian.etl.util.DynamicUtil;
import com.ptteng.uweiqian.etl.util.MD5Util;
import com.ptteng.uweiqian.organization.model.User;
import com.ptteng.uweiqian.organization.model.UserDayCount;
import com.ptteng.uweiqian.organization.model.UserFlow;
import com.ptteng.uweiqian.organization.service.UserDayCountService;
import com.ptteng.uweiqian.organization.service.UserFlowService;
import com.ptteng.uweiqian.organization.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetMerchantEtl {
    private static final Log log = LogFactory.getLog(GetMerchantEtl.class);
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 60000L;
    private String url = "https://download.swiftpass.cn/gateway";
    private ImgStorageUtil imgStorageUtil;
    private UserFlowService userFlowService;
    private UserService userService;
    private UserDayCountService userDayCountService;

    public UserDayCountService getUserDayCountService() {
        return this.userDayCountService;
    }

    public void setUserDayCountService(UserDayCountService userDayCountService) {
        this.userDayCountService = userDayCountService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserFlowService getUserFlowService() {
        return this.userFlowService;
    }

    public void setUserFlowService(UserFlowService userFlowService) {
        this.userFlowService = userFlowService;
    }

    public ImgStorageUtil getImgStorageUtil() {
        return this.imgStorageUtil;
    }

    public void setImgStorageUtil(ImgStorageUtil imgStorageUtil) {
        this.imgStorageUtil = imgStorageUtil;
    }

    public String getRequestParam(String bill_type, String bill_date, String key, String mch_id) {
        String random_32 = RandomStringUtils.randomAlphabetic((int)32);
        try {
            StringBuilder md5params = new StringBuilder();
            md5params.append("bill_date=" + bill_date);
            md5params.append("&bill_type=" + bill_type);
            md5params.append("&mch_id=" + mch_id);
            md5params.append("&nonce_str=" + random_32);
            md5params.append("&service=pay.bill.merchant");
            md5params.append("&key=" + key);
            String sign = MD5Util.MD5Encode(md5params.toString(), "utf-8").toUpperCase();
            String requestParam = "<xml><bill_date><![CDATA[" + bill_date + "]]></bill_date>" + "<bill_type><![CDATA[" + bill_type + "]]></bill_type>" + "<mch_id><![CDATA[" + mch_id + "]]></mch_id>" + "<nonce_str><![CDATA[" + random_32 + "]]></nonce_str>" + "<service><![CDATA[pay.bill.merchant]]></service>" + "<sign><![CDATA[" + sign + "]]></sign></xml>";
            return requestParam;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void getMerchant() {
        try {
            Map<Object, Object> params = new HashMap();
            params = DynamicUtil.getUserList();
            List idList = this.userService.getIdsByDynamicCondition(User.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List userList = this.userService.getObjectsByIds(idList);
            int i = 0;
            while (i < userList.size()) {
                User user = (User)userList.get(i);
                if (DataUtils.isNotNullOrEmpty((Object)user.getUserNum()) && DataUtils.isNotNullOrEmpty((Object)user.getUserKey())) {
                    Long timestamp = System.currentTimeMillis();
                    Long now = System.currentTimeMillis();
                    HashMap headers = new HashMap();
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        Date date = new Date();
                        Calendar c = Calendar.getInstance();
                        c.set(5, c.get(5) - 1);
                        String requestParam = this.getRequestParam("ALL", sdf.format(c.getTime()), new String(user.getUserKey().getBytes(), "utf-8"), new String(user.getUserNum().getBytes(), "utf-8"));
                        String result = HttpClientUtil.sendPostRequestByJavaSetHeader((String)this.url, (String)requestParam, (String)"application/xml", (String)"");
                        this.analysisResult(result);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insertDayCount();
    }

    public void getTestMe() {
        try {
            Long timestamp = System.currentTimeMillis();
            Long now = System.currentTimeMillis();
            HashMap headers = new HashMap();
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                Date date = new Date();
                Calendar c = Calendar.getInstance();
                c.set(5, c.get(5) - 1);
                String requestParam = this.getRequestParam("ALL", "20170228", "105530000491", "9d9603b3c7738492d98a0f227d60c2e3");
                System.out.println(requestParam);
                String result = HttpClientUtil.sendPostRequestByJavaSetHeader((String)this.url, (String)requestParam, (String)"application/xml", (String)"");
                log.info((Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean analysisResult(String result) {
        String[] flowRecord = result.split("\n");
        ArrayList<UserFlow> userFlowList = new ArrayList<UserFlow>();
        int i = 1;
        while (i < flowRecord.length - 2) {
            block9: {
                String[] flowRecordDetail;
                block8: {
                    flowRecordDetail = flowRecord[i].replace("`", "").split(",");
                    try {
                        List ids = this.userFlowService.getUserFlowIdByUserOrderNum(flowRecordDetail[8]);
                        if (ids.size() <= 0) break block8;
                        break block9;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                try {
                    date = sdf.parse(flowRecordDetail[0]);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                UserFlow userFlow = new UserFlow();
                userFlow.setTradingTime(Long.valueOf(date.getTime()));
                userFlow.setSubUserNum(flowRecordDetail[4]);
                userFlow.setSwiftpassOrderNum(flowRecordDetail[6]);
                userFlow.setUserOrderNum(flowRecordDetail[8]);
                userFlow.setTransactionType(flowRecordDetail[10]);
                userFlow.setTransactionStatus(flowRecordDetail[11]);
                userFlow.setCurrencyType(flowRecordDetail[13]);
                userFlow.setTotalMoney(flowRecordDetail[14]);
                userFlow.setRefundMoney(flowRecordDetail[18]);
                userFlow.setRefundStatus(flowRecordDetail[21]);
                userFlow.setCounterFee(flowRecordDetail[24]);
                userFlow.setRate(flowRecordDetail[25]);
                userFlow.setUserName(flowRecordDetail[29]);
                userFlowList.add(userFlow);
            }
            ++i;
        }
        try {
            if (userFlowList.size() > 0) {
                this.userFlowService.insertList(userFlowList);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void insertDayCount() {
        try {
            Map<Object, Object> params = new HashMap();
            params = DynamicUtil.getUserList();
            List idList = this.userService.getIdsByDynamicCondition(User.class, params, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List userList = this.userService.getObjectsByIds(idList);
            int i = 0;
            while (i < userList.size()) {
                User user = (User)userList.get(i);
                if (DataUtils.isNotNullOrEmpty((Object)user.getUserNum()) && DataUtils.isNotNullOrEmpty((Object)user.getUserKey())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat sdfAll = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = new Date();
                    Calendar c = Calendar.getInstance();
                    c.set(5, c.get(5) - 1);
                    Long startTime = sdfAll.parse(String.valueOf(sdf.format(c.getTime())) + " 00:00:00").getTime();
                    Long endTime = sdfAll.parse(String.valueOf(sdf.format(c.getTime())) + " 23:59:59").getTime();
                    Map<String, Object> mapDayCount = DynamicUtil.getUserDayCountListByUserNum(user.getUserNum(), sdf.parse(sdf.format(c.getTime())).getTime());
                    List idsDayCount = this.userDayCountService.getIdsByDynamicCondition(UserDayCount.class, mapDayCount, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    if (idsDayCount.size() <= 0) {
                        Map<Object, Object> paramsWechat = new HashMap();
                        paramsWechat = DynamicUtil.getUserFlowListByUserNum(user.getUserNum(), "pay.weixin", startTime, endTime);
                        List idsWechat = this.userFlowService.getIdsByDynamicCondition(UserFlow.class, paramsWechat, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                        List userFlowListWechat = this.userFlowService.getObjectsByIds(idsWechat);
                        ArrayList<UserDayCount> userDayCountList = new ArrayList<UserDayCount>();
                        BigDecimal refundTotalMoney = new BigDecimal("0.0");
                        BigDecimal successTotalPayMoney = new BigDecimal("0.0");
                        BigDecimal totalMoney = new BigDecimal("0.0");
                        Integer refundTotalNum = 0;
                        Integer successTotalNum = 0;
                        int j = 0;
                        while (j < userFlowListWechat.size()) {
                            System.out.println(((UserFlow)userFlowListWechat.get(j)).getCounterFee());
                            totalMoney = totalMoney.add(new BigDecimal(((UserFlow)userFlowListWechat.get(j)).getTotalMoney()));
                            if ("\u652f\u4ed8\u6210\u529f".equals(((UserFlow)userFlowListWechat.get(j)).getTransactionStatus())) {
                                successTotalNum = successTotalNum + 1;
                                successTotalPayMoney = successTotalPayMoney.add(new BigDecimal(((UserFlow)userFlowListWechat.get(j)).getCounterFee()));
                                System.out.println("successTotalPayMoney:" + successTotalPayMoney);
                            } else if ("\u8f6c\u5165\u9000\u6b3e".equals(((UserFlow)userFlowListWechat.get(j)).getTransactionStatus()) && "\u9000\u6b3e\u6210\u529f".equals(((UserFlow)userFlowListWechat.get(i)).getRefundStatus())) {
                                refundTotalNum = refundTotalNum + 1;
                                refundTotalMoney = refundTotalMoney.add(new BigDecimal(((UserFlow)userFlowListWechat.get(j)).getRefundMoney()));
                            }
                            ++j;
                        }
                        UserDayCount userDayCountWechat = new UserDayCount();
                        userDayCountWechat.setDayTime(Long.valueOf(sdf.parse(sdf.format(c.getTime())).getTime()));
                        userDayCountWechat.setSuccessRefundMoney("" + refundTotalMoney);
                        userDayCountWechat.setSuccessRefundNum("" + refundTotalNum);
                        userDayCountWechat.setSubUserNum(user.getUserNum());
                        userDayCountWechat.setTotalMoney("" + totalMoney);
                        userDayCountWechat.setSuccessPayMoney("" + successTotalPayMoney);
                        userDayCountWechat.setSuccessPayNum("" + successTotalNum);
                        userDayCountWechat.setTransactionType("pay.weixin");
                        userDayCountList.add(userDayCountWechat);
                        Map<Object, Object> paramsAli = new HashMap();
                        paramsAli = DynamicUtil.getUserFlowListByUserNum(user.getUserNum(), "pay.alipay", startTime, endTime);
                        List idsAli = this.userFlowService.getIdsByDynamicCondition(UserFlow.class, paramsAli, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                        List userFlowListAli = this.userFlowService.getObjectsByIds(idsAli);
                        BigDecimal refundTotalMoneyAli = new BigDecimal("0.0");
                        BigDecimal successTotalPayMoneyAli = new BigDecimal("0.0");
                        BigDecimal totalMoneyali = new BigDecimal("0.0");
                        Integer refundTotalNumAli = 0;
                        Integer successTotalNumAli = 0;
                        int j2 = 0;
                        while (j2 < userFlowListAli.size()) {
                            totalMoneyali = totalMoneyali.add(new BigDecimal(((UserFlow)userFlowListAli.get(j2)).getTotalMoney()));
                            if ("\u652f\u4ed8\u6210\u529f".equals(((UserFlow)userFlowListAli.get(j2)).getTransactionStatus())) {
                                successTotalNumAli = successTotalNumAli + 1;
                                successTotalPayMoneyAli = successTotalPayMoneyAli.add(new BigDecimal(((UserFlow)userFlowListAli.get(j2)).getCounterFee()));
                            } else if ("\u8f6c\u5165\u9000\u6b3e".equals(((UserFlow)userFlowListAli.get(j2)).getTransactionStatus()) && "\u9000\u6b3e\u6210\u529f".equals(((UserFlow)userFlowListAli.get(i)).getRefundStatus())) {
                                refundTotalNumAli = refundTotalNumAli + 1;
                                refundTotalMoneyAli = refundTotalMoneyAli.add(new BigDecimal(((UserFlow)userFlowListAli.get(j2)).getRefundMoney()));
                            }
                            ++j2;
                        }
                        UserDayCount userDayCountAli = new UserDayCount();
                        userDayCountAli.setDayTime(Long.valueOf(sdf.parse(sdf.format(c.getTime())).getTime()));
                        userDayCountAli.setSuccessRefundMoney("" + refundTotalMoneyAli);
                        userDayCountAli.setSuccessRefundNum("" + refundTotalNumAli);
                        userDayCountAli.setSubUserNum(user.getUserNum());
                        userDayCountAli.setTotalMoney("" + totalMoneyali);
                        userDayCountAli.setSuccessPayMoney("" + successTotalPayMoneyAli);
                        userDayCountAli.setSuccessPayNum("" + successTotalNumAli);
                        userDayCountAli.setTransactionType("pay.alipay");
                        userDayCountList.add(userDayCountAli);
                        this.userDayCountService.insertList(userDayCountList);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        GetMerchantEtl getMer = new GetMerchantEtl();
        try {
            getMer.getTestMe();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

