/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.uweiqian.common.util.YibaoUtil.withdrawal;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackUtils {
    private static final Log logger;
    public static final String DEFAULT_CHARSET = "GBK";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_ERROR_MESSAGE = "http_error_message";
    public static final int DEFAULT_TIMEOUT = 120000;
    public static final String HTTP_METHOD_DEFAULT = "GET";
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    public static final int MAX_FETCHSIZE = 500000;
    public static String IPREG;
    static Set DOMAINSUFFIX;

    public static boolean isIpAddress(String domain) {
        return Pattern.matches(IPREG, domain);
    }

    public static String getMainDomain(String urlLink) {
        if (urlLink == null || urlLink.equals("")) {
            return null;
        }
        urlLink = urlLink.toLowerCase();
        try {
            if (!urlLink.startsWith(HTTP_PREFIX) && !urlLink.startsWith(HTTPS_PREFIX)) {
                urlLink = HTTP_PREFIX + urlLink;
            }
            URL url = new URL(urlLink);
            String domain = url.getHost();
            return CallbackUtils.getDomain(domain);
        }
        catch (MalformedURLException e) {
            return urlLink;
        }
    }

    public static String getHost(String urlLink) {
        try {
            URL url = new URL(urlLink);
            return url.getHost();
        }
        catch (MalformedURLException e) {
            return urlLink;
        }
    }

    private static String getDomain(String host) {
        if (host == null || host.equals("")) {
            return null;
        }
        if (CallbackUtils.isIpAddress(host = host.toLowerCase())) {
            return host;
        }
        String[] terms = host.split("\\.");
        for (int i = terms.length - 1; i >= 0; --i) {
            if (DOMAINSUFFIX.contains(terms[i])) continue;
            return terms[i];
        }
        return host;
    }

    public static String httpRequest(String url, String method) {
        return CallbackUtils.httpRequest(url, "", method, DEFAULT_CHARSET);
    }

    public static String httpRequest(String url, String queryString, String method) {
        return CallbackUtils.httpRequest(url, queryString, method, DEFAULT_CHARSET);
    }

    public static String httpRequest(String url, Map params, String method) {
        return CallbackUtils.httpRequest(url, params, method, DEFAULT_CHARSET);
    }

    public static String httpPost(String url, Map params) {
        return CallbackUtils.httpRequest(url, params, HTTP_METHOD_POST, DEFAULT_CHARSET);
    }

    public static String httpPost(String url, String queryString) {
        return CallbackUtils.httpRequest(url, queryString, HTTP_METHOD_POST, DEFAULT_CHARSET);
    }

    public static String httpGet(String url, Map params) {
        return CallbackUtils.httpRequest(url, params, "GET", DEFAULT_CHARSET);
    }

    public static String httpGet(String url, String queryString) {
        return CallbackUtils.httpRequest(url, queryString, "GET", DEFAULT_CHARSET);
    }

    public static String httpRequest(String url, Map params, String method, String charSet) {
        String queryString = CallbackUtils.parseQueryString(params, charSet);
        return CallbackUtils.httpRequest(url, queryString, method, charSet);
    }

    public static String httpRequest(String targetUrl, String queryString, String sMethod, String charSet) {
        return CallbackUtils.httpRequest(targetUrl, queryString, sMethod, charSet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpRequest(String targetUrl, String queryString, String sMethod, String charSet, boolean sslVerify) {
        HttpURLConnection urlConn = null;
        URL destURL = null;
        boolean httpsFlag = false;
        if (targetUrl == null || targetUrl.trim().length() == 0) {
            throw new IllegalArgumentException("invalid targetUrl : " + targetUrl);
        }
        if ((targetUrl = targetUrl.trim()).toLowerCase().startsWith(HTTPS_PREFIX)) {
            httpsFlag = true;
        } else if (!targetUrl.toLowerCase().startsWith(HTTP_PREFIX)) {
            targetUrl = HTTP_PREFIX + targetUrl;
        }
        if (queryString != null) {
            queryString = queryString.trim();
        }
        String method = null;
        if (sMethod != null) {
            method = sMethod.toUpperCase();
        }
        if (method == null || !method.equals(HTTP_METHOD_POST) && !method.equals("GET")) {
            throw new IllegalArgumentException("invalid http method : " + method);
        }
        String baseUrl = "";
        String params = "";
        String fullUrl = "";
        int index = targetUrl.indexOf("?");
        if (index != -1) {
            baseUrl = targetUrl.substring(0, index);
            params = targetUrl.substring(index + 1);
        } else {
            baseUrl = targetUrl;
        }
        if (queryString != null && queryString.trim().length() != 0) {
            params = params.trim().length() > 0 ? params + "&" + queryString : params + queryString;
        }
        fullUrl = baseUrl + (params.trim().length() == 0 ? "" : "?" + params);
        StringBuffer result = new StringBuffer(2000);
        try {
            destURL = method.equals(HTTP_METHOD_POST) ? new URL(baseUrl) : new URL(fullUrl);
            urlConn = (HttpURLConnection)destURL.openConnection();
            if (!sslVerify && (urlConn instanceof javax.net.ssl.HttpsURLConnection || urlConn instanceof HttpsURLConnection)) {
                javax.net.ssl.HttpsURLConnection httpsUrlCon;
                System.out.println(urlConn.getClass() + "-------");
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
                if (urlConn instanceof javax.net.ssl.HttpsURLConnection) {
                    httpsUrlCon = (javax.net.ssl.HttpsURLConnection)urlConn;
                    httpsUrlCon.setSSLSocketFactory(sc.getSocketFactory());
                    httpsUrlCon.setHostnameVerifier(new TrustAnyHostnameVerifier());
                }
                if (urlConn instanceof HttpsURLConnection) {
                    httpsUrlCon = (HttpsURLConnection)urlConn;
                    httpsUrlCon.setSSLSocketFactory(sc.getSocketFactory());
                    httpsUrlCon.setHostnameVerifier(new TrustAnyHostnameVerifierOld());
                }
            }
            logger.info((Object)("-->" + urlConn.getClass()));
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + charSet);
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod(method);
            urlConn.setConnectTimeout(120000);
            urlConn.setReadTimeout(120000);
            if (method.equals(HTTP_METHOD_POST)) {
                OutputStream os = urlConn.getOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter(os, charSet);
                osw.write(params);
                osw.flush();
                osw.close();
            }
            BufferedInputStream is = new BufferedInputStream(urlConn.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, charSet));
            String temp = null;
            while ((temp = br.readLine()) != null) {
                result.append(temp);
                result.append("\n");
                if (result.length() <= 500000) continue;
            }
            int responseCode = urlConn.getResponseCode();
            logger.info((Object)("------------------ResponseCode[" + responseCode + "],and targetUrl[" + targetUrl + "] queryString[" + queryString + "]" + "and resultLength[" + result.length() + "]"));
            if (responseCode != 200) {
                String string = null;
                return string;
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            logger.warn((Object)("connection error : " + e.getMessage()));
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpRequest(String targetUrl, String queryString, String sMethod, String charSet, String requestProperty, boolean sslVerify) {
        HttpURLConnection urlConn = null;
        URL destURL = null;
        boolean httpsFlag = false;
        if (targetUrl == null || targetUrl.trim().length() == 0) {
            throw new IllegalArgumentException("invalid targetUrl : " + targetUrl);
        }
        if ((targetUrl = targetUrl.trim()).toLowerCase().startsWith(HTTPS_PREFIX)) {
            httpsFlag = true;
        } else if (!targetUrl.toLowerCase().startsWith(HTTP_PREFIX)) {
            targetUrl = HTTP_PREFIX + targetUrl;
        }
        if (queryString != null) {
            queryString = queryString.trim();
        }
        String method = null;
        if (sMethod != null) {
            method = sMethod.toUpperCase();
        }
        if (method == null || !method.equals(HTTP_METHOD_POST) && !method.equals("GET")) {
            throw new IllegalArgumentException("invalid http method : " + method);
        }
        String baseUrl = "";
        String params = "";
        String fullUrl = "";
        int index = targetUrl.indexOf("?");
        if (index != -1) {
            baseUrl = targetUrl.substring(0, index);
            params = targetUrl.substring(index + 1);
        } else {
            baseUrl = targetUrl;
        }
        if (queryString != null && queryString.trim().length() != 0) {
            params = params.trim().length() > 0 ? params + "&" + queryString : params + queryString;
        }
        fullUrl = baseUrl + (params.trim().length() == 0 ? "" : "?" + params);
        StringBuffer result = new StringBuffer(2000);
        try {
            destURL = method.equals(HTTP_METHOD_POST) ? new URL(baseUrl) : new URL(fullUrl);
            urlConn = (HttpURLConnection)destURL.openConnection();
            if (!sslVerify && (urlConn instanceof javax.net.ssl.HttpsURLConnection || urlConn instanceof HttpsURLConnection)) {
                javax.net.ssl.HttpsURLConnection httpsUrlCon;
                System.out.println(urlConn.getClass() + "-------");
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
                if (urlConn instanceof javax.net.ssl.HttpsURLConnection) {
                    httpsUrlCon = (javax.net.ssl.HttpsURLConnection)urlConn;
                    httpsUrlCon.setSSLSocketFactory(sc.getSocketFactory());
                    httpsUrlCon.setHostnameVerifier(new TrustAnyHostnameVerifier());
                }
                if (urlConn instanceof HttpsURLConnection) {
                    httpsUrlCon = (HttpsURLConnection)urlConn;
                    httpsUrlCon.setSSLSocketFactory(sc.getSocketFactory());
                    httpsUrlCon.setHostnameVerifier(new TrustAnyHostnameVerifierOld());
                }
            }
            logger.info((Object)("-->" + urlConn.getClass()));
            urlConn.setRequestProperty("Content-Type", requestProperty);
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod(method);
            urlConn.setConnectTimeout(120000);
            urlConn.setReadTimeout(120000);
            if (method.equals(HTTP_METHOD_POST)) {
                OutputStream os = urlConn.getOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter(os, charSet);
                osw.write(params);
                osw.flush();
                osw.close();
            }
            BufferedInputStream is = new BufferedInputStream(urlConn.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, charSet));
            String temp = null;
            while ((temp = br.readLine()) != null) {
                result.append(temp);
                result.append("\n");
                if (result.length() <= 500000) continue;
            }
            int responseCode = urlConn.getResponseCode();
            logger.info((Object)("------------------ResponseCode[" + responseCode + "],and targetUrl[" + targetUrl + "] queryString[" + queryString + "]" + "and resultLength[" + result.length() + "]"));
            if (responseCode != 200) {
                String string = null;
                return string;
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            logger.warn((Object)("connection error : " + e.getMessage()));
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    public static String parseQueryString(Map params, String charSet) {
        if (null == params || params.keySet().size() == 0) {
            return "";
        }
        StringBuffer queryString = new StringBuffer(2000);
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            String key = String.valueOf(i.next());
            Object obj = params.get(key);
            String value = "";
            if (obj != null) {
                value = obj.toString();
            }
            try {
                value = URLEncoder.encode(value, charSet);
            }
            catch (UnsupportedEncodingException ex) {
                logger.info((Object)("encode url error: " + ex.getMessage()));
            }
            queryString.append(key);
            queryString.append("=");
            queryString.append(value);
            queryString.append("&");
        }
        String result = queryString.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String parseUrl(String targetUrl, String queryString) {
        if (targetUrl == null || targetUrl.trim().length() == 0) {
            throw new IllegalArgumentException("invalid targetUrl : " + targetUrl);
        }
        if (!((targetUrl = targetUrl.trim()).startsWith("/") || targetUrl.toLowerCase().startsWith(HTTP_PREFIX) || targetUrl.toLowerCase().startsWith(HTTPS_PREFIX))) {
            targetUrl = HTTP_PREFIX + targetUrl;
        }
        if (queryString != null) {
            queryString = queryString.trim();
        }
        String baseUrl = "";
        String paramString = "";
        String fullUrl = "";
        int index = targetUrl.indexOf("?");
        if (index != -1) {
            baseUrl = targetUrl.substring(0, index);
            paramString = targetUrl.substring(index + 1);
        } else {
            baseUrl = targetUrl;
        }
        if (queryString != null && queryString.trim().length() != 0) {
            paramString = paramString.trim().length() > 0 ? paramString + "&" + queryString : paramString + queryString;
        }
        fullUrl = baseUrl + (paramString.trim().length() == 0 ? "" : "?" + paramString);
        return fullUrl;
    }

    public static String parseUrl(String targetUrl, Map params, String charSet) {
        String queryString = CallbackUtils.parseQueryString(params, charSet);
        return CallbackUtils.parseUrl(targetUrl, queryString);
    }

    public static Map parseQueryString(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString must be specified");
        }
        int index = queryString.indexOf("?");
        if (index > 0) {
            queryString = queryString.substring(index + 1);
        }
        String[] keyValuePairs = queryString.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keyValue : keyValuePairs) {
            if (keyValue.indexOf("=") == -1) continue;
            String[] args = keyValue.split("=");
            if (args.length == 2) {
                map.put(args[0], args[1]);
            }
            if (args.length != 1) continue;
            map.put(args[0], "");
        }
        return map;
    }

    public static String parseUrl(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString must be specified");
        }
        int index = queryString.indexOf("?");
        String targetUrl = null;
        targetUrl = index > 0 ? queryString.substring(0, index) : queryString;
        return targetUrl;
    }

    public static void main(String[] args) {
        System.out.println(CallbackUtils.httpGet("https://www.yeepay.com/", ""));
    }

    static {
        System.setProperty("sun.net.inetaddr.ttl", "3600");
        logger = LogFactory.getLog(CallbackUtils.class);
        IPREG = new String("^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$");
        DOMAINSUFFIX = new HashSet(){
            {
                this.add("me");
                this.add("tw");
                this.add("cat");
                this.add("jobs");
                this.add("tel");
                this.add("xxx");
                this.add("mail");
                this.add("kid");
                this.add("us");
                this.add("cc");
                this.add("hk");
                this.add("tv");
                this.add("com");
                this.add("edu");
                this.add("gov");
                this.add("net");
                this.add("org");
                this.add("bbr");
                this.add("cn");
                this.add("firm");
                this.add("store");
                this.add("web");
                this.add("arts");
                this.add("rec");
                this.add("info");
                this.add("nom");
                this.add("biz");
                this.add("name");
                this.add("pro");
                this.add("coop");
                this.add("aero");
                this.add("museum");
                this.add("mil");
                this.add("mobi");
                this.add("pro");
                this.add("travel");
                this.add("int");
                this.add("post");
                this.add("asia");
            }
        };
    }

    private static class TrustAnyHostnameVerifierOld
    implements HostnameVerifier {
        private TrustAnyHostnameVerifierOld() {
        }

        public boolean verify(String arg0, String arg1) {
            return true;
        }
    }

    private static class TrustAnyHostnameVerifier
    implements javax.net.ssl.HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

