package com.ptteng.uweiqian.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ptteng.uweiqian.common.util.YibaoUtil.ZGTUtils;
import com.ptteng.uweiqian.home.model.common.WithDrawal;
import com.ptteng.uweiqian.home.service.Pay.PayOrderService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liangxj on 2016/8/15.
 * 易宝支付及提现
 */
public class YibaoPayServiceImpl implements PayOrderService {

    private static final Log log = LogFactory.getLog(YibaoPayServiceImpl.class);
    private Map<String, String> yibaoConfig;


    public Map<String, String> getYibaoConfig() {
        return yibaoConfig;
    }

    public void setYibaoConfig(Map<String, String> yibaoConfig) {
        this.yibaoConfig = yibaoConfig;
    }

    @Override
    public String payTest(String code, String type) {
        return null;
    }

    @Override
    public String pay(String userid, String merchantOrderId, String merchantOrderTime, String merchantOrderName, String merchantOrderAmt, String merchantOrderDesc, String frontUrl, String backUrl, String spbill_create_ip, String type) {
        return null;
    }

    @Override
    public String pay(Long userId,String userName,String userMobile,String userCardNo,String userIdNo,String merchantOrderId, String merchantOrderTime,
                      String merchantOrderName, String merchantOrderAmt,
                      String merchantOrderDesc, String frontUrl, String backUrl,
                      String spbill_create_ip, String type) {


        Map<String, String> params	= new HashMap<String, String>();
        params.put("requestid", 	merchantOrderId);
        params.put("amount", 		merchantOrderAmt);//单位 元
        params.put("assure", 		"0");
        params.put("productname", 	"5818-彩票 充值");
        params.put("productcat", 	"");
        params.put("productdesc", 	"");
        params.put("divideinfo", 	"");
        params.put("callbackurl", 	backUrl);
        params.put("webcallbackurl", frontUrl);
        params.put("bankid",		"");
        params.put("period", 		"");
        params.put("memo", 			"");
        params.put("orderexpdate", 	"30");//有效期设为30分钟
        params.put("payproducttype", "ONEKEY");//一键支付
        params.put("userno", 		userId+"");
      //  params.put("isbind", 		isbind);
      //  params.put("bindid", 		bindid);
        params.put("ip", 			"");
        params.put("cardname", 		userName);
        params.put("idcard", 		userIdNo);
        params.put("bankcardnum", 	userCardNo);
        params.put("mobilephone", 	userMobile);
//        params.put("cvv2", 			cvv2);
//        params.put("expiredate", 	expiredate);
//        params.put("mcc", 			mcc);
//        params.put("areacode", 		areacode);
//        params.put("ledgerno", 		ledgerno);

        String apiName = ZGTUtils.PAYAPI_NAME;
        String[] requestHmacOrder = ZGTUtils.PAYAPI_REQUEST_HMAC_ORDER;
        String[] responseHmacOrder = ZGTUtils.PAYAPI_RESPONSE_HMAC_ORDER;

        ResponseResult result = invokeService(apiName, params, requestHmacOrder, responseHmacOrder);

        return result.toString();

    }

    @Override
    public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name, String acct_type, String trans_amt, String trans_usage, String type) {

        return null;
    }

    @Override
    public String withdrawalBatch(List<WithDrawal> withDrawalList, String batchNo, String totalNum, String totalAm, String isRepay,
                                  String type) {
        return null;
    }

    @Override
    public String notice(String xmlString, String type) {
        //第四步 解密同步响应密文data，获取明文参数
        String data = xmlString;
        String keyForHmac 		= yibaoConfig.get("key");
        Map<String, String> responseDataMap = ZGTUtils.decryptData(data,keyForHmac);

        log.debug("易宝的同步响应：" + data);
        log.debug("data解密后明文：" + responseDataMap);

        //第五步 code=1时，方表示接口处理成功
        if (!"1".equals(responseDataMap.get("code"))) {
            log.debug("code = " + responseDataMap.get("code"));
            log.debug("msg  = " + responseDataMap.get("msg"));
            return ResponseResult.fail(responseDataMap).toString();
        }

        return ResponseResult.success(responseDataMap).toString();
    }

    @Override
    public boolean ylnotice(Map<String, String> reqData, String encoding, String type) {
        return false;
    }

    @Override
    public String check(String merchantOrderId, String merchantOrderTime, String type) {
        return null;
    }

    @Override
    public String checkPayment(String merchantOrderId, String merchantOrderTime, String type) {
        return null;
    }

    @Override
    public String getParam(String key, String type) {
        return null;
    }

    @Override
    public String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn, String type) {
        return null;
    }

    @Override
    public String epAuthCheckSms(String trac_no, String sms_code, String type) {
        return null;
    }

    @Override
    public String epAuthQuery(String trac_no, String type) {
        return null;
    }

    /**
     * 子账户注册接口
     * @param requestid 注册请求号 MAX(50) 必填 商户传入，不能重复
     * @param bindmobile 绑定手机 MAX(11) 必填 11位的手机号
     * @param customertype 注册类型 MAX(10) 必填 PERSON：个人 ENTERPRISE：企业
     * @param signedname 签约名 MAX(30) 必填 个人时，填写姓名；企业时，填写企业名称。
     * @param linkman 联系人 MAX(20) 必填 联系人姓名
     * @param idcard 身份证 MAX(18) 必填 customertype 为 PERSON 时，必填
     * @param businesslicence 营业执照号 MAX(30) 非必填 customertype 为 ENTERPRISE时，必填
     * @param legalperson 法人姓名 MAX(42) 非必填 当注册类型 customertype=ENTERPRISE 时，该参数必填
     * @param minsettleamount 起结金额 MAX(20) 必填 >= 0.01 的数字，单位：元
     * @param riskreserveday 结算周期 MAX(4) 必填 单位：天
     * @param bankaccountnumber 银行卡号 MAX(30) 必填 出款用的银行卡【必须为储蓄卡】
     * @param bankname 开户行 MAX(50) 必填  bankaccountnumber 银行卡所在开户行，填写中文。
     * @param accountname 开户名 MAX(30) 必填 银行卡 bankaccountnumber 对应的开户名。
     * @param bankaccounttype 银行卡类别 MAX(11) 必填 PrivateCash：对私 PublicCash： 对公
     * @param bankprovince 开户省 MAX(10) 必填 填写中文。
     * @param bankcity 开户市 MAX(20) 必填 填写中文。
     * @param deposit 保证金 MAX(10) 非必填 【不参与 hmac 验签】单位：元；不传时，默认为 0。
     * @param email 邮箱 MAX(30) 非必填
     * @return JSON 字符串 其中 ledgerno 为 子账户商户编号
     * 成功: {"data":{"code":"1","customernumber":"...","requestid":"","ledgerno":""},"status":"SUCCESS"}
     * 失败: {"data":{"code":"900003","msg":"相同资质注册超限"},"status":"FAIL"}
     * 错误: {"message":"...","status":"ERROR"}
     */
    @Override
    public String register(String requestid, String bindmobile, String customertype, String signedname, String linkman, //
                           String idcard, String businesslicence, String legalperson, String minsettleamount, //
                           String riskreserveday, String bankaccountnumber, String bankname, String accountname,//
                           String bankaccounttype, String bankprovince, String bankcity, String deposit, String email,String type) {

        Map<String, String> params	= new HashMap<String, String>();
        params.put("requestid", 		requestid);
        params.put("bindmobile", 		bindmobile);
        params.put("customertype", 		customertype);
        params.put("signedname", 		signedname);
        params.put("linkman", 			linkman);
        params.put("idcard", 			idcard);
        params.put("businesslicence", 	businesslicence);
        params.put("legalperson", 		legalperson);
        params.put("minsettleamount", 	minsettleamount);
        params.put("riskreserveday", 	riskreserveday);
        params.put("bankaccountnumber", bankaccountnumber);
        params.put("bankname", 			bankname);
        params.put("accountname", 		accountname);
        params.put("bankaccounttype", 	bankaccounttype);
        params.put("bankprovince", 		bankprovince);
        params.put("bankcity", 			bankcity);
        params.put("deposit", 			deposit);
        params.put("email", 			email);

        String apiName = ZGTUtils.REGISTERAPI_NAME;
        String[] requestHmacOrder = ZGTUtils.REGISTERAPI_REQUEST_HMAC_ORDER;
        String[] responseHmacOrder = ZGTUtils.REGISTERAPI_RESPONSE_HMAC_ORDER;

        ResponseResult result = invokeService(apiName, params, requestHmacOrder, responseHmacOrder);

        return result.toString();

    }

    /**
     * 转账接口
     * @param requestid 转账请求号 MAX(50) 必填 必须在该商编下唯一，由商户输入
     * @param ledgerno 子账户商户编号 MAX(11) 必填 被转账的子账户的商户编号
     * @param amount 转账金额 MAX(10) 必填 转账金额，单位：元
     * @return JSON 字符串
     * 成功: {"data":{"code":"1","customernumber":"...","requestid":""},"status":"SUCCESS"}
     * 失败: {"data":{"code":"175004","msg":"分账方冻结 [10013810401]"},"status":"FAIL"}
     * 错误: {"message":"...","status":"ERROR"}
     */
    @Override
    public String tarnsfer(String requestid, String ledgerno, String amount,String type) {

        Map<String, String> params	= new HashMap<String, String>();
        params.put("requestid", requestid);
        params.put("ledgerno",	ledgerno);
        params.put("amount",	amount);

        String apiName = ZGTUtils.TRANSFERAPI_NAME;
        String[] requestHmacOrder = ZGTUtils.TRANSFERAPI_REQUEST_HMAC_ORDER;
        String[] responseHmacOrder = ZGTUtils.TRANSFERAPI_RESPONSE_HMAC_ORDER;

        ResponseResult result = invokeService(apiName, params, requestHmacOrder, responseHmacOrder);
        return result.toString();
    }

    /**
     * 转账查询接口
     * @param requestid 转账请求号 MAX(50) 必填 待查询的转账请求号
     * @return JSON 字符串 其中 ledgerno 子账户商户编号, amount 转账金额, status 转账状态 {FAIL：转账失败, COMPLETE：转账成功}
     * 成功: {"data":{"code":"1","customernumber":"...","requestid":"","ledgerno":"","amount"："",},"status":"SUCCESS"}
     * 失败: {"data":{"code":"110001","msg":"not found record"},"status":"FAIL"}
     * 错误: {"message":"...","status":"ERROR"}
     */
    @Override
    public String transferQuery(String requestid,String type){

        Map<String, String> params	= new HashMap<String, String>();
        params.put("requestid", 		requestid);

        String apiName = ZGTUtils.TRANSFERQUERYAPI_NAME;
        String[] requestHmacOrder = ZGTUtils.TRANSFERQUERYAPI_REQUEST_HMAC_ORDER;
        String[] responseHmacOrder = ZGTUtils.TRANSFERQUERYAPI_RESPONSE_HMAC_ORDER;

        ResponseResult result = invokeService(apiName, params, requestHmacOrder, responseHmacOrder);

        return result.toString();
    }

    /**
     * 调用易宝的接口服务
     * @param apiName 服务名称
     * @param params 参数
     * @param requestHmacOrder hmac 加密的字段
     * @param responseHmacOrder hmac 解密的字段
     * @return
     */
    private ResponseResult invokeService(String apiName, Map<String, String> params, //
                                                String[] requestHmacOrder, String[] responseHmacOrder) {

        //从配置文件中获取商户编号
		String customernumber 	= yibaoConfig.get("customernumber");
        //从配置文件中获取商户密钥
		String keyForHmac 		= yibaoConfig.get("key");
        //aes密钥，为商户密钥的前16位
		String keyForAes		= keyForHmac.substring(0, 16);

        params.put("customernumber",    customernumber);

        //第一步 生成密文data
        String data = ZGTUtils.buildData(params, requestHmacOrder, keyForHmac);

        //第二步 发起请求
        String requestUrl = ZGTUtils.getRequestUrl(apiName);
        log.info(" requestUrl = "+requestUrl);
        Map<String, String> responseMap = ZGTUtils.httpPost(requestUrl, customernumber, data);

        //第三步 判断请求是否成功，
        if (responseMap.containsKey("code")) {
            log.debug(responseMap);
            return ResponseResult.fail(responseMap);
        }

        //第四步 解密同步响应密文data，获取明文参数
        String responseData = responseMap.get("data");
        Map<String, String> responseDataMap = ZGTUtils.decryptData(responseData, keyForAes);

        log.debug("易宝的同步响应：" + responseMap);
        log.debug("data解密后明文：" + responseDataMap);

        //第五步 code=1时，方表示接口处理成功
        if (!"1".equals(responseDataMap.get("code"))) {
            log.debug("code = " + responseDataMap.get("code"));
            log.debug("msg  = " + responseDataMap.get("msg"));
            return ResponseResult.fail(responseDataMap);
        }

        //第六步 hmac签名验证
        if (!ZGTUtils.checkHmac(responseDataMap, responseHmacOrder, keyForHmac)) {
            log.debug("hmac check error!");
            return ResponseResult.error("参数校验失败, hmac 签名验证不成功");
        }

        return ResponseResult.success(responseDataMap);
    }


    public static class ResponseResult {
        private String status;
        private String message;
        private Map<String, String> data;

        public static ResponseResult error(String message) {
            return new ResponseResult("ERROR", message);
        }

        public static ResponseResult success(Map<String, String> data) {
            return new ResponseResult("SUCCESS", data);
        }

        public static ResponseResult fail(Map<String, String> data) {
            return new ResponseResult("FAIL", data);
        }

        protected ResponseResult(String status, String message) {
            this.status = status;
            this.message = message;
        }

        protected ResponseResult(String status, Map<String, String> data) {
            this.data = data;
            this.status = status;
        }

        public String getStatus() {
            return status;
        }

        public String getMessage() {
            return message;
        }

        public Map<String, String> getData() {
            return data;
        }

        public String toString() {
            return JSONObject.toJSON(this).toString();
        }
    }
}
