/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.uweiqian.common.util.YibaoUtil;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ptteng.uweiqian.common.util.YibaoUtil.AESUtil;
import com.ptteng.uweiqian.common.util.YibaoUtil.Configuration;
import com.ptteng.uweiqian.common.util.YibaoUtil.Digest;
import com.ptteng.uweiqian.common.util.YibaoUtil.HttpClient4Utils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class ZGTUtils {
    public static final String CONFIG_FILE_PATH = "yibao/merchantInfo";
    public static final String CHARSET = "UTF-8";
    public static final String PAYAPI_NAME = "PayApi";
    public static final String QUERYORDERAPI_NAME = "QueryOrderApi";
    public static final String REFUNDAPI_NAME = "RefundApi";
    public static final String QUERYREFUNDAPI_NAME = "QueryRefundApi";
    public static final String SETTLECONFIRMAPI_NAME = "SettleConfirmApi";
    public static final String QUERYBINDCARDSAPI_NAME = "QueryBindCardsApi";
    public static final String UNBINDCARDAPI_NAME = "UnbindCardApi";
    public static final String REGISTERAPI_NAME = "RegisterApi";
    public static final String UPLOADAPI_NAME = "uploadApi";
    public static final String MODIFYREQUESTAPI_NAME = "ModifyRequestApi";
    public static final String QUERYMODIFYREQUESTAPI_NAME = "QueryModifyRequestApi";
    public static final String TRANSFERAPI_NAME = "TransferApi";
    public static final String TRANSFERQUERYAPI_NAME = "TransferQueryApi";
    public static final String DIVIDEAPI_NAME = "DivideApi";
    public static final String QUERYDIVIDEAPI_NAME = "QueryDivideApi";
    public static final String QUERYBALANCEAPI_NAME = "QueryBalanceApi";
    public static final String QUERYSETTLEMENTAPI_NAME = "QuerySettlementApi";
    public static final String[] PAYAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid", "amount", "assure", "productname", "productcat", "productdesc", "divideinfo", "callbackurl", "webcallbackurl", "bankid", "period", "memo"};
    public static final String[] PAYAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "externalid", "amount", "payurl"};
    public static final String[] QUERYORDERAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid"};
    public static final String[] QUERYORDERAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "externalid", "amount", "productname", "productcat", "productdesc", "status", "ordertype", "busitype", "orderdate", "createdate", "bankid"};
    public static final String[] REFUNDAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid", "orderrequestid", "amount", "divideinfo", "confirm", "memo"};
    public static final String[] REFUNDAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "refundexternalid"};
    public static final String[] QUERYREFUNDAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "orderrequestid", "refundrequestid"};
    public static final String[] QUERYREFUNDAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "orderrequestid", "code", "externalid", "refundinfo"};
    public static final String[] SETTLECONFIRMAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "orderrequestid"};
    public static final String[] SETTLECONFIRMAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "orderrequestid", "code"};
    public static final String[] QUERYBINDCARDSAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "userno"};
    public static final String[] QUERYBINDCARDSAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "userno", "code"};
    public static final String[] UNBINDCARDAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "userno", "bindid"};
    public static final String[] UNBINDCARDAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "userno", "bindid", "code"};
    public static final String[] REGISTERAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid", "bindmobile", "customertype", "signedname", "linkman", "idcard", "businesslicence", "legalperson", "minsettleamount", "riskreserveday", "bankaccountnumber", "bankname", "accountname", "bankaccounttype", "bankprovince", "bankcity"};
    public static final String[] REGISTERAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "ledgerno"};
    public static final String[] MODIFYREQUESTAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid", "ledgerno", "bankaccountnumber", "bankname", "accountname", "bankaccounttype", "bankprovince", "bankcity", "minsettleamount", "riskreserveday", "manualsettle", "callbackurl"};
    public static final String[] MODIFYREQUESTAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code"};
    public static final String[] QUERYMODIFYREQUESTAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid"};
    public static final String[] QUERYMODIFYREQUESTAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "status", "desc"};
    public static final String[] TRANSFERAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid", "ledgerno", "amount"};
    public static final String[] TRANSFERAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code"};
    public static final String[] TRANSFERQUERYAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid"};
    public static final String[] TRANSFERQUERYAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "ledgerno", "amount", "status"};
    public static final String[] DIVIDEAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "requestid", "orderrequestid", "divideinfo"};
    public static final String[] DIVIDEAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "requestid", "code"};
    public static final String[] QUERYDIVIDEAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "orderrequestid", "dividerequestid", "ledgerno"};
    public static final String[] QUERYDIVIDEAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "orderrequestid", "code", "divideinfo"};
    public static final String[] QUERYBALANCEAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "ledgerno"};
    public static final String[] QUERYBALANCEAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "code", "balance", "ledgerbalance"};
    public static final String[] QUERYSETTLEMENTAPI_REQUEST_HMAC_ORDER = new String[]{"customernumber", "ledgerno", "date"};
    public static final String[] QUERYSETTLEMENTAPI_RESPONSE_HMAC_ORDER = new String[]{"customernumber", "code", "info"};
    public static final String[] MODIFYREQUESTAPICALLBACK_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "status", "desc"};
    public static final String[] PAYAPICALLBACK_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "notifytype", "externalid", "amount", "cardno"};
    public static final String[] DIVIDEAPICALLBACK_HMAC_ORDER = new String[]{"customernumber", "requestid", "code", "orderrequestid"};
    private static Configuration merchantInfo = null;

    public static String buildHmac(String str, String keyForHmac) {
        return Digest.hmacSign(str, keyForHmac);
    }

    public static String buildHmac(String[] strArray, String keyForHmac) {
        StringBuffer stringValue = new StringBuffer();
        for (int i = 0; i < strArray.length; ++i) {
            stringValue.append(ZGTUtils.formatStr(strArray[i]));
        }
        return ZGTUtils.buildHmac(stringValue.toString(), keyForHmac);
    }

    public static String buildData(Map<String, String> params, String keyForAes) {
        String jsonStr = JSON.toJSONString(params);
        return AESUtil.encrypt(jsonStr, keyForAes);
    }

    public static String buildData(Map<String, String> params, String[] requestHmacOrder, String keyForHmac) {
        for (String key : params.keySet()) {
            params.put(key, ZGTUtils.formatStr(params.get(key)));
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < requestHmacOrder.length; ++i) {
            buffer.append(params.get(requestHmacOrder[i]));
        }
        String hmac = ZGTUtils.buildHmac(buffer.toString(), keyForHmac);
        params.put("hmac", hmac);
        String keyForAes = keyForHmac.substring(0, 16);
        return ZGTUtils.buildData(params, keyForAes);
    }

    public static Map<String, String> httpPost(String url, String customernumber, String data) {
        Map result = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("customernumber", customernumber);
        paramMap.put("data", data);
        System.out.println("paramMap===" + paramMap);
        String responseBody = HttpClient4Utils.sendHttpRequest(url, paramMap, CHARSET, true);
        result = (Map)JSON.parseObject((String)responseBody, (TypeReference)new TypeReference<TreeMap<String, String>>(){}, (Feature[])new Feature[0]);
        return result;
    }

    public static Map<String, String> decryptData(String data, String key) {
        Map result = null;
        String decryptData = AESUtil.decrypt(data, key);
        result = (Map)JSON.parseObject((String)decryptData, (TypeReference)new TypeReference<TreeMap<String, String>>(){}, (Feature[])new Feature[0]);
        return result;
    }

    public static boolean checkHmac(Map<String, String> responseMap, String[] responseHmacOrder, String keyForHmac) {
        if (responseMap == null || keyForHmac == null || responseHmacOrder == null) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < responseHmacOrder.length; ++i) {
            buffer.append(ZGTUtils.formatStr(responseMap.get(responseHmacOrder[i])));
        }
        String hmacYeepay = responseMap.get("hmac");
        String hmacLocal = ZGTUtils.buildHmac(buffer.toString(), keyForHmac);
        return hmacLocal.equals(hmacYeepay);
    }

    public static String getRequestUrl(String apiName) {
        return merchantInfo.getValue(apiName);
    }

    public static Configuration getMerchantInfo() {
        return merchantInfo;
    }

    public static String formatStr(String text) {
        return text == null ? "" : text;
    }

    public static String mapToQueryString(Map<String, Object> parameters, String charSet) {
        String queryString = "";
        if (parameters != null && !parameters.isEmpty()) {
            for (String key : parameters.keySet()) {
                try {
                    Object value = parameters.get(key);
                    if (!(value instanceof String)) continue;
                    queryString = queryString + key + "=" + URLEncoder.encode(value == null ? "" : value.toString(), charSet) + "&";
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("invalid charset : " + charSet);
                }
            }
            if (queryString.length() > 0) {
                queryString = queryString.substring(0, queryString.length() - 1);
            }
        }
        return queryString;
    }

    public String uploadFile(Map<String, Object> params, String baseUrl) {
        if (!params.containsKey("file")) {
            throw new IllegalArgumentException("\u8bf7\u4e0a\u4f20\u56fe\u7247");
        }
        File file = (File)params.get("file");
        if (!file.exists()) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u56fe\u7247\u4e0d\u5b58\u5728");
        }
        if (baseUrl == null || baseUrl.trim().length() == 0) {
            throw new IllegalArgumentException("invalid url : " + baseUrl);
        }
        String queryString = ZGTUtils.mapToQueryString(params, "utf-8");
        int index = baseUrl.indexOf("?");
        baseUrl = index > 0 ? baseUrl + "&" + queryString : baseUrl + "?" + queryString;
        PostMethod postMethod = new PostMethod(baseUrl);
        try {
            FilePart fp = new FilePart("file", file);
            Part[] parts = new Part[]{fp};
            MultipartRequestEntity mre = new MultipartRequestEntity(parts, postMethod.getParams());
            postMethod.setRequestEntity((RequestEntity)mre);
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(50000);
            int status = client.executeMethod((HttpMethod)postMethod);
            if (status == 200) {
                String string = postMethod.getResponseBodyAsString();
                return string;
            }
            try {
                throw new RuntimeException("\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38");
            }
            catch (Exception e) {
                throw new RuntimeException("\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38");
            }
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    static {
        merchantInfo = Configuration.getInstance(CONFIG_FILE_PATH);
    }
}

