/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.uweiqian.common.util.YibaoUtil;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClient4Utils {
    public static final int DEFAULT_TIME_OUT = 60000;

    public static String sendHttpRequest(String url, Map<String, String> paramMap, String charset, boolean isPost) {
        return HttpClient4Utils.sendHttpRequest(url, paramMap, charset, isPost, 60000);
    }

    public static String sendHttpRequest(String url, Map<String, String> paramMap, String charset, boolean isPost, int timeout) {
        if (isPost) {
            return HttpClient4Utils.httpPost(url, paramMap, charset, timeout);
        }
        return HttpClient4Utils.httpGet(url, paramMap, charset, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, Map<String, String> params, String charset, int timeout) {
        if (url == null || url.equals("")) {
            return null;
        }
        String result = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            pairs.add(new BasicNameValuePair(key, HttpClient4Utils.formatStr(value)));
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = null;
        String responseBody = null;
        CloseableHttpResponse response = null;
        try {
            httpPost = new HttpPost(url);
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs));
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            result = responseBody = EntityUtils.toString((HttpEntity)entity, (String)charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Map<String, String> params, String charset, int timeout) {
        if (url == null || url.equals("")) {
            return null;
        }
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = null;
        String responseBody = null;
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    pairs.add(new BasicNameValuePair(key, HttpClient4Utils.formatStr(value)));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            if ((statusCode = (response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(url)))).getStatusLine().getStatusCode()) != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            result = responseBody = EntityUtils.toString((HttpEntity)entity, (String)charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String formatStr(String text) {
        return text == null ? "" : text.trim();
    }
}

