/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.uweiqian.common.util.YibaoUtil;

import com.ptteng.uweiqian.common.util.YibaoUtil.ZGTUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class DownloadOrderDocumentUtils {
    public static final String CHARSET = "UTF-8";
    public static final int TIMEOUT = 3600000;
    public static final String DOWNLOADORDERDOCUMENTAPI_NAME = "DownloadOrderDocumentApi";
    public static final String[] REQUEST_HMAC_ORDER = new String[]{"operator_no", "checkDate", "orderType"};
    private static String operator_no = "";
    private static String requestUrl = "";

    public static String buildCertify_token(Map<String, String> params, String keyForHmac) {
        for (String key : params.keySet()) {
            params.put(key, DownloadOrderDocumentUtils.formatStr(params.get(key)));
        }
        params.put("operator_no", operator_no);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < REQUEST_HMAC_ORDER.length; ++i) {
            buffer.append(params.get(REQUEST_HMAC_ORDER[i]));
        }
        String hmac = ZGTUtils.buildHmac(buffer.toString(), keyForHmac);
        params.put("hmac", hmac);
        return ZGTUtils.buildData(params, keyForHmac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream httpPost(String authorize_no, String certify_token) {
        InputStream result = null;
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("authorize_no", authorize_no));
        pairs.add(new BasicNameValuePair("certify_token", certify_token));
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3600000).setSocketTimeout(3600000).build();
        try {
            httpPost = new HttpPost(requestUrl);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs));
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            result = entity.getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String getPathOfDownloadOrderDocument(Map<String, String> params, String path, String keyForHmac) {
        String time = String.valueOf(System.currentTimeMillis());
        String fileName = "ZGTOrderDocument_" + time + "." + params.get("fileType");
        String filePath = path + File.separator + fileName;
        String authorize_no = operator_no;
        String certify_token = DownloadOrderDocumentUtils.buildCertify_token(params, keyForHmac);
        InputStream responseStream = DownloadOrderDocumentUtils.httpPost(authorize_no, certify_token);
        try {
            int i;
            File file = new File(filePath);
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream orderFile = new FileOutputStream(filePath);
            BufferedInputStream bis = new BufferedInputStream(responseStream);
            byte[] by = new byte[1024];
            while ((i = bis.read(by)) != -1) {
                orderFile.write(by, 0, i);
            }
            orderFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return filePath;
    }

    public static String getRequestUrl(String apiName) {
        return requestUrl;
    }

    public static String getOperator_no() {
        return operator_no;
    }

    public static String formatStr(String text) {
        return text == null ? "" : text;
    }

    static {
        requestUrl = ZGTUtils.getMerchantInfo().getValue(DOWNLOADORDERDOCUMENTAPI_NAME);
    }
}

