package com.ptteng.uweiqian.common.service.impl;

import com.ptteng.uweiqian.home.model.common.WithDrawal;
import com.ptteng.uweiqian.home.service.Pay.PayOrderService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

public class PayInterfaceImpl implements PayOrderService{
	private static final Log log = LogFactory.getLog(PayInterfaceImpl.class);
	
	@Resource(name = "processServiceConfig")
	private Map<String, PayOrderService> processServiceConfig;



	@Override
	public String pay(String userid, String merchantOrderId,
			String merchantOrderTime, String merchantOrderName,
			String merchantOrderAmt, String merchantOrderDesc, String frontUrl,
			String backUrl,String spbill_create_ip,String type)  {
		
		try {
			log.info(" type = "+type+" ip = "+spbill_create_ip+" backuRL = "+backUrl);
			PayOrderService  payOrderService = processServiceConfig.get(type);
			log.info(" payOrderService = "+payOrderService);
			return payOrderService.pay(userid, merchantOrderId, merchantOrderTime, merchantOrderName, merchantOrderAmt, merchantOrderDesc, frontUrl, backUrl, spbill_create_ip,type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}



	@Override
	public String pay(Long userId,String userName,String userMobile,String userCardNo
			,String userIdNo, String merchantOrderId, String merchantOrderTime, String merchantOrderName, String merchantOrderAmt, String merchantOrderDesc, String frontUrl, String backUrl, String spbill_create_ip, String type) {
		try {
			log.info(" type = "+type+" ip = "+spbill_create_ip+" backuRL = "+backUrl);
			PayOrderService  payOrderService = processServiceConfig.get(type);
			log.info(" payOrderService = "+payOrderService);
			return payOrderService.pay(userId, userName, userMobile, userCardNo, userIdNo, merchantOrderId, merchantOrderTime, merchantOrderName, merchantOrderAmt, merchantOrderDesc, frontUrl, backUrl, spbill_create_ip,type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}

	@Override
	public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name, String acct_type, String trans_amt,
						String trans_usage, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.pyPay(order_no, to_bank_no, to_acct_no, to_acct_name, acct_type, trans_amt, trans_usage, type);

	}

	@Override
	public String withdrawalBatch(List<WithDrawal> withDrawalList, String batchNo, String totalNum, String totalAm, String isRepay, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.withdrawalBatch(withDrawalList,batchNo,totalNum,totalAm,isRepay,type);
	}

	@Override
	public String payTest(String code,String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);

		return payOrderService.payTest(code, type);
	}
	@Override
	public String notice(String xmlString,String type) {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.notice(xmlString, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}

	@Override
	public boolean ylnotice(Map<String, String> reqData, String encoding,String type)  {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.ylnotice(reqData, encoding, type);
	}

	@Override
	public String check(String merchantOrderId, String merchantOrderTime,String type)
			 {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.check(merchantOrderId,merchantOrderTime, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
		
	}

	@Override
	public String checkPayment(String merchantOrderId, String merchantOrderTime, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.checkPayment(merchantOrderId, merchantOrderTime, type);
	}

	@Override
	public String getParam(String key,String type)  {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.getParam(key, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}

	@Override
	public String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn,String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.epAuthSyncWithSms(trac_no,acct_type,bank_no,card_no,user_name,cert_no,card_phone,expireDate,cvn
		,type);
	}

	@Override
	public String epAuthCheckSms(String trac_no, String sms_code,String type) {

		PayOrderService  payOrderService = processServiceConfig.get(type);

		return payOrderService.epAuthCheckSms(trac_no,sms_code,type);
	}

	@Override
	public String epAuthQuery(String trac_no, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.epAuthQuery(trac_no,type);
	}

	@Override
	public String tarnsfer(String requestid, String ledgerno, String amount,String type)
	{
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.tarnsfer(requestid, ledgerno, amount, type);

	}

	@Override
	public String register(String requestid, String bindmobile, String customertype, String signedname, String linkman, String idcard, String businesslicence, String legalperson, String minsettleamount, String riskreserveday, String bankaccountnumber, String bankname, String accountname, String bankaccounttype, String bankprovince, String bankcity, String deposit, String email,String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.register(requestid,bindmobile,customertype,signedname,linkman,idcard,businesslicence,legalperson,minsettleamount,
				riskreserveday,bankaccountnumber,bankname,accountname,bankaccounttype,bankprovince,bankcity,deposit,email,type);
	}

	@Override
	public String transferQuery(String requestid,String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.transferQuery(requestid, type);

	}


}
