package com.ptteng.uweiqian.home.service.Pay;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.uweiqian.home.model.common.WithDrawal;

import org.dom4j.DocumentException;
import org.osoa.sca.annotations.Remotable;

import java.util.List;
import java.util.Map;

/**支付订单接口
 * @author 
 *
 */

public interface PayOrderService {

	public String payTest(String code, String type);


	/**
	 * 支付
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String pay(String userid, String merchantOrderId, String merchantOrderTime, String merchantOrderName,
					  String merchantOrderAmt, String merchantOrderDesc, String frontUrl, String backUrl, String spbill_create_ip, String type);

	public String pay(Long userId,String userName,String userMobile,String userCardNo
			,String userIdNo, String merchantOrderId, String merchantOrderTime, String merchantOrderName,
					  String merchantOrderAmt, String merchantOrderDesc, String frontUrl, String backUrl, String spbill_create_ip, String type);

	/**
	 * 提现/转账
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name,
						String acct_type, String trans_amt, String trans_usage, String type);

	/**
	 * 批量提现
	 * @param withDrawalList 提现订单集合
	 * @param batchNo 批次号
	 * @param totalNum 打款总笔数
	 * @param totalAm 打款总金额
	 * @param isRepay 是否需要判断重复打款 0-不需要判断 1-需要判断
	 * @param type
	 * @return
	 */
	public String withdrawalBatch(List<WithDrawal> withDrawalList,String batchNo, String totalNum, String totalAm, String isRepay,
						String type) ;


	/**
	 * 解析通知报文
	 *
	 * @param xmlString
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String notice(String xmlString, String type);


	/**
	 * 通知接口
	 *
	 * @param reqData  银联请求参数
	 * @param encoding 编码格式
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public boolean ylnotice(Map<String, String> reqData, String encoding, String type);

	/**
	 * 支付状态查询
	 *
	 * @param merchantOrderId
	 * @param merchantOrderTime
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	String check(String merchantOrderId, String merchantOrderTime, String type);

	/**
	 * 提现/转账状态查询
	 *
	 * @param merchantOrderId
	 * @param merchantOrderTime
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	String checkPayment(String merchantOrderId, String merchantOrderTime, String type);


	public String getParam(String key, String type);

	/**
	 * 快捷支付认证接口（同步接口，需短信确认）
	 *
	 * @param trac_no    商户跟踪号
	 * @param acct_type  卡类型：0-储蓄卡,1-信用卡
	 * @param bank_no    人行联网行号
	 * @param card_no    账号
	 * @param user_name  姓名
	 * @param cert_no    证件号码
	 * @param card_phone 联系电话
	 * @param expireDate 信用卡有效期（仅信用卡时必输，格式MMYY）
	 * @param cvn        信用卡CVN（仅信用卡时必输）
	 * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
	 */
	public String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn, String type);

	/**
	 * 快捷认证短信验证码确认接口
	 *
	 * @param trac_no  发起同步认证时的商户跟踪号
	 * @param sms_code 6位数字短信验证码
	 * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
	 */
	public String epAuthCheckSms(String trac_no, String sms_code, String type);
	/**
	 * 快捷支付账户认证结果查询接口
	 *
	 * @param trac_no 商户跟踪号
	 * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
	 */
	public  String epAuthQuery(String trac_no, String type) ;

	/**
	 * 子账户注册接口
	 * @param requestid 注册请求号 MAX(50) 必填 商户传入，不能重复
	 * @param bindmobile 绑定手机 MAX(11) 必填 11位的手机号
	 * @param customertype 注册类型 MAX(10) 必填 PERSON：个人 ENTERPRISE：企业
	 * @param signedname 签约名 MAX(30) 必填 个人时，填写姓名；企业时，填写企业名称。
	 * @param linkman 联系人 MAX(20) 必填 联系人姓名
	 * @param idcard 身份证 MAX(18) 必填 customertype 为 PERSON 时，必填
	 * @param businesslicence 营业执照号 MAX(30) 非必填 customertype 为 ENTERPRISE时，必填
	 * @param legalperson 法人姓名 MAX(42) 非必填 当注册类型 customertype=ENTERPRISE 时，该参数必填
	 * @param minsettleamount 起结金额 MAX(20) 必填 >= 0.01 的数字，单位：元
	 * @param riskreserveday 结算周期 MAX(4) 必填 单位：天
	 * @param bankaccountnumber 银行卡号 MAX(30) 必填 出款用的银行卡【必须为储蓄卡】
	 * @param bankname 开户行 MAX(50) 必填  bankaccountnumber 银行卡所在开户行，填写中文。
	 * @param accountname 开户名 MAX(30) 必填 银行卡 bankaccountnumber 对应的开户名。
	 * @param bankaccounttype 银行卡类别 MAX(11) 必填 PrivateCash：对私 PublicCash： 对公
	 * @param bankprovince 开户省 MAX(10) 必填 填写中文。
	 * @param bankcity 开户市 MAX(20) 必填 填写中文。
	 * @param deposit 保证金 MAX(10) 非必填 【不参与 hmac 验签】单位：元；不传时，默认为 0。
	 * @param email 邮箱 MAX(30) 非必填
	 * @return JSON 字符串 其中 ledgerno 为 子账户商户编号
	 * 成功: {"data":{"code":"1","customernumber":"...","requestid":"","ledgerno":""},"status":"SUCCESS"}
	 * 失败: {"data":{"code":"900003","msg":"相同资质注册超限"},"status":"FAIL"}
	 * 错误: {"message":"...","status":"ERROR"}
	 */
	public String register(String requestid, String bindmobile, String customertype, String signedname, String linkman, //
						   String idcard, String businesslicence, String legalperson, String minsettleamount, //
						   String riskreserveday, String bankaccountnumber, String bankname, String accountname,//
						   String bankaccounttype, String bankprovince, String bankcity, String deposit, String email,String type);
	/**
	 * 转账接口
	 * @param requestid 转账请求号 MAX(50) 必填 必须在该商编下唯一，由商户输入
	 * @param ledgerno 子账户商户编号 MAX(11) 必填 被转账的子账户的商户编号
	 * @param amount 转账金额 MAX(10) 必填 转账金额，单位：元
	 * @return JSON 字符串
	 * 成功: {"data":{"code":"1","customernumber":"...","requestid":""},"status":"SUCCESS"}
	 * 失败: {"data":{"code":"175004","msg":"分账方冻结 [10013810401]"},"status":"FAIL"}
	 * 错误: {"message":"...","status":"ERROR"}
	 */
	public String tarnsfer(String requestid, String ledgerno, String amount,String type);

	/**
	 * 转账查询接口
	 * @param requestid 转账请求号 MAX(50) 必填 待查询的转账请求号
	 * @return JSON 字符串 其中 ledgerno 子账户商户编号, amount 转账金额, status 转账状态 {FAIL：转账失败, COMPLETE：转账成功}
	 * 成功: {"data":{"code":"1","customernumber":"...","requestid":"","ledgerno":"","amount"："",},"status":"SUCCESS"}
	 * 失败: {"data":{"code":"110001","msg":"not found record"},"status":"FAIL"}
	 * 错误: {"message":"...","status":"ERROR"}
	 */
	public String transferQuery(String requestid,String type);
}