package com.ptteng.common.uweiqian.controller;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.util.DynamicUtil;
import com.ptteng.uweiqian.organization.model.User;
import com.ptteng.uweiqian.organization.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Role crud
 *
 * @author magenm 2014-4-16 13:43
 *
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);
	@Autowired
	private UserService userService;

	/**
	 * 
	 * 用户列表接口 /a/u/users get
	 */
	@RequestMapping(value = "/a/u/user/search", method = RequestMethod.GET)
	public String getUsersJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, String name, String cardNum, String email, String mobile, String startTime,
			String endTime) throws Exception {
		log.info("name:" + name);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}

		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			List<Long> ids = null;
			Boolean next = false;
			// size += 1;
			Map<String, Object> map = new HashMap<String, Object>();
			Map<String, Object> mapTotal =DynamicUtil.getUserListParam(name, cardNum, email, mobile, startTime, endTime,true);
			log.info(" get userApply total size param = "+mapTotal);
			BigInteger total =(BigInteger)  userService.getObjectByDynamicCondition(User.class, mapTotal, 0, Integer.MAX_VALUE);
			log.info(" get userApply total size = "+total);
			map = DynamicUtil.getUserListParam(name, cardNum, email, mobile, startTime, endTime,false);
			ids = userService.getIdsByDynamicCondition(User.class, map, start, size);
			List<User> userList = userService.getObjectsByIds(ids);
			log.info("get getUsersJsonList size is " + ids.size());
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			if (userList.size() % size == 0) {
				model.addAttribute("totalPage", userList.size() / size);
			} else {
				model.addAttribute("totalPage", userList.size() / size + 1);
			}
			model.addAttribute("userList", userList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get users list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-uweiqian-service/user/json/userList";
	}

	/**
	 * 
	 * 根据用户id查询用户信息 /a/u/users/{uid} get
	 */
	@RequestMapping(value = "/a/u/user/{uid}", method = RequestMethod.GET)
	public String getUsersJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long uid) throws Exception {

		log.info("get data : id= " + uid);
		try {
			User user = userService.getObjectById(uid);

			if (user == null) {
				model.addAttribute("code", -8002);
				log.info("get data : id is  null");
				return "/data/json";
			} else {
				log.info("get user data is " + user);
				model.addAttribute("user", user);
			}

			model.addAttribute("uid", uid);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get users error,id is  " + uid);
			model.addAttribute("code", -100000);
		}

		return "/common-uweiqian-service/user/json/userDetail";
	}

	/**
	 * 根据用户id编辑用户信息 /a/u/user/{uid} put
	 */
	@RequestMapping(value = "/a/u/user/{uid}", method = RequestMethod.PUT)
	public String updateUsersJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, User user,
			@PathVariable Long uid) throws Exception {

		log.info("update users : users= " + user);

		try {
			User u = userService.getObjectById(uid);
			if (u == null) {
				log.info("u is null ");
				model.addAttribute("code", -8002);
				return "/data/json";
			} else {
				if (user == null) {
					log.info("users is null ");
					model.addAttribute("code", -1004);
					return "/data/json";
				}
				u.setName(user.getName());
				u.setEmail(user.getEmail());
				u.setMobile(user.getMobile());
				u.setCardNum(user.getCardNum());
				userService.update(u);
				model.addAttribute("code", 0);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update users error,id is  " + user.getId());
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

}
