package com.ptteng.common.uweiqian.controller;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.util.BeanToMap;
import com.ptteng.util.DynamicUtil;
import com.ptteng.uweiqian.home.model.Manager;
import com.ptteng.uweiqian.home.service.ManagerService;
import com.ptteng.uweiqian.organization.model.User;
import com.ptteng.uweiqian.organization.model.UserApply;
import com.ptteng.uweiqian.organization.service.UserApplyService;
import com.ptteng.uweiqian.organization.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Role crud
 *
 * @author magenm 2014-4-16 13:43
 *
 */
@Controller
public class UserApplyController {
	private static final Log log = LogFactory.getLog(UserApplyController.class);
	@Autowired
	private UserApplyService userApplyService;
	@Autowired
	private ManagerService managerService;
	@Autowired
	private UserService userService;

	/***
	 * 
	 * 用户提交资料记录列表 /a/u/user/apply/list 根据用户id查询用户提交资料列表
	 */
	@RequestMapping(value = "/a/u/user/apply/search", method = RequestMethod.GET)
	public String getSubmitRecordJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, String name, String mname, String status, String startTime, String endTime,
			String uid) throws Exception {
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}

		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		log.info("pageList : page= " + start + " , size=" + size);
		try {
			List<Long> ids = null;
			Boolean next = false;
			// size += 1;
			Map<String, Object> map = new HashMap<String, Object>();
			Map<String, Object> mapTotal =DynamicUtil.getUserApplyListParam(uid,status, startTime, endTime, name, mname,true);
			log.info(" get userApply total size param = "+mapTotal);
			BigInteger total =(BigInteger)  userApplyService.getObjectByDynamicCondition(UserApply.class, mapTotal, 0, Integer.MAX_VALUE);
			log.info(" get userApply total size = "+total);
			map = DynamicUtil.getUserApplyListParam(uid,status, startTime, endTime, name, mname,false);
			ids = userApplyService.getIdsByDynamicCondition(UserApply.class, map, start, size);
			List<UserApply> userApplyList = userApplyService.getObjectsByIds(ids);
			log.info("get getuserApplyJsonList size is " + ids.size());
			List<HashMap<String, Object>> subRecordMap = new ArrayList<HashMap<String, Object>>();
			//商户
			List<Long> userIds = new ArrayList<Long>();
			for (UserApply userApply : userApplyList) {
				if (null != userApply.getUserId()) {
					userIds.add(userApply.getUserId());
				}
			}
			List<User> userList = new ArrayList<User>();
			//管理员
			List<Long> managerIds = new ArrayList<Long>();
			for (UserApply userApply : userApplyList) {
				if (null != userApply.getUpdateBy()) {
					managerIds.add(userApply.getUpdateBy());
				}
			}
			List<Manager> managerList = new ArrayList<Manager>();
			managerList = managerService.getObjectsByIds(managerIds);
			for (UserApply userApply : userApplyList) {
				HashMap<String, Object> hashmap = new HashMap<String, Object>();
				BeanToMap beanTomap = new BeanToMap();
				hashmap = beanTomap.beanToMap(userApply);
				//商户
				if (userList.size() > 0) {
					for (User user : userList) {
						if (user.getId().equals(userApply.getUserId())) {
							// 用户名
							hashmap.put("name", user.getName());
							// 手机号
							hashmap.put("mobile", user.getMobile());
						}
					}
				}
				//管理员
				if (managerList.size() > 0) {
					for (Manager manager : managerList) {
						if (manager.getId().equals(userApply.getUpdateBy())) {
							//处理人
							if (null != manager) {
								hashmap.put("mname", manager.getName());
							} else {
								hashmap.put("mname", "");
							}
						}
					}
				}
				subRecordMap.add(hashmap);
			}
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			if (userApplyList.size() % size == 0) {
				model.addAttribute("totalPage", userApplyList.size() / size);
			} else {
				model.addAttribute("totalPage", userApplyList.size() / size + 1);
			}
			model.addAttribute("subRecordMap", subRecordMap);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get submitRecord list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-uweiqian-service/userapply/json/userApplyList";
	}

	/**
	 * 用户提交资料记录更改状态 /a/u/userapply/{srid}
	 */
	@RequestMapping(value = "/a/u/user/apply/{srid}", method = RequestMethod.PUT)
	public String updateSubmitRecordJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			UserApply userApply, @PathVariable Long srid) throws Exception {

		log.info("update userApply : userApply= " + userApply);

		try {
			Manager manager = (Manager) request.getAttribute("manager");
			UserApply sr = userApplyService.getObjectById(srid);
			if (sr == null) {
				log.info("u is null ");
				model.addAttribute("code", -8002);
				return "/data/json";
			} else {
				if (userApply == null) {
					log.info("userApply is null ");
					model.addAttribute("code", -1004);
					return "/data/json";
				}
				sr.setUpdateBy(manager.getId());
				sr.setStatus(userApply.getStatus());
				sr.setReason(userApply.getReason());
				userApplyService.update(sr);
				model.addAttribute("code", 0);
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userApply error,id is  " + userApply.getId());
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

	/**
	 * 根据id查找用户提交资料记录详情 /a/u/userapply/{srid}
	 * 
	 */
	@RequestMapping(value = "/a/u/user/apply/{srid}", method = RequestMethod.GET)
	public String getSubmitRecordJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long srid) throws Exception {

		log.info("get data : id= " + srid);
		try {
			UserApply userApply = userApplyService.getObjectById(srid);

			if (userApply == null) {
				model.addAttribute("code", -8002);
				log.info("get data : id is " + srid);
				return "/data/json";
			} else {
				log.info("get userApply data is " + userApply);
				model.addAttribute("userApply", userApply);
			}

			model.addAttribute("srid", srid);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userApply error,id is  " + srid);
			model.addAttribute("code", -100000);
		}

		return "/common-uweiqian-service/userapply/json/userApplyDetail";
	}
}
