CREATE DATABASE IF NOT EXISTS squirrel_home DEFAULT CHARSET utf8 COLLATE utf8_general_ci;
-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
use squirrel_home;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100)    COMMENT '手机号',  
    `mail` varchar(100)    COMMENT '邮箱',  
    `pwd` varchar(100)    COMMENT '密码',  
    `alias` varchar(100) NOT NULL   COMMENT '用户名',  
    `name` varchar(100)    COMMENT '姓名',  
    `img` varchar(500)    COMMENT '头像',  
    `register_at` bigint    COMMENT '注册时间',  
    `last_login_at` bigint    COMMENT '上次登陆时间',  
    `status` bigint    COMMENT '冻结状态(1正常、2冻结)',  
    `experience` int DEFAULT 0  COMMENT '体验状态(0正常、1已体验)',
    `child_name` varchar(100)  COMMENT '体验人',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_openid_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_openid_relation`;
CREATE TABLE `user_openid_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户ID',  
    `openid` varchar(50) NOT NULL   COMMENT 'openId',  
    `type` varchar(20)    COMMENT '类型',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_order`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_order`;
CREATE TABLE `user_order` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `order_id` varchar(100) NOT NULL   COMMENT '订单id',
    `order_type` int    COMMENT '订单类型',  
    `pay_type` int    COMMENT '支付类型',
    `price` varchar(20) NOT NULL COMMENT '订单金额',
    `buy_at` bigint    COMMENT '下单时间',  
    `status` int    COMMENT '订单状态',  
    `pay_at` bigint    COMMENT '支付时间',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





