package com.ptteng.squirrel.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.squirrel.home.model.UserOrder;
import com.ptteng.squirrel.home.service.UserOrderService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


public class UserOrderServiceImpl extends BaseDaoServiceImpl implements UserOrderService {

 

	private static final Log log = LogFactory.getLog(UserOrderServiceImpl.class);



		   
		@Override
		public Long insert(UserOrder userOrder)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userOrder);

		if (userOrder == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userOrder.setCreateAt(currentTimeMillis);
		userOrder.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userOrder);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userOrder);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserOrder> insertList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userOrderList == null ? "null" : userOrderList.size()));
      
		List<UserOrder> resultList = null;

		if (CollectionUtils.isEmpty(userOrderList)) {
			return new ArrayList<UserOrder>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserOrder userOrder : userOrderList) {
			userOrder.setCreateAt(currentTimeMillis);
			userOrder.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserOrder>) dao.batchSave(userOrderList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userOrderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserOrder.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserOrder userOrder)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userOrder == null ? "null" : userOrder.getId()));

		boolean result = false;

		if (userOrder == null) {
			return true;
		}

		userOrder.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userOrder);
		} catch (DaoException e) {
			log.error(" update wrong : " + userOrder);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userOrder);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userOrderList == null ? "null" : userOrderList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userOrderList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserOrder userOrder : userOrderList) {
			userOrder.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userOrderList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userOrderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userOrderList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserOrder userOrder = null;

		if (id == null) {
			return userOrder;
		}

		try {
			userOrder = (UserOrder) dao.get(UserOrder.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userOrder;		
		}	
		  
    	   
		@Override
		public List<UserOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserOrder> userOrder = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserOrder>();
		}

		try {
			userOrder = (List<UserOrder>) dao.getList(UserOrder.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userOrder == null ? "null" : userOrder.size()));
    
		return userOrder;	
		}




	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserOrderIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserOrderIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserOrderIdByOrderId(String orderId)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by orderId  : " + orderId );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserOrderIdByOrderId", new Object[] {orderId });
   } catch (DaoException e) {
			log.error(" get id wrong by orderId  : " + orderId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserOrderIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserOrderIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserOrderIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserOrderIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserOrderIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserOrderIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}



	@Override
	public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
		try {
			log.info("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : "
					+ payManner);
			Long orderID = getUserOrderIdByOrderId(indentCode);
			UserOrder order = getObjectById(orderID);
			log.info("get order : " + order.toString());
			if (!Integer.valueOf(UserOrder.WAITFORPAY).equals(order.getStatus())) {
				log.info(" indentinfo  service  status not  waitforpay 2  ");
				return;
			}
			Integer status = 0;
			Long uid = order.getUid();
			switch (respCode) {
				case UserOrder.PAY_SUCCESS:         //支付成功
					status = UserOrder.COMPLETED;  //订单状态设为完成
					log.info("lesson order : " + order.getId() + " completed ");
					break;

				case UserOrder.PAY_FAIL:         //支付失败
					status = UserOrder.CLOSED; //订单状态设为关闭
					log.info("lesson order : " + order.getId() + " close ");

					break;
			}

			if (UserOrder.PAY_SUCCESS == respCode) {
				log.info("==========支付成功，记录推广统计信息==========");



			} else {
				log.info("==========支付失败，不记录统计信息==========");
			}

			order.setStatus(status);
			order.setPayType(payManner);
			order.setUpdateAt(System.currentTimeMillis());
			order.setPayAt(System.currentTimeMillis());
			update(order);
			log.info("update order over");


		} catch (Exception e) {
			log.error(e.getMessage());
			log.error(e.getStackTrace());

			e.printStackTrace(System.out);
			log.error("error : ", e);
		}


	}
//	public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
//
//
//		try {
//			log.info("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : "
//					+ payManner);
//			Long orderID = getUserOrderIdByOrderId(indentCode);
//			UserOrder order = getObjectById(orderID);
//			log.info("get order : " + order.toString());
//			if (!Integer.valueOf(UserOrder.WAITFORPAY).equals(order.getStatus())) {
//				log.info(" indentinfo  service  status not  waitforpay 2  ");
//				return;
//			}
//			Integer status = 0;
//			Long uid = order.getUid();
//			switch (respCode) {
//				case UserOrder.PAY_SUCCESS:         //支付成功
//					status = UserOrder.COMPLETED;  //订单状态设为完成
//					log.info("lesson order : " + order.getId() + " completed ");
//					break;
//
//				case UserOrder.PAY_FAIL:         //支付失败
//					status = UserOrder.CLOSED; //订单状态设为关闭
//					log.info("lesson order : " + order.getId() + " close ");
//
//					break;
//			}
//
//			if (UserOrder.PAY_SUCCESS == respCode) {
//				log.info("==========支付成功，记录推广统计信息==========");
//
//
//
//			} else {
//				log.info("==========支付失败，不记录统计信息==========");
//			}
//
//			order.setStatus(status);
//			order.setPayType(payManner);
//			order.setUpdateAt(System.currentTimeMillis());
//			order.setPayAt(System.currentTimeMillis());
//			update(order);
//			log.info("update order over");
//
//
//		} catch (Exception e) {
//			log.error(e.getMessage());
//			log.error(e.getStackTrace());
//
//			e.printStackTrace(System.out);
//			log.error("error : ", e);
//		}

//	}


	public static String getDate(Long time) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String date = "";

		if (null != time) {
			date = dateFormat.format(new Date(time));
		}
		return date;
	}


}

