/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.squirrel.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.squirrel.home.model.UserOrder;
import com.ptteng.squirrel.home.service.UserOrderService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserOrderServiceImpl
extends BaseDaoServiceImpl
implements UserOrderService {
    private static final Log log = LogFactory.getLog(UserOrderServiceImpl.class);

    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOrder));
        if (userOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOrder == null ? "null" : userOrder.getId())));
        boolean result = false;
        if (userOrder == null) {
            return true;
        }
        userOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOrder));
        }
        return result;
    }

    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOrderList.size()));
        return result;
    }

    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOrder userOrder = null;
        if (id == null) {
            return userOrder;
        }
        try {
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOrder;
    }

    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }
        try {
            userOrder = this.dao.getList(UserOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOrder == null ? "null" : Integer.valueOf(userOrder.size()))));
        return userOrder;
    }

    public List<Long> getUserOrderIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserOrderIdByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderId  : " + orderId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdByOrderId", new Object[]{orderId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderId  : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countUserOrderIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
        try {
            log.info((Object)("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner));
            Long orderID = this.getUserOrderIdByOrderId(indentCode);
            UserOrder order = this.getObjectById(orderID);
            log.info((Object)("get order : " + order.toString()));
            if (!Integer.valueOf(1).equals(order.getStatus())) {
                log.info((Object)" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long uid = order.getUid();
            switch (respCode) {
                case 1: {
                    status = 3;
                    log.info((Object)("lesson order : " + order.getId() + " completed "));
                    break;
                }
                case 2: {
                    status = 2;
                    log.info((Object)("lesson order : " + order.getId() + " close "));
                }
            }
            if (1 == respCode) {
                log.info((Object)"==========\u652f\u4ed8\u6210\u529f\uff0c\u8bb0\u5f55\u63a8\u5e7f\u7edf\u8ba1\u4fe1\u606f==========");
            } else {
                log.info((Object)"==========\u652f\u4ed8\u5931\u8d25\uff0c\u4e0d\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f==========");
            }
            order.setStatus(status);
            order.setPayType(Integer.valueOf(payManner));
            order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
            order.setPayAt(Long.valueOf(System.currentTimeMillis()));
            this.update(order);
            log.info((Object)"update order over");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
            e.printStackTrace(System.out);
            log.error((Object)"error : ", (Throwable)e);
        }
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }
}

