/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Symptom;
import com.ptteng.common.skill.service.SymptomService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SymptomServiceImpl
extends BaseDaoServiceImpl
implements SymptomService {
    private static final Log log = LogFactory.getLog(SymptomServiceImpl.class);

    public Long insert(Symptom symptom) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + symptom));
        if (symptom == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        symptom.setCreateAt(Long.valueOf(currentTimeMillis));
        symptom.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)symptom);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + symptom));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Symptom> insertList(List<Symptom> symptomList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (symptomList == null ? "null" : Integer.valueOf(symptomList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(symptomList)) {
            return new ArrayList<Symptom>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Symptom symptom : symptomList) {
            symptom.setCreateAt(Long.valueOf(currentTimeMillis));
            symptom.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(symptomList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + symptomList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Symptom.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Symptom symptom) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (symptom == null ? "null" : symptom.getId())));
        boolean result = false;
        if (symptom == null) {
            return true;
        }
        symptom.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)symptom);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + symptom));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + symptom));
        }
        return result;
    }

    public boolean updateList(List<Symptom> symptomList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (symptomList == null ? "null" : Integer.valueOf(symptomList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(symptomList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Symptom symptom : symptomList) {
            symptom.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(symptomList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + symptomList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + symptomList.size()));
        return result;
    }

    public Symptom getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Symptom symptom = null;
        if (id == null) {
            return symptom;
        }
        try {
            symptom = (Symptom)this.dao.get(Symptom.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return symptom;
    }

    public List<Symptom> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List symptom = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Symptom>();
        }
        try {
            symptom = this.dao.getList(Symptom.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (symptom == null ? "null" : Integer.valueOf(symptom.size()))));
        return symptom;
    }

    public List<Long> getSymptomIdsByTid(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by tid,start,limit  : " + tid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSymptomIdsByTid", new Object[]{tid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by tid,start,limit)  : " + tid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSymptomIdsByTid(Long tid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by tid  : " + tid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSymptomIdsByTid", new Object[]{tid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by tid)  : " + tid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getSymptomIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSymptomIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSymptomIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSymptomIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSymptomIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

