/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Score;
import com.ptteng.common.skill.service.ScoreService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScoreServiceImpl
extends BaseDaoServiceImpl
implements ScoreService {
    private static final Log log = LogFactory.getLog(ScoreServiceImpl.class);

    public Long insert(Score score) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + score));
        if (score == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        score.setCreateAt(Long.valueOf(currentTimeMillis));
        score.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)score);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + score));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Score> insertList(List<Score> scoreList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (scoreList == null ? "null" : Integer.valueOf(scoreList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(scoreList)) {
            return new ArrayList<Score>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Score score : scoreList) {
            score.setCreateAt(Long.valueOf(currentTimeMillis));
            score.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(scoreList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + scoreList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Score.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Score score) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (score == null ? "null" : score.getId())));
        boolean result = false;
        if (score == null) {
            return true;
        }
        score.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)score);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + score));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + score));
        }
        return result;
    }

    public boolean updateList(List<Score> scoreList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (scoreList == null ? "null" : Integer.valueOf(scoreList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(scoreList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Score score : scoreList) {
            score.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(scoreList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + scoreList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + scoreList.size()));
        return result;
    }

    public Score getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Score score = null;
        if (id == null) {
            return score;
        }
        try {
            score = (Score)this.dao.get(Score.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return score;
    }

    public List<Score> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List score = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Score>();
        }
        try {
            score = this.dao.getList(Score.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (score == null ? "null" : Integer.valueOf(score.size()))));
        return score;
    }

    public List<Long> getScoreIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getScoreIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countScoreIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getScoreIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getScoreIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

