/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Problem;
import com.ptteng.common.skill.service.ProblemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProblemServiceImpl
extends BaseDaoServiceImpl
implements ProblemService {
    private static final Log log = LogFactory.getLog(ProblemServiceImpl.class);

    public Long insert(Problem problem) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + problem));
        if (problem == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        problem.setCreateAt(Long.valueOf(currentTimeMillis));
        problem.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)problem);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + problem));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Problem> insertList(List<Problem> problemList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (problemList == null ? "null" : Integer.valueOf(problemList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(problemList)) {
            return new ArrayList<Problem>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Problem problem : problemList) {
            problem.setCreateAt(Long.valueOf(currentTimeMillis));
            problem.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(problemList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + problemList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Problem.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Problem problem) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (problem == null ? "null" : problem.getId())));
        boolean result = false;
        if (problem == null) {
            return true;
        }
        problem.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)problem);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + problem));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + problem));
        }
        return result;
    }

    public boolean updateList(List<Problem> problemList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (problemList == null ? "null" : Integer.valueOf(problemList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(problemList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Problem problem : problemList) {
            problem.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(problemList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + problemList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + problemList.size()));
        return result;
    }

    public Problem getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Problem problem = null;
        if (id == null) {
            return problem;
        }
        try {
            problem = (Problem)this.dao.get(Problem.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return problem;
    }

    public List<Problem> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List problem = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Problem>();
        }
        try {
            problem = this.dao.getList(Problem.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (problem == null ? "null" : Integer.valueOf(problem.size()))));
        return problem;
    }

    public List<Long> getProblemIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProblemIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProblemIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProblemIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProblemIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProblemIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProblemIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

