/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Portrait;
import com.ptteng.common.skill.service.PortraitService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortraitServiceImpl
extends BaseDaoServiceImpl
implements PortraitService {
    private static final Log log = LogFactory.getLog(PortraitServiceImpl.class);

    public Long insert(Portrait portrait) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + portrait));
        if (portrait == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        portrait.setCreateAt(Long.valueOf(currentTimeMillis));
        portrait.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)portrait);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + portrait));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Portrait> insertList(List<Portrait> portraitList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (portraitList == null ? "null" : Integer.valueOf(portraitList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(portraitList)) {
            return new ArrayList<Portrait>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Portrait portrait : portraitList) {
            portrait.setCreateAt(Long.valueOf(currentTimeMillis));
            portrait.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(portraitList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + portraitList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Portrait.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Portrait portrait) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (portrait == null ? "null" : portrait.getId())));
        boolean result = false;
        if (portrait == null) {
            return true;
        }
        portrait.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)portrait);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + portrait));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + portrait));
        }
        return result;
    }

    public boolean updateList(List<Portrait> portraitList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (portraitList == null ? "null" : Integer.valueOf(portraitList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(portraitList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Portrait portrait : portraitList) {
            portrait.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(portraitList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + portraitList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + portraitList.size()));
        return result;
    }

    public Portrait getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Portrait portrait = null;
        if (id == null) {
            return portrait;
        }
        try {
            portrait = (Portrait)this.dao.get(Portrait.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return portrait;
    }

    public List<Portrait> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List portrait = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Portrait>();
        }
        try {
            portrait = this.dao.getList(Portrait.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (portrait == null ? "null" : Integer.valueOf(portrait.size()))));
        return portrait;
    }

    public List<Long> getPortraitIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPortraitIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPortraitIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPortraitIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPortraitIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPortraitIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPortraitIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

