/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Option;
import com.ptteng.common.skill.service.OptionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionServiceImpl
extends BaseDaoServiceImpl
implements OptionService {
    private static final Log log = LogFactory.getLog(OptionServiceImpl.class);

    public Long insert(Option option) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + option));
        if (option == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        option.setCreateAt(Long.valueOf(currentTimeMillis));
        option.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)option);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + option));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Option> insertList(List<Option> optionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (optionList == null ? "null" : Integer.valueOf(optionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(optionList)) {
            return new ArrayList<Option>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Option option : optionList) {
            option.setCreateAt(Long.valueOf(currentTimeMillis));
            option.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(optionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + optionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Option.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Option option) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (option == null ? "null" : option.getId())));
        boolean result = false;
        if (option == null) {
            return true;
        }
        option.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)option);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + option));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + option));
        }
        return result;
    }

    public boolean updateList(List<Option> optionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (optionList == null ? "null" : Integer.valueOf(optionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(optionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Option option : optionList) {
            option.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(optionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + optionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + optionList.size()));
        return result;
    }

    public Option getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Option option = null;
        if (id == null) {
            return option;
        }
        try {
            option = (Option)this.dao.get(Option.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return option;
    }

    public List<Option> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List option = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Option>();
        }
        try {
            option = this.dao.getList(Option.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (option == null ? "null" : Integer.valueOf(option.size()))));
        return option;
    }

    public List<Long> getOptionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOptionIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOptionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOptionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOptionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

