/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Label;
import com.ptteng.common.skill.service.LabelService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelServiceImpl
extends BaseDaoServiceImpl
implements LabelService {
    private static final Log log = LogFactory.getLog(LabelServiceImpl.class);

    public Long insert(Label label) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + label));
        if (label == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        label.setCreateAt(Long.valueOf(currentTimeMillis));
        label.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)label);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + label));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Label> insertList(List<Label> labelList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (labelList == null ? "null" : Integer.valueOf(labelList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(labelList)) {
            return new ArrayList<Label>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Label label : labelList) {
            label.setCreateAt(Long.valueOf(currentTimeMillis));
            label.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(labelList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + labelList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Label.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Label label) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (label == null ? "null" : label.getId())));
        boolean result = false;
        if (label == null) {
            return true;
        }
        label.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)label);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + label));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + label));
        }
        return result;
    }

    public boolean updateList(List<Label> labelList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (labelList == null ? "null" : Integer.valueOf(labelList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(labelList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Label label : labelList) {
            label.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(labelList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + labelList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + labelList.size()));
        return result;
    }

    public Label getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Label label = null;
        if (id == null) {
            return label;
        }
        try {
            label = (Label)this.dao.get(Label.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return label;
    }

    public List<Label> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List label = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Label>();
        }
        try {
            label = this.dao.getList(Label.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (label == null ? "null" : Integer.valueOf(label.size()))));
        return label;
    }

    public List<Long> getLabelIdsByTidOrderByUpdateAt(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by tid,start,limit  : " + tid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLabelIdsByTidOrderByUpdateAt", new Object[]{tid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by tid,start,limit)  : " + tid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLabelIdsByTidAndStatusOrderByUpdateAt(Long tid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by tid,status,start,limit  : " + tid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLabelIdsByTidAndStatusOrderByUpdateAt", new Object[]{tid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by tid,status,start,limit)  : " + tid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLabelIdsByTidOrderByUpdateAt(Long tid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by tid  : " + tid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLabelIdsByTidOrderByUpdateAt", new Object[]{tid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by tid)  : " + tid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countLabelIdsByTidAndStatusOrderByUpdateAt(Long tid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by tid,status  : " + tid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLabelIdsByTidAndStatusOrderByUpdateAt", new Object[]{tid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by tid,status)  : " + tid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getLabelIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLabelIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLabelIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLabelIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLabelIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

