/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.service.ClassTimetableService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassTimetableServiceImpl
extends BaseDaoServiceImpl
implements ClassTimetableService {
    private static final Log log = LogFactory.getLog(ClassTimetableServiceImpl.class);

    public Long insert(ClassTimetable classTimetable) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + classTimetable));
        if (classTimetable == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        classTimetable.setCreateAt(Long.valueOf(currentTimeMillis));
        classTimetable.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)classTimetable);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + classTimetable));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ClassTimetable> insertList(List<ClassTimetable> classTimetableList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (classTimetableList == null ? "null" : Integer.valueOf(classTimetableList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(classTimetableList)) {
            return new ArrayList<ClassTimetable>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ClassTimetable classTimetable : classTimetableList) {
            classTimetable.setCreateAt(Long.valueOf(currentTimeMillis));
            classTimetable.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(classTimetableList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + classTimetableList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ClassTimetable.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ClassTimetable classTimetable) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (classTimetable == null ? "null" : classTimetable.getId())));
        boolean result = false;
        if (classTimetable == null) {
            return true;
        }
        classTimetable.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)classTimetable);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + classTimetable));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + classTimetable));
        }
        return result;
    }

    public boolean updateList(List<ClassTimetable> classTimetableList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (classTimetableList == null ? "null" : Integer.valueOf(classTimetableList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(classTimetableList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ClassTimetable classTimetable : classTimetableList) {
            classTimetable.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(classTimetableList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + classTimetableList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + classTimetableList.size()));
        return result;
    }

    public ClassTimetable getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ClassTimetable classTimetable = null;
        if (id == null) {
            return classTimetable;
        }
        try {
            classTimetable = (ClassTimetable)this.dao.get(ClassTimetable.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return classTimetable;
    }

    public List<ClassTimetable> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List classTimetable = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ClassTimetable>();
        }
        try {
            classTimetable = this.dao.getList(ClassTimetable.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (classTimetable == null ? "null" : Integer.valueOf(classTimetable.size()))));
        return classTimetable;
    }

    public List<Long> getClassTimetableIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassTimetableIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassTimetableIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getClassTimetableIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getClassTimetableIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

