/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Advisory;
import com.ptteng.common.skill.service.AdvisoryService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdvisoryServiceImpl
extends BaseDaoServiceImpl
implements AdvisoryService {
    private static final Log log = LogFactory.getLog(AdvisoryServiceImpl.class);

    public Long insert(Advisory advisory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + advisory));
        if (advisory == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        advisory.setCreateAt(Long.valueOf(currentTimeMillis));
        advisory.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)advisory);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + advisory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Advisory> insertList(List<Advisory> advisoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (advisoryList == null ? "null" : Integer.valueOf(advisoryList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(advisoryList)) {
            return new ArrayList<Advisory>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Advisory advisory : advisoryList) {
            advisory.setCreateAt(Long.valueOf(currentTimeMillis));
            advisory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(advisoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + advisoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Advisory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Advisory advisory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (advisory == null ? "null" : advisory.getId())));
        boolean result = false;
        if (advisory == null) {
            return true;
        }
        advisory.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)advisory);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + advisory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + advisory));
        }
        return result;
    }

    public boolean updateList(List<Advisory> advisoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (advisoryList == null ? "null" : Integer.valueOf(advisoryList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(advisoryList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Advisory advisory : advisoryList) {
            advisory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(advisoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + advisoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + advisoryList.size()));
        return result;
    }

    public Advisory getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Advisory advisory = null;
        if (id == null) {
            return advisory;
        }
        try {
            advisory = (Advisory)this.dao.get(Advisory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return advisory;
    }

    public List<Advisory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List advisory = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Advisory>();
        }
        try {
            advisory = this.dao.getList(Advisory.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (advisory == null ? "null" : Integer.valueOf(advisory.size()))));
        return advisory;
    }

    public Long getAdvisoryIdByOid(Long oid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by oid  : " + oid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getAdvisoryIdByOid", new Object[]{oid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by oid  : " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getAdvisoryIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAdvisoryIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAdvisoryIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAdvisoryIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAdvisoryIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

