package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Week;
import com.ptteng.common.skill.service.WeekService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class WeekServiceImpl extends BaseDaoServiceImpl implements WeekService {

 

	private static final Log log = LogFactory.getLog(WeekServiceImpl.class);



		   
		@Override
		public Long insert(Week week)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + week);

		if (week == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		week.setCreateAt(currentTimeMillis);
		week.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(week);
		} catch (DaoException e) {
			log.error(" insert wrong : " + week);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Week> insertList(List<Week> weekList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (weekList == null ? "null" : weekList.size()));
      
		List<Week> resultList = null;

		if (CollectionUtils.isEmpty(weekList)) {
			return new ArrayList<Week>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Week week : weekList) {
			week.setCreateAt(currentTimeMillis);
			week.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Week>) dao.batchSave(weekList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + weekList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Week.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Week week)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (week == null ? "null" : week.getId()));

		boolean result = false;

		if (week == null) {
			return true;
		}

		week.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(week);
		} catch (DaoException e) {
			log.error(" update wrong : " + week);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + week);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Week> weekList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (weekList == null ? "null" : weekList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(weekList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Week week : weekList) {
			week.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(weekList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + weekList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + weekList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Week getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Week week = null;

		if (id == null) {
			return week;
		}

		try {
			week = (Week) dao.get(Week.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return week;		
		}	
		  
    	   
		@Override
		public List<Week> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Week> week = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Week>();
		}

		try {
			week = (List<Week>) dao.getList(Week.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (week == null ? "null" : week.size()));
    
		return week;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getWeekIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getWeekIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countWeekIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getWeekIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getWeekIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getWeekIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countWeekIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getWeekIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getWeekIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

