package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserSymptomRelation;
import com.ptteng.common.skill.service.UserSymptomRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserSymptomRelationServiceImpl extends BaseDaoServiceImpl implements UserSymptomRelationService {

 

	private static final Log log = LogFactory.getLog(UserSymptomRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserSymptomRelation userSymptomRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userSymptomRelation);

		if (userSymptomRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userSymptomRelation.setCreateAt(currentTimeMillis);
		userSymptomRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userSymptomRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userSymptomRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserSymptomRelation> insertList(List<UserSymptomRelation> userSymptomRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userSymptomRelationList == null ? "null" : userSymptomRelationList.size()));
      
		List<UserSymptomRelation> resultList = null;

		if (CollectionUtils.isEmpty(userSymptomRelationList)) {
			return new ArrayList<UserSymptomRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserSymptomRelation userSymptomRelation : userSymptomRelationList) {
			userSymptomRelation.setCreateAt(currentTimeMillis);
			userSymptomRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserSymptomRelation>) dao.batchSave(userSymptomRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userSymptomRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserSymptomRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserSymptomRelation userSymptomRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userSymptomRelation == null ? "null" : userSymptomRelation.getId()));

		boolean result = false;

		if (userSymptomRelation == null) {
			return true;
		}

		userSymptomRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userSymptomRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userSymptomRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userSymptomRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserSymptomRelation> userSymptomRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userSymptomRelationList == null ? "null" : userSymptomRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userSymptomRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserSymptomRelation userSymptomRelation : userSymptomRelationList) {
			userSymptomRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userSymptomRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userSymptomRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userSymptomRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserSymptomRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserSymptomRelation userSymptomRelation = null;

		if (id == null) {
			return userSymptomRelation;
		}

		try {
			userSymptomRelation = (UserSymptomRelation) dao.get(UserSymptomRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userSymptomRelation;		
		}	
		  
    	   
		@Override
		public List<UserSymptomRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserSymptomRelation> userSymptomRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserSymptomRelation>();
		}

		try {
			userSymptomRelation = (List<UserSymptomRelation>) dao.getList(UserSymptomRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userSymptomRelation == null ? "null" : userSymptomRelation.size()));
    
		return userSymptomRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserSymptomRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserSymptomRelationIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserSymptomRelationIdsByWid(Long wid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by wid,start,limit  : " + wid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserSymptomRelationIdsByWid", new Object[] { wid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by wid,start,limit)  : " + wid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserSymptomRelationIdsBySid(Long sid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by sid,start,limit  : " + sid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserSymptomRelationIdsBySid", new Object[] { sid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by sid,start,limit)  : " + sid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserSymptomRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserSymptomRelationIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserSymptomRelationIdsByWid(Long wid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by wid  : " + wid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserSymptomRelationIdsByWid", new Object[] { wid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by wid)  : " + wid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserSymptomRelationIdsBySid(Long sid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by sid  : " + sid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserSymptomRelationIdsBySid", new Object[] { sid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by sid)  : " + sid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserSymptomRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserSymptomRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserSymptomRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserSymptomRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserSymptomRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

