package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserSkillRelation;
import com.ptteng.common.skill.service.UserSkillRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserSkillRelationServiceImpl extends BaseDaoServiceImpl implements UserSkillRelationService {

 

	private static final Log log = LogFactory.getLog(UserSkillRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserSkillRelation userSkillRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userSkillRelation);

		if (userSkillRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userSkillRelation.setCreateAt(currentTimeMillis);
		userSkillRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userSkillRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userSkillRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserSkillRelation> insertList(List<UserSkillRelation> userSkillRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userSkillRelationList == null ? "null" : userSkillRelationList.size()));
      
		List<UserSkillRelation> resultList = null;

		if (CollectionUtils.isEmpty(userSkillRelationList)) {
			return new ArrayList<UserSkillRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserSkillRelation userSkillRelation : userSkillRelationList) {
			userSkillRelation.setCreateAt(currentTimeMillis);
			userSkillRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserSkillRelation>) dao.batchSave(userSkillRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userSkillRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserSkillRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserSkillRelation userSkillRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userSkillRelation == null ? "null" : userSkillRelation.getId()));

		boolean result = false;

		if (userSkillRelation == null) {
			return true;
		}

		userSkillRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userSkillRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userSkillRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userSkillRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserSkillRelation> userSkillRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userSkillRelationList == null ? "null" : userSkillRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userSkillRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserSkillRelation userSkillRelation : userSkillRelationList) {
			userSkillRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userSkillRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userSkillRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userSkillRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserSkillRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserSkillRelation userSkillRelation = null;

		if (id == null) {
			return userSkillRelation;
		}

		try {
			userSkillRelation = (UserSkillRelation) dao.get(UserSkillRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userSkillRelation;		
		}	
		  
    	   
		@Override
		public List<UserSkillRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserSkillRelation> userSkillRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserSkillRelation>();
		}

		try {
			userSkillRelation = (List<UserSkillRelation>) dao.getList(UserSkillRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userSkillRelation == null ? "null" : userSkillRelation.size()));
    
		return userSkillRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserSkillRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserSkillRelationIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getUserSkillRelationIdsBySid(Long sid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by sid,start,limit  : " + sid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserSkillRelationIdsBySid", new Object[] { sid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by sid,start,limit)  : " + sid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserSkillRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserSkillRelationIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}

	@Override
	public Integer countUserSkillRelationIdsBySid(Long sid) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" count ids by sid  : " + sid );
		}
		Integer count=null;



		try {

			count = dao.count("getUserSkillRelationIdsBySid", new Object[] { sid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by sid)  : " + sid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;
	}


	@Override
	public List<Long> getUserSkillRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserSkillRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserSkillRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserSkillRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserSkillRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

