package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.ptteng.common.skill.model.User;
import com.qding.common.util.DataUtils;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Teacher;
import com.ptteng.common.skill.service.TeacherService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;

public class TeacherServiceImpl extends BaseDaoServiceImpl implements
		TeacherService {

	private static final Log log = LogFactory.getLog(TeacherServiceImpl.class);

	@Override
	public Long insert(Teacher teacher) throws ServiceException,
			ServiceDaoException {

		log.info(" insert data : " + teacher);

		if (teacher == null) {
			return null;
		}

		if (teacher.getId() == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		teacher.setCreateAt(currentTimeMillis);
		teacher.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(teacher);
		} catch (DaoException e) {
			log.error(" insert wrong : " + teacher);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}

	@Override
	public List<Teacher> insertList(List<Teacher> teacherList)
			throws ServiceException, ServiceDaoException {

		log.info(" insert lists : "
				+ (teacherList == null ? "null" : teacherList.size()));

		List<Teacher> teachers = new ArrayList<>();
		List<Teacher> resultList = null;

		if (CollectionUtils.isEmpty(teacherList)) {
			return new ArrayList<Teacher>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Teacher teacher : teacherList) {
			if (teacher.getId() != null) {
				teacher.setCreateAt(currentTimeMillis);
				teacher.setUpdateAt(currentTimeMillis);
				teachers.add(teacher);
			} else {
				log.info("teacher`id is null:" + teacher);
			}
		}

		try {
			resultList = (List<Teacher>) dao.batchSave(teachers);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + teacherList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : "
				+ (resultList == null ? "null" : resultList.size()));

		return resultList;

	}

	@Override
	public boolean delete(Long id) throws ServiceException, ServiceDaoException {

		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Teacher.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}

	@Override
	public boolean update(Teacher teacher) throws ServiceException,
			ServiceDaoException {

		log.info(" update data : "
				+ (teacher == null ? "null" : teacher.getId()));

		boolean result = false;

		if (teacher == null) {
			return true;
		}

		teacher.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(teacher);
		} catch (DaoException e) {
			log.error(" update wrong : " + teacher);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" update data success : " + teacher);
		}
		return result;
	}

	@Override
	public boolean updateList(List<Teacher> teacherList)
			throws ServiceException, ServiceDaoException {

		log.info(" update lists : "
				+ (teacherList == null ? "null" : teacherList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(teacherList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Teacher teacher : teacherList) {
			teacher.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(teacherList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + teacherList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + teacherList.size());

		return result;
	}

	@Override
	public Teacher getObjectById(Long id) throws ServiceException,
			ServiceDaoException {

		log.info(" get data : " + id);

		Teacher teacher = null;

		if (id == null) {
			return teacher;
		}

		try {
			teacher = (Teacher) dao.get(Teacher.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return teacher;
	}

	@Override
	public List<Teacher> getObjectsByIds(List<Long> ids)
			throws ServiceException, ServiceDaoException {

		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Teacher> teacher = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Teacher>();
		}

		try {
			teacher = (List<Teacher>) dao.getList(Teacher.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : "
				+ (teacher == null ? "null" : teacher.size()));

		return teacher;
	}

	@Override
	public List<Long> getTeacherIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start
				+ " , " + limit);
		List<Long> idList = null;

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTeacherIdsAll", new Object[] {}, start,
					limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , "
					+ limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : "
					+ (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public Integer countTeacherIds() throws ServiceException,
			ServiceDaoException {
		Integer count = 0;
		try {
			count = dao.count("getTeacherIdsAll", new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getTeacherIds ");
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	@Override
	public void dropTeacherRelationToStundent(List<User> students,
			Long teacherId) throws ServiceException, ServiceDaoException {
		try {
			log.info(" dropTeacherRelationToStundent ,teacherId = " + teacherId);

			Teacher teacher = null;

			if (DataUtils.isNotNullOrEmpty(teacherId)) {
				teacher = this.getObjectById(teacherId);
				log.info(" oldTeacher detail :" + teacher);
			} else {
				log.info(" oldTeacherId is null, don`t need dropTeacherRelation ");
				return;
			}
			for (User student : students) {
				log.info(" student " + student.getId()
						+ " dropTeacherRelationToStundent ");
				if (DataUtils.isNotNullOrEmpty(teacher)
						&& DataUtils.isNotNullOrEmpty(student)) {
					/* 根据师弟的身份，修改师兄的各项值 */
					int studentIdentify = student.getIdentity().intValue();

					switch (studentIdentify) {
					case User.Identity_Online:
						int onlineNow = teacher.getOnlineNow() - 1;
						teacher.setOnlineNow(onlineNow);
						log.info(student.getId()
								+  " update teacher for removing a online student");
						break;

					case User.Identity_Outside:
						int outlineNow = teacher.getOutlineNow() - 1;
						teacher.setOutlineTotal(outlineNow);
						log.info(student.getId()
								+ " update teacher for removing a outline student");
						break;

					case User.Identity_Offline:
						int offlineNow = teacher.getOfflineNow() - 1;
						teacher.setOfflineNow(offlineNow);
						log.info(student.getId()
								+ " update teacher for removing a offline student");
						break;

					default:
						log.info(student.getId()
								+ " is a unkown studentIdentify");
						break;
						

					}
					if (User.Head_Offical == studentIdentify
							|| User.Head_Pratice == studentIdentify) {
						int chefNow = teacher.getChefNow() - 1;
						teacher.setChefNow(chefNow);
						log.info("update teacher for removing a chef student");
					}

				}

			}
			this.update(teacher);

		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update teacher error ");
		}
	}

	@Override
	public void addTeacherRelationToStundent(User student, Long teacherId)
			throws ServiceException, ServiceDaoException {
		log.info(" dropTeacherRelationToStundent ,students = "
				+ student.getId());
		log.info(" dropTeacherRelationToStundent ,teacherId = " + teacherId);

		Teacher teacher = this.getObjectById(teacherId);
		try {
			/* 给师弟分配师兄之后，调用此方法，修改师兄的统计值，此时student的身份在加入相应的班级时已经更改好 */
			if (DataUtils.isNotNullOrEmpty(teacher)
					&& DataUtils.isNotNullOrEmpty(student)) {

				/* 根据师弟的身份，修改师兄的各项值 */
				int studentIdentify = student.getIdentity().intValue();
				
				
				switch (studentIdentify) {
				case User.Identity_Online:
					int onlineNow = teacher.getOnlineNow() + 1;
					int onlineTotal = teacher.getOnlineTotal() + 1;
					teacher.setOnlineNow(onlineNow);
					teacher.setOnlineTotal(onlineTotal);
					log.info(student.getId()+"update teacher for adding a online student");
					break;

				case User.Identity_Outside:
					int outlineNow = teacher.getOutlineNow() + 1;
					int outlintTotal = teacher.getOutlineTotal() + 1;
					teacher.setOutlineNow(outlineNow);
					teacher.setOutlineTotal(outlintTotal);
					log.info(student.getId()+"update teacher for adding a outline student");
					break;

				case User.Identity_Offline:
					int offlineNow = teacher.getOfflineNow() + 1;
					int offlineTotal = teacher.getOfflineTotal() + 1;
					teacher.setOfflineNow(offlineNow);
					teacher.setOfflineTotal(offlineTotal);
					log.info(student.getId()+"update teacher for adding a offline student");
					break;

				default:
					log.info(student.getId() + " is a unkown studentIdentify");

					break;
					

				}
				
				
				if (User.Head_Offical == studentIdentify
						|| User.Head_Pratice == studentIdentify) {
					int chefNow = teacher.getChefNow() + 1;
					int chefTotal = teacher.getChefTotal() + 1;
					teacher.setChefNow(chefNow);
					teacher.setChefTotal(chefTotal);
					log.info(student.getId()+" update teacher for adding a chef student");
				}
		

				this.update(teacher);
			}

		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update teacher error ");
		}
	}

	@Override
	public void addTeacherRelationToStundents(List<User> students,
			Long teacherId) throws ServiceException, ServiceDaoException {
		log.info(" addTeacherRelationToStundents start ... ");
		log.info(" addTeacherRelationToStundents ,teacherId = " + teacherId);
		Teacher teacher = this.getObjectById(teacherId);
		try {
			/* 给师弟分配师兄之后，调用此方法，修改师兄的统计值，此时student的身份在加入相应的班级时已经更改好 */
			if (DataUtils.isNotNullOrEmpty(teacher)
					&& CollectionUtils.isNotEmpty(students)) {
				for (User student : students) {
					log.info(" student " + student.getId()
							+ " addTeacherRelationToStundents ");
					/* 根据师弟的身份，修改师兄的各项值 */
					int studentIdentify = student.getIdentity().intValue();
					
					
					switch (studentIdentify) {
					case User.Identity_Online:
						int chefNow = teacher.getChefNow() + 1;
						int chefTotal = teacher.getChefTotal() + 1;
						teacher.setChefNow(chefNow);
						teacher.setChefTotal(chefTotal);
						log.info(student.getId()+" update teacher for adding a chef student");
						break;

					case User.Identity_Outside:
						int onlineNow = teacher.getOnlineNow() + 1;
						int onlineTotal = teacher.getOnlineTotal() + 1;
						teacher.setOnlineNow(onlineNow);
						teacher.setOnlineTotal(onlineTotal);
						log.info(student.getId()+" update teacher for adding a online student");
						break;

					case User.Identity_Offline:
						int offlineNow = teacher.getOfflineNow() + 1;
						int offlineTotal = teacher.getOfflineTotal() + 1;
						teacher.setOfflineNow(offlineNow);
						teacher.setOfflineTotal(offlineTotal);
						log.info(student.getId()+" update teacher for adding a offline student");
						break;

					default:
						log.info(student.getId() + " is a unkown studentIdentify");

						break;
						

					}
					
					
					if (User.Head_Offical == studentIdentify
							|| User.Head_Pratice == studentIdentify) {
						int chefNow = teacher.getChefNow() + 1;
						int chefTotal = teacher.getChefTotal() + 1;
						teacher.setChefNow(chefNow);
						teacher.setChefTotal(chefTotal);
						log.info(student.getId()+" update teacher for adding a offline student");
					}
			

			
				}

				this.update(teacher);
			}

		} catch (Exception t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update teacher error ");
		}
	}

}
