package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Symptom;
import com.ptteng.common.skill.service.SymptomService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SymptomServiceImpl extends BaseDaoServiceImpl implements SymptomService {

 

	private static final Log log = LogFactory.getLog(SymptomServiceImpl.class);



		   
		@Override
		public Long insert(Symptom symptom)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + symptom);

		if (symptom == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		symptom.setCreateAt(currentTimeMillis);
		symptom.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(symptom);
		} catch (DaoException e) {
			log.error(" insert wrong : " + symptom);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Symptom> insertList(List<Symptom> symptomList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (symptomList == null ? "null" : symptomList.size()));
      
		List<Symptom> resultList = null;

		if (CollectionUtils.isEmpty(symptomList)) {
			return new ArrayList<Symptom>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Symptom symptom : symptomList) {
			symptom.setCreateAt(currentTimeMillis);
			symptom.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Symptom>) dao.batchSave(symptomList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + symptomList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Symptom.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Symptom symptom)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (symptom == null ? "null" : symptom.getId()));

		boolean result = false;

		if (symptom == null) {
			return true;
		}

		symptom.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(symptom);
		} catch (DaoException e) {
			log.error(" update wrong : " + symptom);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + symptom);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Symptom> symptomList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (symptomList == null ? "null" : symptomList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(symptomList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Symptom symptom : symptomList) {
			symptom.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(symptomList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + symptomList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + symptomList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Symptom getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Symptom symptom = null;

		if (id == null) {
			return symptom;
		}

		try {
			symptom = (Symptom) dao.get(Symptom.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return symptom;		
		}	
		  
    	   
		@Override
		public List<Symptom> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Symptom> symptom = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Symptom>();
		}

		try {
			symptom = (List<Symptom>) dao.getList(Symptom.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (symptom == null ? "null" : symptom.size()));
    
		return symptom;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSymptomIdsByTid(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getSymptomIdsByTid", new Object[] { tid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSymptomIdsByTid(Long tid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid  : " + tid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSymptomIdsByTid", new Object[] { tid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getSymptomIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSymptomIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSymptomIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSymptomIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSymptomIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

