package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Score;
import com.ptteng.common.skill.service.ScoreService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ScoreServiceImpl extends BaseDaoServiceImpl implements ScoreService {

 

	private static final Log log = LogFactory.getLog(ScoreServiceImpl.class);



		   
		@Override
		public Long insert(Score score)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + score);

		if (score == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		score.setCreateAt(currentTimeMillis);
		score.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(score);
		} catch (DaoException e) {
			log.error(" insert wrong : " + score);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Score> insertList(List<Score> scoreList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (scoreList == null ? "null" : scoreList.size()));
      
		List<Score> resultList = null;

		if (CollectionUtils.isEmpty(scoreList)) {
			return new ArrayList<Score>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Score score : scoreList) {
			score.setCreateAt(currentTimeMillis);
			score.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Score>) dao.batchSave(scoreList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + scoreList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Score.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Score score)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (score == null ? "null" : score.getId()));

		boolean result = false;

		if (score == null) {
			return true;
		}

		score.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(score);
		} catch (DaoException e) {
			log.error(" update wrong : " + score);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + score);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Score> scoreList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (scoreList == null ? "null" : scoreList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(scoreList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Score score : scoreList) {
			score.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(scoreList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + scoreList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + scoreList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Score getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Score score = null;

		if (id == null) {
			return score;
		}

		try {
			score = (Score) dao.get(Score.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return score;		
		}	
		  
    	   
		@Override
		public List<Score> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Score> score = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Score>();
		}

		try {
			score = (List<Score>) dao.getList(Score.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (score == null ? "null" : score.size()));
    
		return score;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getScoreIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getScoreIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countScoreIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getScoreIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getScoreIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

