package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.School;
import com.ptteng.common.skill.service.SchoolService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SchoolServiceImpl extends BaseDaoServiceImpl implements SchoolService {


    private static final Log log = LogFactory.getLog(SchoolServiceImpl.class);


    @Override
    public Long insert(School school) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + school);

        if (school == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        school.setCreateAt(currentTimeMillis);
        school.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(school);
        } catch (DaoException e) {
            log.error(" insert wrong : " + school);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<School> insertList(List<School> schoolList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (schoolList == null ? "null" : schoolList.size()));

        List<School> resultList = null;

        if (CollectionUtils.isEmpty(schoolList)) {
            return new ArrayList<School>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (School school : schoolList) {
            school.setCreateAt(currentTimeMillis);
            school.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<School>) dao.batchSave(schoolList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + schoolList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(School.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(School school) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (school == null ? "null" : school.getId()));

        boolean result = false;

        if (school == null) {
            return true;
        }

        school.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(school);
        } catch (DaoException e) {
            log.error(" update wrong : " + school);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + school);
        }
        return result;
    }


    @Override
    public boolean updateList(List<School> schoolList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (schoolList == null ? "null" : schoolList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(schoolList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (School school : schoolList) {
            school.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(schoolList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + schoolList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + schoolList.size());

        return result;
    }


    @Override
    public School getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        School school = null;

        if (id == null) {
            return school;
        }

        try {
            school = (School) dao.get(School.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return school;
    }


    @Override
    public List<School> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<School> school = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<School>();
        }

        try {
            school = (List<School>) dao.getList(School.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (school == null ? "null" : school.size()));

        return school;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getSchoolIdByName(String name) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by name  : " + name);
        }
        Long id = null;
        try {
            id = (Long) dao.getMapping("getSchoolIdByName", new Object[]{name});
        } catch (DaoException e) {
            log.error(" get id wrong by name  : " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }


    @Override
    public List<Long> getSchoolIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getSchoolIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countSchoolIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getSchoolIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getSchoolIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

