package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Review;
import com.ptteng.common.skill.service.ReviewService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ReviewServiceImpl extends BaseDaoServiceImpl implements ReviewService {

 

	private static final Log log = LogFactory.getLog(ReviewServiceImpl.class);



		   
		@Override
		public Long insert(Review review)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + review);

		if (review == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		review.setCreateAt(currentTimeMillis);
		review.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(review);
		} catch (DaoException e) {
			log.error(" insert wrong : " + review);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Review> insertList(List<Review> reviewList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (reviewList == null ? "null" : reviewList.size()));
      
		List<Review> resultList = null;

		if (CollectionUtils.isEmpty(reviewList)) {
			return new ArrayList<Review>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Review review : reviewList) {
			review.setCreateAt(currentTimeMillis);
			review.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Review>) dao.batchSave(reviewList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + reviewList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Review.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Review review)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (review == null ? "null" : review.getId()));

		boolean result = false;

		if (review == null) {
			return true;
		}

		review.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(review);
		} catch (DaoException e) {
			log.error(" update wrong : " + review);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + review);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Review> reviewList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (reviewList == null ? "null" : reviewList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(reviewList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Review review : reviewList) {
			review.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(reviewList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + reviewList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + reviewList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Review getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Review review = null;

		if (id == null) {
			return review;
		}

		try {
			review = (Review) dao.get(Review.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return review;		
		}	
		  
    	   
		@Override
		public List<Review> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Review> review = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Review>();
		}

		try {
			review = (List<Review>) dao.getList(Review.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (review == null ? "null" : review.size()));
    
		return review;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getReviewIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getReviewIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countReviewIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getReviewIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getReviewIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getReviewIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countReviewIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getReviewIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getReviewIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

