package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.ProblemSubmitHistory;
import com.ptteng.common.skill.service.ProblemSubmitHistoryService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ProblemSubmitHistoryServiceImpl extends BaseDaoServiceImpl implements ProblemSubmitHistoryService {

 

	private static final Log log = LogFactory.getLog(ProblemSubmitHistoryServiceImpl.class);



		   
		@Override
		public Long insert(ProblemSubmitHistory problemSubmitHistory)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + problemSubmitHistory);

		if (problemSubmitHistory == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		problemSubmitHistory.setCreateAt(currentTimeMillis);
		problemSubmitHistory.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(problemSubmitHistory);
		} catch (DaoException e) {
			log.error(" insert wrong : " + problemSubmitHistory);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ProblemSubmitHistory> insertList(List<ProblemSubmitHistory> problemSubmitHistoryList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (problemSubmitHistoryList == null ? "null" : problemSubmitHistoryList.size()));
      
		List<ProblemSubmitHistory> resultList = null;

		if (CollectionUtils.isEmpty(problemSubmitHistoryList)) {
			return new ArrayList<ProblemSubmitHistory>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProblemSubmitHistory problemSubmitHistory : problemSubmitHistoryList) {
			problemSubmitHistory.setCreateAt(currentTimeMillis);
			problemSubmitHistory.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ProblemSubmitHistory>) dao.batchSave(problemSubmitHistoryList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + problemSubmitHistoryList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ProblemSubmitHistory.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ProblemSubmitHistory problemSubmitHistory)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (problemSubmitHistory == null ? "null" : problemSubmitHistory.getId()));

		boolean result = false;

		if (problemSubmitHistory == null) {
			return true;
		}

		problemSubmitHistory.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(problemSubmitHistory);
		} catch (DaoException e) {
			log.error(" update wrong : " + problemSubmitHistory);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + problemSubmitHistory);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProblemSubmitHistory> problemSubmitHistoryList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (problemSubmitHistoryList == null ? "null" : problemSubmitHistoryList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(problemSubmitHistoryList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProblemSubmitHistory problemSubmitHistory : problemSubmitHistoryList) {
			problemSubmitHistory.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(problemSubmitHistoryList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + problemSubmitHistoryList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + problemSubmitHistoryList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ProblemSubmitHistory getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ProblemSubmitHistory problemSubmitHistory = null;

		if (id == null) {
			return problemSubmitHistory;
		}

		try {
			problemSubmitHistory = (ProblemSubmitHistory) dao.get(ProblemSubmitHistory.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return problemSubmitHistory;		
		}	
		  
    	   
		@Override
		public List<ProblemSubmitHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ProblemSubmitHistory> problemSubmitHistory = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ProblemSubmitHistory>();
		}

		try {
			problemSubmitHistory = (List<ProblemSubmitHistory>) dao.getList(ProblemSubmitHistory.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (problemSubmitHistory == null ? "null" : problemSubmitHistory.size()));
    
		return problemSubmitHistory;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getProblemSubmitHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProblemSubmitHistoryIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProblemSubmitHistoryIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProblemSubmitHistoryIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProblemSubmitHistoryIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

