package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Problem;
import com.ptteng.common.skill.service.ProblemService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ProblemServiceImpl extends BaseDaoServiceImpl implements ProblemService {

 

	private static final Log log = LogFactory.getLog(ProblemServiceImpl.class);



		   
		@Override
		public Long insert(Problem problem)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + problem);

		if (problem == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		problem.setCreateAt(currentTimeMillis);
		problem.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(problem);
		} catch (DaoException e) {
			log.error(" insert wrong : " + problem);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Problem> insertList(List<Problem> problemList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (problemList == null ? "null" : problemList.size()));
      
		List<Problem> resultList = null;

		if (CollectionUtils.isEmpty(problemList)) {
			return new ArrayList<Problem>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Problem problem : problemList) {
			problem.setCreateAt(currentTimeMillis);
			problem.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Problem>) dao.batchSave(problemList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + problemList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Problem.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Problem problem)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (problem == null ? "null" : problem.getId()));

		boolean result = false;

		if (problem == null) {
			return true;
		}

		problem.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(problem);
		} catch (DaoException e) {
			log.error(" update wrong : " + problem);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + problem);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Problem> problemList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (problemList == null ? "null" : problemList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(problemList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Problem problem : problemList) {
			problem.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(problemList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + problemList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + problemList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Problem getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Problem problem = null;

		if (id == null) {
			return problem;
		}

		try {
			problem = (Problem) dao.get(Problem.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return problem;		
		}	
		  
    	   
		@Override
		public List<Problem> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Problem> problem = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Problem>();
		}

		try {
			problem = (List<Problem>) dao.getList(Problem.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (problem == null ? "null" : problem.size()));
    
		return problem;	
		}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long> getProblemIdsByStatus(Integer status, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		if (log.isInfoEnabled()) {
			log.info(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit);
		}
		List<Long> idList = null;
		// TODO 参数检查!
		if (start == null) {
			start = 0;
		}
		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		try {
			idList = dao
					.getIdList("getProblemIdsByStatus", new Object[]{status}, start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , "
					+ limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getProblemIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProblemIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProblemIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProblemIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProblemIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

