package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Portrait;
import com.ptteng.common.skill.service.PortraitService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class PortraitServiceImpl extends BaseDaoServiceImpl implements PortraitService {

 

	private static final Log log = LogFactory.getLog(PortraitServiceImpl.class);



		   
		@Override
		public Long insert(Portrait portrait)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + portrait);

		if (portrait == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		portrait.setCreateAt(currentTimeMillis);
		portrait.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(portrait);
		} catch (DaoException e) {
			log.error(" insert wrong : " + portrait);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Portrait> insertList(List<Portrait> portraitList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (portraitList == null ? "null" : portraitList.size()));
      
		List<Portrait> resultList = null;

		if (CollectionUtils.isEmpty(portraitList)) {
			return new ArrayList<Portrait>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Portrait portrait : portraitList) {
			portrait.setCreateAt(currentTimeMillis);
			portrait.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Portrait>) dao.batchSave(portraitList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + portraitList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Portrait.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Portrait portrait)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (portrait == null ? "null" : portrait.getId()));

		boolean result = false;

		if (portrait == null) {
			return true;
		}

		portrait.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(portrait);
		} catch (DaoException e) {
			log.error(" update wrong : " + portrait);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + portrait);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Portrait> portraitList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (portraitList == null ? "null" : portraitList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(portraitList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Portrait portrait : portraitList) {
			portrait.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(portraitList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + portraitList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + portraitList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Portrait getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Portrait portrait = null;

		if (id == null) {
			return portrait;
		}

		try {
			portrait = (Portrait) dao.get(Portrait.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return portrait;		
		}	
		  
    	   
		@Override
		public List<Portrait> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Portrait> portrait = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Portrait>();
		}

		try {
			portrait = (List<Portrait>) dao.getList(Portrait.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (portrait == null ? "null" : portrait.size()));
    
		return portrait;	
		}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long> getPortraitIdsByStatus(Integer status, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		if (log.isInfoEnabled()) {
			log.info(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit);
		}
		List<Long> idList = null;
		// TODO 参数检查!
		if (start == null) {
			start = 0;
		}
		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		try {
			idList = dao
					.getIdList("getPortraitIdsByStatus", new Object[]{status}, start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , "
					+ limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}










	@Override
	public List<Long> getPortraitIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getPortraitIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countPortraitIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getPortraitIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getPortraitIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

