package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Option;
import com.ptteng.common.skill.service.OptionService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class OptionServiceImpl extends BaseDaoServiceImpl implements OptionService {

 

	private static final Log log = LogFactory.getLog(OptionServiceImpl.class);



		   
		@Override
		public Long insert(Option option)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + option);

		if (option == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		option.setCreateAt(currentTimeMillis);
		option.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(option);
		} catch (DaoException e) {
			log.error(" insert wrong : " + option);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Option> insertList(List<Option> optionList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (optionList == null ? "null" : optionList.size()));
      
		List<Option> resultList = null;

		if (CollectionUtils.isEmpty(optionList)) {
			return new ArrayList<Option>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Option option : optionList) {
			option.setCreateAt(currentTimeMillis);
			option.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Option>) dao.batchSave(optionList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + optionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Option.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Option option)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (option == null ? "null" : option.getId()));

		boolean result = false;

		if (option == null) {
			return true;
		}

		option.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(option);
		} catch (DaoException e) {
			log.error(" update wrong : " + option);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + option);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Option> optionList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (optionList == null ? "null" : optionList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(optionList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Option option : optionList) {
			option.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(optionList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + optionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + optionList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Option getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Option option = null;

		if (id == null) {
			return option;
		}

		try {
			option = (Option) dao.get(Option.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return option;		
		}	
		  
    	   
		@Override
		public List<Option> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Option> option = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Option>();
		}

		try {
			option = (List<Option>) dao.getList(Option.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (option == null ? "null" : option.size()));
    
		return option;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getOptionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getOptionIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countOptionIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getOptionIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getOptionIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

