package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Counties;
import com.ptteng.common.skill.service.CountiesService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CountiesServiceImpl extends BaseDaoServiceImpl implements CountiesService {

 

	private static final Log log = LogFactory.getLog(CountiesServiceImpl.class);



		   
		@Override
		public Long insert(Counties counties)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + counties);

		if (counties == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		counties.setCreateAt(currentTimeMillis);
		counties.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(counties);
		} catch (DaoException e) {
			log.error(" insert wrong : " + counties);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Counties> insertList(List<Counties> countiesList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (countiesList == null ? "null" : countiesList.size()));
      
		List<Counties> resultList = null;

		if (CollectionUtils.isEmpty(countiesList)) {
			return new ArrayList<Counties>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Counties counties : countiesList) {
			counties.setCreateAt(currentTimeMillis);
			counties.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Counties>) dao.batchSave(countiesList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + countiesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Counties.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Counties counties)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (counties == null ? "null" : counties.getId()));

		boolean result = false;

		if (counties == null) {
			return true;
		}

		counties.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(counties);
		} catch (DaoException e) {
			log.error(" update wrong : " + counties);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + counties);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Counties> countiesList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (countiesList == null ? "null" : countiesList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(countiesList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Counties counties : countiesList) {
			counties.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(countiesList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + countiesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + countiesList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Counties getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Counties counties = null;

		if (id == null) {
			return counties;
		}

		try {
			counties = (Counties) dao.get(Counties.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return counties;		
		}	
		  
    	   
		@Override
		public List<Counties> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Counties> counties = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Counties>();
		}

		try {
			counties = (List<Counties>) dao.getList(Counties.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (counties == null ? "null" : counties.size()));
    
		return counties;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCountiesIdByCounty(String county)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by county  : " + county );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getCountiesIdByCounty", new Object[] {county });
   } catch (DaoException e) {
			log.error(" get id wrong by county  : " + county );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCountiesIdsByCityIdOrderByCreateAt(Long cityId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by cityId,start,limit  : " + cityId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCountiesIdsByCityIdOrderByCreateAt", new Object[] { cityId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by cityId,start,limit)  : " + cityId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCountiesIdsByCityIdOrderByCreateAt(Long cityId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by cityId  : " + cityId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCountiesIdsByCityIdOrderByCreateAt", new Object[] { cityId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by cityId)  : " + cityId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCountiesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCountiesIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCountiesIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCountiesIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCountiesIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

